% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_config_rule_evaluation_status}
\alias{configservice_describe_config_rule_evaluation_status}
\title{Returns status information for each of your Config managed rules}
\usage{
configservice_describe_config_rule_evaluation_status(
  ConfigRuleNames = NULL,
  NextToken = NULL,
  Limit = NULL
)
}
\arguments{
\item{ConfigRuleNames}{The name of the Config managed rules for which you want status
information. If you do not specify any names, Config returns status
information for all Config managed rules that you use.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}

\item{Limit}{The number of rule evaluation results that you want returned.

This parameter is required if the rule limit for your account is more
than the default of 150 rules.

For information about requesting a rule limit increase, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config}{Config Limits}
in the \emph{Amazon Web Services General Reference Guide}.}
}
\description{
Returns status information for each of your Config managed rules. The status includes information such as the last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the last failure.

See \url{https://www.paws-r-sdk.com/docs/configservice_describe_config_rule_evaluation_status/} for full documentation.
}
\keyword{internal}
