# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include servicecatalog_service.R
NULL

#' Accepts an offer to share the specified portfolio
#'
#' @description
#' Accepts an offer to share the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_accept_portfolio_share/](https://www.paws-r-sdk.com/docs/servicecatalog_accept_portfolio_share/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PortfolioShareType The type of shared portfolios to accept. The default is to accept
#' imported portfolios.
#' 
#' -   `AWS_ORGANIZATIONS` - Accept portfolios shared by the management
#'     account of your organization.
#' 
#' -   `IMPORTED` - Accept imported portfolios.
#' 
#' -   `AWS_SERVICECATALOG` - Not supported. (Throws
#'     ResourceNotFoundException.)
#' 
#' For example,
#' `aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS`
#'
#' @keywords internal
#'
#' @rdname servicecatalog_accept_portfolio_share
servicecatalog_accept_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, PortfolioShareType = NULL) {
  op <- new_operation(
    name = "AcceptPortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$accept_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PortfolioShareType = PortfolioShareType)
  output <- .servicecatalog$accept_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$accept_portfolio_share <- servicecatalog_accept_portfolio_share

#' Associates the specified budget with the specified resource
#'
#' @description
#' Associates the specified budget with the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_associate_budget_with_resource/](https://www.paws-r-sdk.com/docs/servicecatalog_associate_budget_with_resource/) for full documentation.
#'
#' @param BudgetName &#91;required&#93; The name of the budget you want to associate.
#' @param ResourceId &#91;required&#93; The resource identifier. Either a portfolio-id or a product-id.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_budget_with_resource
servicecatalog_associate_budget_with_resource <- function(BudgetName, ResourceId) {
  op <- new_operation(
    name = "AssociateBudgetWithResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_budget_with_resource_input(BudgetName = BudgetName, ResourceId = ResourceId)
  output <- .servicecatalog$associate_budget_with_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_budget_with_resource <- servicecatalog_associate_budget_with_resource

#' Associates the specified principal ARN with the specified portfolio
#'
#' @description
#' Associates the specified principal ARN with the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_associate_principal_with_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_associate_principal_with_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PrincipalARN &#91;required&#93; The ARN of the principal (user, role, or group). If the `PrincipalType`
#' is `IAM`, the supported value is a fully defined [IAM Amazon Resource
#' Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
#' If the `PrincipalType` is `IAM_PATTERN`, the supported value is an `IAM`
#' ARN *without an AccountID* in the following format:
#' 
#' *arn:partition:iam:::resource-type/resource-id*
#' 
#' The ARN resource-id can be either:
#' 
#' -   A fully formed resource-id. For example,
#'     *arn:aws:iam:::role/resource-name* or
#'     *arn:aws:iam:::role/resource-path/resource-name*
#' 
#' -   A wildcard ARN. The wildcard ARN accepts `IAM_PATTERN` values with a
#'     "*" or "?" in the resource-id segment of the ARN. For example
#'     *arn:partition:service:::resource-type/resource-path/resource-name*.
#'     The new symbols are exclusive to the **resource-path** and
#'     **resource-name** and cannot replace the **resource-type** or other
#'     ARN values.
#' 
#'     The ARN path and principal name allow unlimited wildcard characters.
#' 
#' Examples of an **acceptable** wildcard ARN:
#' 
#' -   arn:aws:iam:::role/ResourceName_*
#' 
#' -   arn:aws:iam:::role/*/ResourceName_?
#' 
#' Examples of an **unacceptable** wildcard ARN:
#' 
#' -   arn:aws:iam:::*/ResourceName
#' 
#' You can associate multiple `IAM_PATTERN`s even if the account has no
#' principal with that name.
#' 
#' The "?" wildcard character matches zero or one of any character. This is
#' similar to ".?" in regular regex context. The "*" wildcard character
#' matches any number of any characters. This is similar to ".*" in
#' regular regex context.
#' 
#' In the IAM Principal ARN format
#' (*arn:partition:iam:::resource-type/resource-path/resource-name*), valid
#' resource-type values include **user/**, **group/**, or **role/**. The
#' "?" and "*" characters are allowed only after the resource-type in the
#' resource-id segment. You can use special characters anywhere within the
#' resource-id.
#' 
#' The "&#42;" character also matches the "/" character, allowing paths to be
#' formed \emph{within} the resource-id. For example,
#' \emph{arn:aws:iam:::role/&#42;/ResourceName_?} matches both
#' \emph{arn:aws:iam:::role/pathA/pathB/ResourceName_1} and
#' \emph{arn:aws:iam:::role/pathA/ResourceName_1}.
#' @param PrincipalType &#91;required&#93; The principal type. The supported value is `IAM` if you use a fully
#' defined Amazon Resource Name (ARN), or `IAM_PATTERN` if you use an ARN
#' with no `accountID`, with or without wildcard characters.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_principal_with_portfolio
servicecatalog_associate_principal_with_portfolio <- function(AcceptLanguage = NULL, PortfolioId, PrincipalARN, PrincipalType) {
  op <- new_operation(
    name = "AssociatePrincipalWithPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_principal_with_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PrincipalARN = PrincipalARN, PrincipalType = PrincipalType)
  output <- .servicecatalog$associate_principal_with_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_principal_with_portfolio <- servicecatalog_associate_principal_with_portfolio

#' Associates the specified product with the specified portfolio
#'
#' @description
#' Associates the specified product with the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_associate_product_with_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_associate_product_with_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param SourcePortfolioId The identifier of the source portfolio.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_product_with_portfolio
servicecatalog_associate_product_with_portfolio <- function(AcceptLanguage = NULL, ProductId, PortfolioId, SourcePortfolioId = NULL) {
  op <- new_operation(
    name = "AssociateProductWithPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_product_with_portfolio_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PortfolioId = PortfolioId, SourcePortfolioId = SourcePortfolioId)
  output <- .servicecatalog$associate_product_with_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_product_with_portfolio <- servicecatalog_associate_product_with_portfolio

#' Associates a self-service action with a provisioning artifact
#'
#' @description
#' Associates a self-service action with a provisioning artifact.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_associate_service_action_with_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_associate_service_action_with_provisioning_artifact/) for full documentation.
#'
#' @param ProductId &#91;required&#93; The product identifier. For example, `prod-abcdzk7xy33qa`.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact. For example,
#' `pa-4abcdjnxjj6ne`.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associ_servic_action_with_provis_artifa
servicecatalog_associate_service_action_with_provisioning_artifact <- function(ProductId, ProvisioningArtifactId, ServiceActionId, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "AssociateServiceActionWithProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_service_action_with_provisioning_artifact_input(ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, ServiceActionId = ServiceActionId, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$associate_service_action_with_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_service_action_with_provisioning_artifact <- servicecatalog_associate_service_action_with_provisioning_artifact

#' Associate the specified TagOption with the specified portfolio or
#' product
#'
#' @description
#' Associate the specified TagOption with the specified portfolio or product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_associate_tag_option_with_resource/](https://www.paws-r-sdk.com/docs/servicecatalog_associate_tag_option_with_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The resource identifier.
#' @param TagOptionId &#91;required&#93; The TagOption identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_associate_tag_option_with_resource
servicecatalog_associate_tag_option_with_resource <- function(ResourceId, TagOptionId) {
  op <- new_operation(
    name = "AssociateTagOptionWithResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$associate_tag_option_with_resource_input(ResourceId = ResourceId, TagOptionId = TagOptionId)
  output <- .servicecatalog$associate_tag_option_with_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$associate_tag_option_with_resource <- servicecatalog_associate_tag_option_with_resource

#' Associates multiple self-service actions with provisioning artifacts
#'
#' @description
#' Associates multiple self-service actions with provisioning artifacts.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_batch_associate_service_action_with_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_batch_associate_service_action_with_provisioning_artifact/) for full documentation.
#'
#' @param ServiceActionAssociations &#91;required&#93; One or more associations, each consisting of the Action ID, the Product
#' ID, and the Provisioning Artifact ID.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_batch_assoc_servi_actio_with_provi_artif
servicecatalog_batch_associate_service_action_with_provisioning_artifact <- function(ServiceActionAssociations, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "BatchAssociateServiceActionWithProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$batch_associate_service_action_with_provisioning_artifact_input(ServiceActionAssociations = ServiceActionAssociations, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$batch_associate_service_action_with_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$batch_associate_service_action_with_provisioning_artifact <- servicecatalog_batch_associate_service_action_with_provisioning_artifact

#' Disassociates a batch of self-service actions from the specified
#' provisioning artifact
#'
#' @description
#' Disassociates a batch of self-service actions from the specified provisioning artifact.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_batch_disassociate_service_action_from_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_batch_disassociate_service_action_from_provisioning_artifact/) for full documentation.
#'
#' @param ServiceActionAssociations &#91;required&#93; One or more associations, each consisting of the Action ID, the Product
#' ID, and the Provisioning Artifact ID.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_batch_disas_servi_actio_from_provi_artif
servicecatalog_batch_disassociate_service_action_from_provisioning_artifact <- function(ServiceActionAssociations, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "BatchDisassociateServiceActionFromProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$batch_disassociate_service_action_from_provisioning_artifact_input(ServiceActionAssociations = ServiceActionAssociations, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$batch_disassociate_service_action_from_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$batch_disassociate_service_action_from_provisioning_artifact <- servicecatalog_batch_disassociate_service_action_from_provisioning_artifact

#' Copies the specified source product to the specified target product or a
#' new product
#'
#' @description
#' Copies the specified source product to the specified target product or a new product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_copy_product/](https://www.paws-r-sdk.com/docs/servicecatalog_copy_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param SourceProductArn &#91;required&#93; The Amazon Resource Name (ARN) of the source product.
#' @param TargetProductId The identifier of the target product. By default, a new product is
#' created.
#' @param TargetProductName A name for the target product. The default is the name of the source
#' product.
#' @param SourceProvisioningArtifactIdentifiers The identifiers of the provisioning artifacts (also known as versions)
#' of the product to copy. By default, all provisioning artifacts are
#' copied.
#' @param CopyOptions The copy options. If the value is `CopyTags`, the tags from the source
#' product are copied to the target product.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_copy_product
servicecatalog_copy_product <- function(AcceptLanguage = NULL, SourceProductArn, TargetProductId = NULL, TargetProductName = NULL, SourceProvisioningArtifactIdentifiers = NULL, CopyOptions = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CopyProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$copy_product_input(AcceptLanguage = AcceptLanguage, SourceProductArn = SourceProductArn, TargetProductId = TargetProductId, TargetProductName = TargetProductName, SourceProvisioningArtifactIdentifiers = SourceProvisioningArtifactIdentifiers, CopyOptions = CopyOptions, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$copy_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$copy_product <- servicecatalog_copy_product

#' Creates a constraint
#'
#' @description
#' Creates a constraint.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_constraint/](https://www.paws-r-sdk.com/docs/servicecatalog_create_constraint/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param ProductId &#91;required&#93; The product identifier.
#' @param Parameters &#91;required&#93; The constraint parameters, in JSON format. The syntax depends on the
#' constraint type as follows:
#' 
#' **LAUNCH**
#' 
#' You are required to specify either the `RoleArn` or the `LocalRoleName`
#' but can't use both.
#' 
#' Specify the `RoleArn` property as follows:
#' 
#' `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
#' 
#' Specify the `LocalRoleName` property as follows:
#' 
#' `{"LocalRoleName": "SCBasicLaunchRole"}`
#' 
#' If you specify the `LocalRoleName` property, when an account uses the
#' launch constraint, the IAM role with that name in the account will be
#' used. This allows launch-role constraints to be account-agnostic so the
#' administrator can create fewer resources per shared account.
#' 
#' The given role name must exist in the account used to create the launch
#' constraint and the account of the user who launches a product with this
#' launch constraint.
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `LAUNCH` constraint on a product and
#' portfolio.
#' 
#' **NOTIFICATION**
#' 
#' Specify the `NotificationArns` property as follows:
#' 
#' `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
#' 
#' **RESOURCE_UPDATE**
#' 
#' Specify the `TagUpdatesOnProvisionedProduct` property as follows:
#' 
#' `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
#' 
#' The `TagUpdatesOnProvisionedProduct` property accepts a string value of
#' `ALLOWED` or `NOT_ALLOWED`.
#' 
#' **STACKSET**
#' 
#' Specify the `Parameters` property as follows:
#' 
#' `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `STACKSET` constraint on a product
#' and portfolio.
#' 
#' Products with a `STACKSET` constraint will launch an CloudFormation
#' stack set.
#' 
#' **TEMPLATE**
#' 
#' Specify the `Rules` property. For more information, see [Template
#' Constraint
#' Rules](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
#' @param Type &#91;required&#93; The type of constraint.
#' 
#' -   `LAUNCH`
#' 
#' -   `NOTIFICATION`
#' 
#' -   `RESOURCE_UPDATE`
#' 
#' -   `STACKSET`
#' 
#' -   `TEMPLATE`
#' @param Description The description of the constraint.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_constraint
servicecatalog_create_constraint <- function(AcceptLanguage = NULL, PortfolioId, ProductId, Parameters, Type, Description = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreateConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_constraint_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, ProductId = ProductId, Parameters = Parameters, Type = Type, Description = Description, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_constraint <- servicecatalog_create_constraint

#' Creates a portfolio
#'
#' @description
#' Creates a portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_create_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param DisplayName &#91;required&#93; The name to use for display purposes.
#' @param Description The description of the portfolio.
#' @param ProviderName &#91;required&#93; The name of the portfolio provider.
#' @param Tags One or more tags.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_portfolio
servicecatalog_create_portfolio <- function(AcceptLanguage = NULL, DisplayName, Description = NULL, ProviderName, Tags = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreatePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_portfolio_input(AcceptLanguage = AcceptLanguage, DisplayName = DisplayName, Description = Description, ProviderName = ProviderName, Tags = Tags, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_portfolio <- servicecatalog_create_portfolio

#' Shares the specified portfolio with the specified account or
#' organization node
#'
#' @description
#' Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_portfolio_share/](https://www.paws-r-sdk.com/docs/servicecatalog_create_portfolio_share/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param AccountId The Amazon Web Services account ID. For example, `123456789012`.
#' @param OrganizationNode The organization node to whom you are going to share. When you pass
#' `OrganizationNode`, it creates `PortfolioShare` for all of the Amazon
#' Web Services accounts that are associated to the `OrganizationNode`. The
#' output returns a `PortfolioShareToken`, which enables the administrator
#' to monitor the status of the `PortfolioShare` creation process.
#' @param ShareTagOptions Enables or disables `TagOptions ` sharing when creating the portfolio
#' share. If this flag is not provided, TagOptions sharing is disabled.
#' @param SharePrincipals Enables or disables `Principal` sharing when creating the portfolio
#' share. If this flag is not provided, principal sharing is disabled.
#' 
#' When you enable Principal Name Sharing for a portfolio share, the share
#' recipient account end users with a principal that matches any of the
#' associated IAM patterns can provision products from the portfolio. Once
#' shared, the share recipient can view associations of `PrincipalType`:
#' `IAM_PATTERN` on their portfolio. You can create the principals in the
#' recipient account before or after creating the share.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_portfolio_share
servicecatalog_create_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, AccountId = NULL, OrganizationNode = NULL, ShareTagOptions = NULL, SharePrincipals = NULL) {
  op <- new_operation(
    name = "CreatePortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, AccountId = AccountId, OrganizationNode = OrganizationNode, ShareTagOptions = ShareTagOptions, SharePrincipals = SharePrincipals)
  output <- .servicecatalog$create_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_portfolio_share <- servicecatalog_create_portfolio_share

#' Creates a product
#'
#' @description
#' Creates a product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_product/](https://www.paws-r-sdk.com/docs/servicecatalog_create_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Name &#91;required&#93; The name of the product.
#' @param Owner &#91;required&#93; The owner of the product.
#' @param Description The description of the product.
#' @param Distributor The distributor of the product.
#' @param SupportDescription The support information about the product.
#' @param SupportEmail The contact email for product support.
#' @param SupportUrl The contact URL for product support.
#' 
#' `^https?:\/\// `/ is the pattern used to validate SupportUrl.
#' @param ProductType &#91;required&#93; The type of product.
#' @param Tags One or more tags.
#' @param ProvisioningArtifactParameters The configuration of the provisioning artifact.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#' @param SourceConnection Specifies connection details for the created product and syncs the
#' product to the connection source artifact. This automatically manages
#' the product's artifacts based on changes to the source. The
#' `SourceConnection` parameter consists of the following sub-fields.
#' 
#' -   `Type`
#' 
#' -   `ConnectionParamters`
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_product
servicecatalog_create_product <- function(AcceptLanguage = NULL, Name, Owner, Description = NULL, Distributor = NULL, SupportDescription = NULL, SupportEmail = NULL, SupportUrl = NULL, ProductType, Tags = NULL, ProvisioningArtifactParameters = NULL, IdempotencyToken, SourceConnection = NULL) {
  op <- new_operation(
    name = "CreateProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_product_input(AcceptLanguage = AcceptLanguage, Name = Name, Owner = Owner, Description = Description, Distributor = Distributor, SupportDescription = SupportDescription, SupportEmail = SupportEmail, SupportUrl = SupportUrl, ProductType = ProductType, Tags = Tags, ProvisioningArtifactParameters = ProvisioningArtifactParameters, IdempotencyToken = IdempotencyToken, SourceConnection = SourceConnection)
  output <- .servicecatalog$create_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_product <- servicecatalog_create_product

#' Creates a plan
#'
#' @description
#' Creates a plan.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_provisioned_product_plan/](https://www.paws-r-sdk.com/docs/servicecatalog_create_provisioned_product_plan/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanName &#91;required&#93; The name of the plan.
#' @param PlanType &#91;required&#93; The plan type.
#' @param NotificationArns Passed to CloudFormation. The SNS topic ARNs to which to publish
#' stack-related events.
#' @param PathId The path identifier of the product. This value is optional if the
#' product has a default path, and required if the product has more than
#' one path. To list the paths for a product, use
#' [`list_launch_paths`][servicecatalog_list_launch_paths].
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisionedProductName &#91;required&#93; A user-friendly name for the provisioned product. This value must be
#' unique for the Amazon Web Services account and cannot be updated after
#' the product is provisioned.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#' @param ProvisioningParameters Parameters specified by the administrator that are required for
#' provisioning the product.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#' @param Tags One or more tags.
#' 
#' If the plan is for an existing provisioned product, the product must
#' have a `RESOURCE_UPDATE` constraint with
#' `TagUpdatesOnProvisionedProduct` set to `ALLOWED` to allow tag updates.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_provisioned_product_plan
servicecatalog_create_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanName, PlanType, NotificationArns = NULL, PathId = NULL, ProductId, ProvisionedProductName, ProvisioningArtifactId, ProvisioningParameters = NULL, IdempotencyToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanName = PlanName, PlanType = PlanType, NotificationArns = NotificationArns, PathId = PathId, ProductId = ProductId, ProvisionedProductName = ProvisionedProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningParameters = ProvisioningParameters, IdempotencyToken = IdempotencyToken, Tags = Tags)
  output <- .servicecatalog$create_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_provisioned_product_plan <- servicecatalog_create_provisioned_product_plan

#' Creates a provisioning artifact (also known as a version) for the
#' specified product
#'
#' @description
#' Creates a provisioning artifact (also known as a version) for the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_create_provisioning_artifact/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param Parameters &#91;required&#93; The configuration for the provisioning artifact.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_provisioning_artifact
servicecatalog_create_provisioning_artifact <- function(AcceptLanguage = NULL, ProductId, Parameters, IdempotencyToken) {
  op <- new_operation(
    name = "CreateProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, Parameters = Parameters, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_provisioning_artifact <- servicecatalog_create_provisioning_artifact

#' Creates a self-service action
#'
#' @description
#' Creates a self-service action.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_service_action/](https://www.paws-r-sdk.com/docs/servicecatalog_create_service_action/) for full documentation.
#'
#' @param Name &#91;required&#93; The self-service action name.
#' @param DefinitionType &#91;required&#93; The service action definition type. For example, `SSM_AUTOMATION`.
#' @param Definition &#91;required&#93; The self-service action definition. Can be one of the following:
#' 
#' **Name**
#' 
#' The name of the Amazon Web Services Systems Manager document (SSM
#' document). For example, `AWS-RestartEC2Instance`.
#' 
#' If you are using a shared SSM document, you must provide the ARN instead
#' of the name.
#' 
#' **Version**
#' 
#' The Amazon Web Services Systems Manager automation document version. For
#' example, `"Version": "1"`
#' 
#' **AssumeRole**
#' 
#' The Amazon Resource Name (ARN) of the role that performs the
#' self-service actions on your behalf. For example,
#' `"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"`.
#' 
#' To reuse the provisioned product launch role, set to
#' `"AssumeRole": "LAUNCH_ROLE"`.
#' 
#' **Parameters**
#' 
#' The list of parameters in JSON format.
#' 
#' For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or
#' `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
#' @param Description The self-service action description.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_service_action
servicecatalog_create_service_action <- function(Name, DefinitionType, Definition, Description = NULL, AcceptLanguage = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreateServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_service_action_input(Name = Name, DefinitionType = DefinitionType, Definition = Definition, Description = Description, AcceptLanguage = AcceptLanguage, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$create_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_service_action <- servicecatalog_create_service_action

#' Creates a TagOption
#'
#' @description
#' Creates a TagOption.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_create_tag_option/](https://www.paws-r-sdk.com/docs/servicecatalog_create_tag_option/) for full documentation.
#'
#' @param Key &#91;required&#93; The TagOption key.
#' @param Value &#91;required&#93; The TagOption value.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_create_tag_option
servicecatalog_create_tag_option <- function(Key, Value) {
  op <- new_operation(
    name = "CreateTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$create_tag_option_input(Key = Key, Value = Value)
  output <- .servicecatalog$create_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$create_tag_option <- servicecatalog_create_tag_option

#' Deletes the specified constraint
#'
#' @description
#' Deletes the specified constraint.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_constraint/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_constraint/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The identifier of the constraint.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_constraint
servicecatalog_delete_constraint <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DeleteConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_constraint_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$delete_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_constraint <- servicecatalog_delete_constraint

#' Deletes the specified portfolio
#'
#' @description
#' Deletes the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The portfolio identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_portfolio
servicecatalog_delete_portfolio <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DeletePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_portfolio_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$delete_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_portfolio <- servicecatalog_delete_portfolio

#' Stops sharing the specified portfolio with the specified account or
#' organization node
#'
#' @description
#' Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_portfolio_share/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_portfolio_share/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param AccountId The Amazon Web Services account ID.
#' @param OrganizationNode The organization node to whom you are going to stop sharing.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_portfolio_share
servicecatalog_delete_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, AccountId = NULL, OrganizationNode = NULL) {
  op <- new_operation(
    name = "DeletePortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, AccountId = AccountId, OrganizationNode = OrganizationNode)
  output <- .servicecatalog$delete_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_portfolio_share <- servicecatalog_delete_portfolio_share

#' Deletes the specified product
#'
#' @description
#' Deletes the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_product/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The product identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_product
servicecatalog_delete_product <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DeleteProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_product_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$delete_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_product <- servicecatalog_delete_product

#' Deletes the specified plan
#'
#' @description
#' Deletes the specified plan.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_provisioned_product_plan/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_provisioned_product_plan/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanId &#91;required&#93; The plan identifier.
#' @param IgnoreErrors If set to true, Service Catalog stops managing the specified provisioned
#' product even if it cannot delete the underlying resources.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_provisioned_product_plan
servicecatalog_delete_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanId, IgnoreErrors = NULL) {
  op <- new_operation(
    name = "DeleteProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanId = PlanId, IgnoreErrors = IgnoreErrors)
  output <- .servicecatalog$delete_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_provisioned_product_plan <- servicecatalog_delete_provisioned_product_plan

#' Deletes the specified provisioning artifact (also known as a version)
#' for the specified product
#'
#' @description
#' Deletes the specified provisioning artifact (also known as a version) for the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_provisioning_artifact/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_provisioning_artifact
servicecatalog_delete_provisioning_artifact <- function(AcceptLanguage = NULL, ProductId, ProvisioningArtifactId) {
  op <- new_operation(
    name = "DeleteProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId)
  output <- .servicecatalog$delete_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_provisioning_artifact <- servicecatalog_delete_provisioning_artifact

#' Deletes a self-service action
#'
#' @description
#' Deletes a self-service action.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_service_action/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_service_action/) for full documentation.
#'
#' @param Id &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_service_action
servicecatalog_delete_service_action <- function(Id, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DeleteServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_service_action_input(Id = Id, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$delete_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_service_action <- servicecatalog_delete_service_action

#' Deletes the specified TagOption
#'
#' @description
#' Deletes the specified TagOption.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_delete_tag_option/](https://www.paws-r-sdk.com/docs/servicecatalog_delete_tag_option/) for full documentation.
#'
#' @param Id &#91;required&#93; The TagOption identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_delete_tag_option
servicecatalog_delete_tag_option <- function(Id) {
  op <- new_operation(
    name = "DeleteTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$delete_tag_option_input(Id = Id)
  output <- .servicecatalog$delete_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$delete_tag_option <- servicecatalog_delete_tag_option

#' Gets information about the specified constraint
#'
#' @description
#' Gets information about the specified constraint.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_constraint/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_constraint/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The identifier of the constraint.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_constraint
servicecatalog_describe_constraint <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DescribeConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_constraint_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$describe_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_constraint <- servicecatalog_describe_constraint

#' Gets the status of the specified copy product operation
#'
#' @description
#' Gets the status of the specified copy product operation.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_copy_product_status/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_copy_product_status/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param CopyProductToken &#91;required&#93; The token for the copy product operation. This token is returned by
#' [`copy_product`][servicecatalog_copy_product].
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_copy_product_status
servicecatalog_describe_copy_product_status <- function(AcceptLanguage = NULL, CopyProductToken) {
  op <- new_operation(
    name = "DescribeCopyProductStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_copy_product_status_input(AcceptLanguage = AcceptLanguage, CopyProductToken = CopyProductToken)
  output <- .servicecatalog$describe_copy_product_status_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_copy_product_status <- servicecatalog_describe_copy_product_status

#' Gets information about the specified portfolio
#'
#' @description
#' Gets information about the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The portfolio identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_portfolio
servicecatalog_describe_portfolio <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DescribePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_portfolio_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$describe_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_portfolio <- servicecatalog_describe_portfolio

#' Gets the status of the specified portfolio share operation
#'
#' @description
#' Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_portfolio_share_status/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_portfolio_share_status/) for full documentation.
#'
#' @param PortfolioShareToken &#91;required&#93; The token for the portfolio share operation. This token is returned
#' either by CreatePortfolioShare or by DeletePortfolioShare.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_portfolio_share_status
servicecatalog_describe_portfolio_share_status <- function(PortfolioShareToken) {
  op <- new_operation(
    name = "DescribePortfolioShareStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_portfolio_share_status_input(PortfolioShareToken = PortfolioShareToken)
  output <- .servicecatalog$describe_portfolio_share_status_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_portfolio_share_status <- servicecatalog_describe_portfolio_share_status

#' Returns a summary of each of the portfolio shares that were created for
#' the specified portfolio
#'
#' @description
#' Returns a summary of each of the portfolio shares that were created for the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_portfolio_shares/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_portfolio_shares/) for full documentation.
#'
#' @param PortfolioId &#91;required&#93; The unique identifier of the portfolio for which shares will be
#' retrieved.
#' @param Type &#91;required&#93; The type of portfolio share to summarize. This field acts as a filter on
#' the type of portfolio share, which can be one of the following:
#' 
#' 1\. `ACCOUNT` - Represents an external account to account share.
#' 
#' 2\. `ORGANIZATION` - Represents a share to an organization. This share
#' is available to every account in the organization.
#' 
#' 3\. `ORGANIZATIONAL_UNIT` - Represents a share to an organizational
#' unit.
#' 
#' 4\. `ORGANIZATION_MEMBER_ACCOUNT` - Represents a share to an account in
#' the organization.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_portfolio_shares
servicecatalog_describe_portfolio_shares <- function(PortfolioId, Type, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribePortfolioShares",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$describe_portfolio_shares_input(PortfolioId = PortfolioId, Type = Type, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$describe_portfolio_shares_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_portfolio_shares <- servicecatalog_describe_portfolio_shares

#' Gets information about the specified product
#'
#' @description
#' Gets information about the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_product/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id The product identifier.
#' @param Name The product name.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_product
servicecatalog_describe_product <- function(AcceptLanguage = NULL, Id = NULL, Name = NULL) {
  op <- new_operation(
    name = "DescribeProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_product_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name)
  output <- .servicecatalog$describe_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_product <- servicecatalog_describe_product

#' Gets information about the specified product
#'
#' @description
#' Gets information about the specified product. This operation is run with administrator access.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_product_as_admin/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_product_as_admin/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id The product identifier.
#' @param Name The product name.
#' @param SourcePortfolioId The unique identifier of the shared portfolio that the specified product
#' is associated with.
#' 
#' You can provide this parameter to retrieve the shared TagOptions
#' associated with the product. If this parameter is provided and if
#' TagOptions sharing is enabled in the portfolio share, the API returns
#' both local and shared TagOptions associated with the product. Otherwise
#' only local TagOptions will be returned.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_product_as_admin
servicecatalog_describe_product_as_admin <- function(AcceptLanguage = NULL, Id = NULL, Name = NULL, SourcePortfolioId = NULL) {
  op <- new_operation(
    name = "DescribeProductAsAdmin",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_product_as_admin_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name, SourcePortfolioId = SourcePortfolioId)
  output <- .servicecatalog$describe_product_as_admin_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_product_as_admin <- servicecatalog_describe_product_as_admin

#' Gets information about the specified product
#'
#' @description
#' Gets information about the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_product_view/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_product_view/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The product view identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_product_view
servicecatalog_describe_product_view <- function(AcceptLanguage = NULL, Id) {
  op <- new_operation(
    name = "DescribeProductView",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_product_view_input(AcceptLanguage = AcceptLanguage, Id = Id)
  output <- .servicecatalog$describe_product_view_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_product_view <- servicecatalog_describe_product_view

#' Gets information about the specified provisioned product
#'
#' @description
#' Gets information about the specified provisioned product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioned_product/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioned_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id The provisioned product identifier. You must provide the name or ID, but
#' not both.
#' 
#' If you do not provide a name or ID, or you provide both name and ID, an
#' `InvalidParametersException` will occur.
#' @param Name The name of the provisioned product. You must provide the name or ID,
#' but not both.
#' 
#' If you do not provide a name or ID, or you provide both name and ID, an
#' `InvalidParametersException` will occur.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioned_product
servicecatalog_describe_provisioned_product <- function(AcceptLanguage = NULL, Id = NULL, Name = NULL) {
  op <- new_operation(
    name = "DescribeProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioned_product_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name)
  output <- .servicecatalog$describe_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioned_product <- servicecatalog_describe_provisioned_product

#' Gets information about the resource changes for the specified plan
#'
#' @description
#' Gets information about the resource changes for the specified plan.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioned_product_plan/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioned_product_plan/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanId &#91;required&#93; The plan identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioned_product_plan
servicecatalog_describe_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "DescribeProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanId = PlanId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$describe_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioned_product_plan <- servicecatalog_describe_provisioned_product_plan

#' Gets information about the specified provisioning artifact (also known
#' as a version) for the specified product
#'
#' @description
#' Gets information about the specified provisioning artifact (also known as a version) for the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioning_artifact/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisioningArtifactId The identifier of the provisioning artifact.
#' @param ProductId The product identifier.
#' @param ProvisioningArtifactName The provisioning artifact name.
#' @param ProductName The product name.
#' @param Verbose Indicates whether a verbose level of detail is enabled.
#' @param IncludeProvisioningArtifactParameters Indicates if the API call response does or does not include additional
#' details about the provisioning parameters.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioning_artifact
servicecatalog_describe_provisioning_artifact <- function(AcceptLanguage = NULL, ProvisioningArtifactId = NULL, ProductId = NULL, ProvisioningArtifactName = NULL, ProductName = NULL, Verbose = NULL, IncludeProvisioningArtifactParameters = NULL) {
  op <- new_operation(
    name = "DescribeProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProvisioningArtifactId = ProvisioningArtifactId, ProductId = ProductId, ProvisioningArtifactName = ProvisioningArtifactName, ProductName = ProductName, Verbose = Verbose, IncludeProvisioningArtifactParameters = IncludeProvisioningArtifactParameters)
  output <- .servicecatalog$describe_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioning_artifact <- servicecatalog_describe_provisioning_artifact

#' Gets information about the configuration required to provision the
#' specified product using the specified provisioning artifact
#'
#' @description
#' Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioning_parameters/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioning_parameters/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId The product identifier. You must provide the product name or ID, but not
#' both.
#' @param ProductName The name of the product. You must provide the name or ID, but not both.
#' @param ProvisioningArtifactId The identifier of the provisioning artifact. You must provide the name
#' or ID, but not both.
#' @param ProvisioningArtifactName The name of the provisioning artifact. You must provide the name or ID,
#' but not both.
#' @param PathId The path identifier of the product. This value is optional if the
#' product has a default path, and required if the product has more than
#' one path. To list the paths for a product, use
#' [`list_launch_paths`][servicecatalog_list_launch_paths]. You must
#' provide the name or ID, but not both.
#' @param PathName The name of the path. You must provide the name or ID, but not both.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_provisioning_parameters
servicecatalog_describe_provisioning_parameters <- function(AcceptLanguage = NULL, ProductId = NULL, ProductName = NULL, ProvisioningArtifactId = NULL, ProvisioningArtifactName = NULL, PathId = NULL, PathName = NULL) {
  op <- new_operation(
    name = "DescribeProvisioningParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_provisioning_parameters_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProductName = ProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningArtifactName = ProvisioningArtifactName, PathId = PathId, PathName = PathName)
  output <- .servicecatalog$describe_provisioning_parameters_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_provisioning_parameters <- servicecatalog_describe_provisioning_parameters

#' Gets information about the specified request operation
#'
#' @description
#' Gets information about the specified request operation.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_record/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_record/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The record identifier of the provisioned product. This identifier is
#' returned by the request operation.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_record
servicecatalog_describe_record <- function(AcceptLanguage = NULL, Id, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeRecord",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_record_input(AcceptLanguage = AcceptLanguage, Id = Id, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$describe_record_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_record <- servicecatalog_describe_record

#' Describes a self-service action
#'
#' @description
#' Describes a self-service action.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_service_action/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_service_action/) for full documentation.
#'
#' @param Id &#91;required&#93; The self-service action identifier.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_service_action
servicecatalog_describe_service_action <- function(Id, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DescribeServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_service_action_input(Id = Id, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$describe_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_service_action <- servicecatalog_describe_service_action

#' Finds the default parameters for a specific self-service action on a
#' specific provisioned product and returns a map of the results to the
#' user
#'
#' @description
#' Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_service_action_execution_parameters/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_service_action_execution_parameters/) for full documentation.
#'
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_service_action_execution_parameters
servicecatalog_describe_service_action_execution_parameters <- function(ProvisionedProductId, ServiceActionId, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DescribeServiceActionExecutionParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_service_action_execution_parameters_input(ProvisionedProductId = ProvisionedProductId, ServiceActionId = ServiceActionId, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$describe_service_action_execution_parameters_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_service_action_execution_parameters <- servicecatalog_describe_service_action_execution_parameters

#' Gets information about the specified TagOption
#'
#' @description
#' Gets information about the specified TagOption.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_describe_tag_option/](https://www.paws-r-sdk.com/docs/servicecatalog_describe_tag_option/) for full documentation.
#'
#' @param Id &#91;required&#93; The TagOption identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_describe_tag_option
servicecatalog_describe_tag_option <- function(Id) {
  op <- new_operation(
    name = "DescribeTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$describe_tag_option_input(Id = Id)
  output <- .servicecatalog$describe_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$describe_tag_option <- servicecatalog_describe_tag_option

#' Disable portfolio sharing through the Organizations service
#'
#' @description
#' Disable portfolio sharing through the Organizations service. This command will not delete your current shares, but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with your organization structure if the structure changes after calling this API. Only the management account in the organization can call this API.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_disable_aws_organizations_access/](https://www.paws-r-sdk.com/docs/servicecatalog_disable_aws_organizations_access/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disable_aws_organizations_access
servicecatalog_disable_aws_organizations_access <- function() {
  op <- new_operation(
    name = "DisableAWSOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disable_aws_organizations_access_input()
  output <- .servicecatalog$disable_aws_organizations_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disable_aws_organizations_access <- servicecatalog_disable_aws_organizations_access

#' Disassociates the specified budget from the specified resource
#'
#' @description
#' Disassociates the specified budget from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_budget_from_resource/](https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_budget_from_resource/) for full documentation.
#'
#' @param BudgetName &#91;required&#93; The name of the budget you want to disassociate.
#' @param ResourceId &#91;required&#93; The resource identifier you want to disassociate from. Either a
#' portfolio-id or a product-id.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_budget_from_resource
servicecatalog_disassociate_budget_from_resource <- function(BudgetName, ResourceId) {
  op <- new_operation(
    name = "DisassociateBudgetFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_budget_from_resource_input(BudgetName = BudgetName, ResourceId = ResourceId)
  output <- .servicecatalog$disassociate_budget_from_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_budget_from_resource <- servicecatalog_disassociate_budget_from_resource

#' Disassociates a previously associated principal ARN from a specified
#' portfolio
#'
#' @description
#' Disassociates a previously associated principal ARN from a specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_principal_from_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_principal_from_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PrincipalARN &#91;required&#93; The ARN of the principal (user, role, or group). This field allows an
#' ARN with no `accountID` with or without wildcard characters if
#' `PrincipalType` is `IAM_PATTERN`.
#' @param PrincipalType The supported value is `IAM` if you use a fully defined ARN, or
#' `IAM_PATTERN` if you specify an `IAM` ARN with no AccountId, with or
#' without wildcard characters.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_principal_from_portfolio
servicecatalog_disassociate_principal_from_portfolio <- function(AcceptLanguage = NULL, PortfolioId, PrincipalARN, PrincipalType = NULL) {
  op <- new_operation(
    name = "DisassociatePrincipalFromPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_principal_from_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PrincipalARN = PrincipalARN, PrincipalType = PrincipalType)
  output <- .servicecatalog$disassociate_principal_from_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_principal_from_portfolio <- servicecatalog_disassociate_principal_from_portfolio

#' Disassociates the specified product from the specified portfolio
#'
#' @description
#' Disassociates the specified product from the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_product_from_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_product_from_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_product_from_portfolio
servicecatalog_disassociate_product_from_portfolio <- function(AcceptLanguage = NULL, ProductId, PortfolioId) {
  op <- new_operation(
    name = "DisassociateProductFromPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_product_from_portfolio_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PortfolioId = PortfolioId)
  output <- .servicecatalog$disassociate_product_from_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_product_from_portfolio <- servicecatalog_disassociate_product_from_portfolio

#' Disassociates the specified self-service action association from the
#' specified provisioning artifact
#'
#' @description
#' Disassociates the specified self-service action association from the specified provisioning artifact.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_service_action_from_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_service_action_from_provisioning_artifact/) for full documentation.
#'
#' @param ProductId &#91;required&#93; The product identifier. For example, `prod-abcdzk7xy33qa`.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact. For example,
#' `pa-4abcdjnxjj6ne`.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disass_servic_action_from_provis_artifa
servicecatalog_disassociate_service_action_from_provisioning_artifact <- function(ProductId, ProvisioningArtifactId, ServiceActionId, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "DisassociateServiceActionFromProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_service_action_from_provisioning_artifact_input(ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, ServiceActionId = ServiceActionId, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$disassociate_service_action_from_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_service_action_from_provisioning_artifact <- servicecatalog_disassociate_service_action_from_provisioning_artifact

#' Disassociates the specified TagOption from the specified resource
#'
#' @description
#' Disassociates the specified TagOption from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_tag_option_from_resource/](https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_tag_option_from_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The resource identifier.
#' @param TagOptionId &#91;required&#93; The TagOption identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_disassociate_tag_option_from_resource
servicecatalog_disassociate_tag_option_from_resource <- function(ResourceId, TagOptionId) {
  op <- new_operation(
    name = "DisassociateTagOptionFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$disassociate_tag_option_from_resource_input(ResourceId = ResourceId, TagOptionId = TagOptionId)
  output <- .servicecatalog$disassociate_tag_option_from_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$disassociate_tag_option_from_resource <- servicecatalog_disassociate_tag_option_from_resource

#' Enable portfolio sharing feature through Organizations
#'
#' @description
#' Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_enable_aws_organizations_access/](https://www.paws-r-sdk.com/docs/servicecatalog_enable_aws_organizations_access/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_enable_aws_organizations_access
servicecatalog_enable_aws_organizations_access <- function() {
  op <- new_operation(
    name = "EnableAWSOrganizationsAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$enable_aws_organizations_access_input()
  output <- .servicecatalog$enable_aws_organizations_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$enable_aws_organizations_access <- servicecatalog_enable_aws_organizations_access

#' Provisions or modifies a product based on the resource changes for the
#' specified plan
#'
#' @description
#' Provisions or modifies a product based on the resource changes for the specified plan.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_execute_provisioned_product_plan/](https://www.paws-r-sdk.com/docs/servicecatalog_execute_provisioned_product_plan/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PlanId &#91;required&#93; The plan identifier.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_execute_provisioned_product_plan
servicecatalog_execute_provisioned_product_plan <- function(AcceptLanguage = NULL, PlanId, IdempotencyToken) {
  op <- new_operation(
    name = "ExecuteProvisionedProductPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$execute_provisioned_product_plan_input(AcceptLanguage = AcceptLanguage, PlanId = PlanId, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$execute_provisioned_product_plan_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$execute_provisioned_product_plan <- servicecatalog_execute_provisioned_product_plan

#' Executes a self-service action against a provisioned product
#'
#' @description
#' Executes a self-service action against a provisioned product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_execute_provisioned_product_service_action/](https://www.paws-r-sdk.com/docs/servicecatalog_execute_provisioned_product_service_action/) for full documentation.
#'
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param ExecuteToken &#91;required&#93; An idempotency token that uniquely identifies the execute request.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Parameters A map of all self-service action parameters and their values. If a
#' provided parameter is of a special type, such as `TARGET`, the provided
#' value will override the default value generated by Service Catalog. If
#' the parameters field is not provided, no additional parameters are
#' passed and default values will be used for any special parameters such
#' as `TARGET`.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_execute_provisioned_product_service_action
servicecatalog_execute_provisioned_product_service_action <- function(ProvisionedProductId, ServiceActionId, ExecuteToken, AcceptLanguage = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ExecuteProvisionedProductServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$execute_provisioned_product_service_action_input(ProvisionedProductId = ProvisionedProductId, ServiceActionId = ServiceActionId, ExecuteToken = ExecuteToken, AcceptLanguage = AcceptLanguage, Parameters = Parameters)
  output <- .servicecatalog$execute_provisioned_product_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$execute_provisioned_product_service_action <- servicecatalog_execute_provisioned_product_service_action

#' Get the Access Status for Organizations portfolio share feature
#'
#' @description
#' Get the Access Status for Organizations portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_get_aws_organizations_access_status/](https://www.paws-r-sdk.com/docs/servicecatalog_get_aws_organizations_access_status/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_get_aws_organizations_access_status
servicecatalog_get_aws_organizations_access_status <- function() {
  op <- new_operation(
    name = "GetAWSOrganizationsAccessStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$get_aws_organizations_access_status_input()
  output <- .servicecatalog$get_aws_organizations_access_status_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$get_aws_organizations_access_status <- servicecatalog_get_aws_organizations_access_status

#' This API takes either a ProvisonedProductId or a ProvisionedProductName,
#' along with a list of one or more output keys, and responds with the
#' key/value pairs of those outputs
#'
#' @description
#' This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_get_provisioned_product_outputs/](https://www.paws-r-sdk.com/docs/servicecatalog_get_provisioned_product_outputs/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductId The identifier of the provisioned product that you want the outputs
#' from.
#' @param ProvisionedProductName The name of the provisioned product that you want the outputs from.
#' @param OutputKeys The list of keys that the API should return with their values. If none
#' are provided, the API will return all outputs of the provisioned
#' product.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_get_provisioned_product_outputs
servicecatalog_get_provisioned_product_outputs <- function(AcceptLanguage = NULL, ProvisionedProductId = NULL, ProvisionedProductName = NULL, OutputKeys = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "GetProvisionedProductOutputs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$get_provisioned_product_outputs_input(AcceptLanguage = AcceptLanguage, ProvisionedProductId = ProvisionedProductId, ProvisionedProductName = ProvisionedProductName, OutputKeys = OutputKeys, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$get_provisioned_product_outputs_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$get_provisioned_product_outputs <- servicecatalog_get_provisioned_product_outputs

#' Requests the import of a resource as an Service Catalog provisioned
#' product that is associated to an Service Catalog product and
#' provisioning artifact
#'
#' @description
#' Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the provisioned product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_import_as_provisioned_product/](https://www.paws-r-sdk.com/docs/servicecatalog_import_as_provisioned_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#' @param ProvisionedProductName &#91;required&#93; The user-friendly name of the provisioned product. The value must be
#' unique for the Amazon Web Services account. The name cannot be updated
#' after the product is provisioned.
#' @param PhysicalId &#91;required&#93; The unique identifier of the resource to be imported. It only currently
#' supports CloudFormation stack IDs.
#' @param IdempotencyToken &#91;required&#93; A unique identifier that you provide to ensure idempotency. If multiple
#' requests differ only by the idempotency token, the same response is
#' returned for each repeated request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_import_as_provisioned_product
servicecatalog_import_as_provisioned_product <- function(AcceptLanguage = NULL, ProductId, ProvisioningArtifactId, ProvisionedProductName, PhysicalId, IdempotencyToken) {
  op <- new_operation(
    name = "ImportAsProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$import_as_provisioned_product_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, ProvisionedProductName = ProvisionedProductName, PhysicalId = PhysicalId, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$import_as_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$import_as_provisioned_product <- servicecatalog_import_as_provisioned_product

#' Lists all imported portfolios for which account-to-account shares were
#' accepted by this account
#'
#' @description
#' Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_accepted_portfolio_shares/](https://www.paws-r-sdk.com/docs/servicecatalog_list_accepted_portfolio_shares/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#' @param PortfolioShareType The type of shared portfolios to list. The default is to list imported
#' portfolios.
#' 
#' -   `AWS_ORGANIZATIONS` - List portfolios accepted and shared via
#'     organizational sharing by the management account or delegated
#'     administrator of your organization.
#' 
#' -   `AWS_SERVICECATALOG` - Deprecated type.
#' 
#' -   `IMPORTED` - List imported portfolios that have been accepted and
#'     shared through account-to-account sharing.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_accepted_portfolio_shares
servicecatalog_list_accepted_portfolio_shares <- function(AcceptLanguage = NULL, PageToken = NULL, PageSize = NULL, PortfolioShareType = NULL) {
  op <- new_operation(
    name = "ListAcceptedPortfolioShares",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_accepted_portfolio_shares_input(AcceptLanguage = AcceptLanguage, PageToken = PageToken, PageSize = PageSize, PortfolioShareType = PortfolioShareType)
  output <- .servicecatalog$list_accepted_portfolio_shares_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_accepted_portfolio_shares <- servicecatalog_list_accepted_portfolio_shares

#' Lists all the budgets associated to the specified resource
#'
#' @description
#' Lists all the budgets associated to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_budgets_for_resource/](https://www.paws-r-sdk.com/docs/servicecatalog_list_budgets_for_resource/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ResourceId &#91;required&#93; The resource identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_budgets_for_resource
servicecatalog_list_budgets_for_resource <- function(AcceptLanguage = NULL, ResourceId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListBudgetsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_budgets_for_resource_input(AcceptLanguage = AcceptLanguage, ResourceId = ResourceId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_budgets_for_resource_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_budgets_for_resource <- servicecatalog_list_budgets_for_resource

#' Lists the constraints for the specified portfolio and product
#'
#' @description
#' Lists the constraints for the specified portfolio and product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_constraints_for_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_list_constraints_for_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param ProductId The product identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_constraints_for_portfolio
servicecatalog_list_constraints_for_portfolio <- function(AcceptLanguage = NULL, PortfolioId, ProductId = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListConstraintsForPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_constraints_for_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, ProductId = ProductId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_constraints_for_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_constraints_for_portfolio <- servicecatalog_list_constraints_for_portfolio

#' Lists the paths to the specified product
#'
#' @description
#' Lists the paths to the specified product. A path describes how the user gets access to a specified product and is necessary when provisioning a product. A path also determines the constraints that are put on a product. A path is dependent on a specific product, porfolio, and principal.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_launch_paths/](https://www.paws-r-sdk.com/docs/servicecatalog_list_launch_paths/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_launch_paths
servicecatalog_list_launch_paths <- function(AcceptLanguage = NULL, ProductId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListLaunchPaths",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_launch_paths_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_launch_paths_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_launch_paths <- servicecatalog_list_launch_paths

#' Lists the organization nodes that have access to the specified portfolio
#'
#' @description
#' Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_organization_portfolio_access/](https://www.paws-r-sdk.com/docs/servicecatalog_list_organization_portfolio_access/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier. For example, `port-2abcdext3y5fk`.
#' @param OrganizationNodeType &#91;required&#93; The organization node type that will be returned in the output.
#' 
#' -   `ORGANIZATION` - Organization that has access to the portfolio.
#' 
#' -   `ORGANIZATIONAL_UNIT` - Organizational unit that has access to the
#'     portfolio within your organization.
#' 
#' -   `ACCOUNT` - Account that has access to the portfolio within your
#'     organization.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_organization_portfolio_access
servicecatalog_list_organization_portfolio_access <- function(AcceptLanguage = NULL, PortfolioId, OrganizationNodeType, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListOrganizationPortfolioAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_organization_portfolio_access_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, OrganizationNodeType = OrganizationNodeType, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_organization_portfolio_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_organization_portfolio_access <- servicecatalog_list_organization_portfolio_access

#' Lists the account IDs that have access to the specified portfolio
#'
#' @description
#' Lists the account IDs that have access to the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_portfolio_access/](https://www.paws-r-sdk.com/docs/servicecatalog_list_portfolio_access/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param OrganizationParentId The ID of an organization node the portfolio is shared with. All
#' children of this node with an inherited portfolio share will be
#' returned.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_portfolio_access
servicecatalog_list_portfolio_access <- function(AcceptLanguage = NULL, PortfolioId, OrganizationParentId = NULL, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListPortfolioAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_portfolio_access_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, OrganizationParentId = OrganizationParentId, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_portfolio_access_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_portfolio_access <- servicecatalog_list_portfolio_access

#' Lists all portfolios in the catalog
#'
#' @description
#' Lists all portfolios in the catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_portfolios/](https://www.paws-r-sdk.com/docs/servicecatalog_list_portfolios/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_portfolios
servicecatalog_list_portfolios <- function(AcceptLanguage = NULL, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListPortfolios",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_portfolios_input(AcceptLanguage = AcceptLanguage, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_portfolios_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_portfolios <- servicecatalog_list_portfolios

#' Lists all portfolios that the specified product is associated with
#'
#' @description
#' Lists all portfolios that the specified product is associated with.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_portfolios_for_product/](https://www.paws-r-sdk.com/docs/servicecatalog_list_portfolios_for_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_portfolios_for_product
servicecatalog_list_portfolios_for_product <- function(AcceptLanguage = NULL, ProductId, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListPortfoliosForProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_portfolios_for_product_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_portfolios_for_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_portfolios_for_product <- servicecatalog_list_portfolios_for_product

#' Lists all PrincipalARNs and corresponding PrincipalTypes associated with
#' the specified portfolio
#'
#' @description
#' Lists all `PrincipalARN`s and corresponding `PrincipalType`s associated with the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_principals_for_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_list_principals_for_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_principals_for_portfolio
servicecatalog_list_principals_for_portfolio <- function(AcceptLanguage = NULL, PortfolioId, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListPrincipalsForPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_principals_for_portfolio_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_principals_for_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_principals_for_portfolio <- servicecatalog_list_principals_for_portfolio

#' Lists the plans for the specified provisioned product or all plans to
#' which the user has access
#'
#' @description
#' Lists the plans for the specified provisioned product or all plans to which the user has access.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_provisioned_product_plans/](https://www.paws-r-sdk.com/docs/servicecatalog_list_provisioned_product_plans/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionProductId The product identifier.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_provisioned_product_plans
servicecatalog_list_provisioned_product_plans <- function(AcceptLanguage = NULL, ProvisionProductId = NULL, PageSize = NULL, PageToken = NULL, AccessLevelFilter = NULL) {
  op <- new_operation(
    name = "ListProvisionedProductPlans",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_provisioned_product_plans_input(AcceptLanguage = AcceptLanguage, ProvisionProductId = ProvisionProductId, PageSize = PageSize, PageToken = PageToken, AccessLevelFilter = AccessLevelFilter)
  output <- .servicecatalog$list_provisioned_product_plans_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_provisioned_product_plans <- servicecatalog_list_provisioned_product_plans

#' Lists all provisioning artifacts (also known as versions) for the
#' specified product
#'
#' @description
#' Lists all provisioning artifacts (also known as versions) for the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_provisioning_artifacts/](https://www.paws-r-sdk.com/docs/servicecatalog_list_provisioning_artifacts/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_provisioning_artifacts
servicecatalog_list_provisioning_artifacts <- function(AcceptLanguage = NULL, ProductId) {
  op <- new_operation(
    name = "ListProvisioningArtifacts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_provisioning_artifacts_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId)
  output <- .servicecatalog$list_provisioning_artifacts_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_provisioning_artifacts <- servicecatalog_list_provisioning_artifacts

#' Lists all provisioning artifacts (also known as versions) for the
#' specified self-service action
#'
#' @description
#' Lists all provisioning artifacts (also known as versions) for the specified self-service action.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_provisioning_artifacts_for_service_action/](https://www.paws-r-sdk.com/docs/servicecatalog_list_provisioning_artifacts_for_service_action/) for full documentation.
#'
#' @param ServiceActionId &#91;required&#93; The self-service action identifier. For example, `act-fs7abcd89wxyz`.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_provis_artifa_for_servic_action
servicecatalog_list_provisioning_artifacts_for_service_action <- function(ServiceActionId, PageSize = NULL, PageToken = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "ListProvisioningArtifactsForServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_provisioning_artifacts_for_service_action_input(ServiceActionId = ServiceActionId, PageSize = PageSize, PageToken = PageToken, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$list_provisioning_artifacts_for_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_provisioning_artifacts_for_service_action <- servicecatalog_list_provisioning_artifacts_for_service_action

#' Lists the specified requests or all performed requests
#'
#' @description
#' Lists the specified requests or all performed requests.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_record_history/](https://www.paws-r-sdk.com/docs/servicecatalog_list_record_history/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#' @param SearchFilter The search filter to scope the results.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_record_history
servicecatalog_list_record_history <- function(AcceptLanguage = NULL, AccessLevelFilter = NULL, SearchFilter = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListRecordHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_record_history_input(AcceptLanguage = AcceptLanguage, AccessLevelFilter = AccessLevelFilter, SearchFilter = SearchFilter, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_record_history_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_record_history <- servicecatalog_list_record_history

#' Lists the resources associated with the specified TagOption
#'
#' @description
#' Lists the resources associated with the specified TagOption.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_resources_for_tag_option/](https://www.paws-r-sdk.com/docs/servicecatalog_list_resources_for_tag_option/) for full documentation.
#'
#' @param TagOptionId &#91;required&#93; The TagOption identifier.
#' @param ResourceType The resource type.
#' 
#' -   `Portfolio`
#' 
#' -   `Product`
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_resources_for_tag_option
servicecatalog_list_resources_for_tag_option <- function(TagOptionId, ResourceType = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListResourcesForTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "PageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_resources_for_tag_option_input(TagOptionId = TagOptionId, ResourceType = ResourceType, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_resources_for_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_resources_for_tag_option <- servicecatalog_list_resources_for_tag_option

#' Lists all self-service actions
#'
#' @description
#' Lists all self-service actions.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_service_actions/](https://www.paws-r-sdk.com/docs/servicecatalog_list_service_actions/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_service_actions
servicecatalog_list_service_actions <- function(AcceptLanguage = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListServiceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_service_actions_input(AcceptLanguage = AcceptLanguage, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_service_actions_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_service_actions <- servicecatalog_list_service_actions

#' Returns a paginated list of self-service actions associated with the
#' specified Product ID and Provisioning Artifact ID
#'
#' @description
#' Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_service_actions_for_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_list_service_actions_for_provisioning_artifact/) for full documentation.
#'
#' @param ProductId &#91;required&#93; The product identifier. For example, `prod-abcdzk7xy33qa`.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact. For example,
#' `pa-4abcdjnxjj6ne`.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_servic_action_for_provis_artifa
servicecatalog_list_service_actions_for_provisioning_artifact <- function(ProductId, ProvisioningArtifactId, PageSize = NULL, PageToken = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "ListServiceActionsForProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_service_actions_for_provisioning_artifact_input(ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, PageSize = PageSize, PageToken = PageToken, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$list_service_actions_for_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_service_actions_for_provisioning_artifact <- servicecatalog_list_service_actions_for_provisioning_artifact

#' Returns summary information about stack instances that are associated
#' with the specified CFN_STACKSET type provisioned product
#'
#' @description
#' Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_stack_instances_for_provisioned_product/](https://www.paws-r-sdk.com/docs/servicecatalog_list_stack_instances_for_provisioned_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_stack_instances_for_provisioned_product
servicecatalog_list_stack_instances_for_provisioned_product <- function(AcceptLanguage = NULL, ProvisionedProductId, PageToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListStackInstancesForProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$list_stack_instances_for_provisioned_product_input(AcceptLanguage = AcceptLanguage, ProvisionedProductId = ProvisionedProductId, PageToken = PageToken, PageSize = PageSize)
  output <- .servicecatalog$list_stack_instances_for_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_stack_instances_for_provisioned_product <- servicecatalog_list_stack_instances_for_provisioned_product

#' Lists the specified TagOptions or all TagOptions
#'
#' @description
#' Lists the specified TagOptions or all TagOptions.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_list_tag_options/](https://www.paws-r-sdk.com/docs/servicecatalog_list_tag_options/) for full documentation.
#'
#' @param Filters The search filters. If no search filters are specified, the output
#' includes all TagOptions.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_list_tag_options
servicecatalog_list_tag_options <- function(Filters = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ListTagOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "PageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$list_tag_options_input(Filters = Filters, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$list_tag_options_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$list_tag_options <- servicecatalog_list_tag_options

#' Notifies the result of the provisioning engine execution
#'
#' @description
#' Notifies the result of the provisioning engine execution.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_notify_provision_product_engine_workflow_result/](https://www.paws-r-sdk.com/docs/servicecatalog_notify_provision_product_engine_workflow_result/) for full documentation.
#'
#' @param WorkflowToken &#91;required&#93; The encrypted contents of the provisioning engine execution payload that
#' Service Catalog sends after the Terraform product provisioning workflow
#' starts.
#' @param RecordId &#91;required&#93; The identifier of the record.
#' @param Status &#91;required&#93; The status of the provisioning engine execution.
#' @param FailureReason The reason why the provisioning engine execution failed.
#' @param ResourceIdentifier The ID for the provisioned product resources that are part of a resource
#' group.
#' @param Outputs The output of the provisioning engine execution.
#' @param IdempotencyToken &#91;required&#93; The idempotency token that identifies the provisioning engine execution.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_notify_provis_produc_engine_workfl_result
servicecatalog_notify_provision_product_engine_workflow_result <- function(WorkflowToken, RecordId, Status, FailureReason = NULL, ResourceIdentifier = NULL, Outputs = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "NotifyProvisionProductEngineWorkflowResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$notify_provision_product_engine_workflow_result_input(WorkflowToken = WorkflowToken, RecordId = RecordId, Status = Status, FailureReason = FailureReason, ResourceIdentifier = ResourceIdentifier, Outputs = Outputs, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$notify_provision_product_engine_workflow_result_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$notify_provision_product_engine_workflow_result <- servicecatalog_notify_provision_product_engine_workflow_result

#' Notifies the result of the terminate engine execution
#'
#' @description
#' Notifies the result of the terminate engine execution.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_notify_terminate_provisioned_product_engine_workflow_result/](https://www.paws-r-sdk.com/docs/servicecatalog_notify_terminate_provisioned_product_engine_workflow_result/) for full documentation.
#'
#' @param WorkflowToken &#91;required&#93; The encrypted contents of the terminate engine execution payload that
#' Service Catalog sends after the Terraform product terminate workflow
#' starts.
#' @param RecordId &#91;required&#93; The identifier of the record.
#' @param Status &#91;required&#93; The status of the terminate engine execution.
#' @param FailureReason The reason why the terminate engine execution failed.
#' @param IdempotencyToken &#91;required&#93; The idempotency token that identifies the terminate engine execution.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_notif_termi_provi_produ_engin_workf_resul
servicecatalog_notify_terminate_provisioned_product_engine_workflow_result <- function(WorkflowToken, RecordId, Status, FailureReason = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "NotifyTerminateProvisionedProductEngineWorkflowResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$notify_terminate_provisioned_product_engine_workflow_result_input(WorkflowToken = WorkflowToken, RecordId = RecordId, Status = Status, FailureReason = FailureReason, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$notify_terminate_provisioned_product_engine_workflow_result_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$notify_terminate_provisioned_product_engine_workflow_result <- servicecatalog_notify_terminate_provisioned_product_engine_workflow_result

#' Notifies the result of the update engine execution
#'
#' @description
#' Notifies the result of the update engine execution.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_notify_update_provisioned_product_engine_workflow_result/](https://www.paws-r-sdk.com/docs/servicecatalog_notify_update_provisioned_product_engine_workflow_result/) for full documentation.
#'
#' @param WorkflowToken &#91;required&#93; The encrypted contents of the update engine execution payload that
#' Service Catalog sends after the Terraform product update workflow
#' starts.
#' @param RecordId &#91;required&#93; The identifier of the record.
#' @param Status &#91;required&#93; The status of the update engine execution.
#' @param FailureReason The reason why the update engine execution failed.
#' @param Outputs The output of the update engine execution.
#' @param IdempotencyToken &#91;required&#93; The idempotency token that identifies the update engine execution.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_notif_updat_provi_produ_engin_workf_resul
servicecatalog_notify_update_provisioned_product_engine_workflow_result <- function(WorkflowToken, RecordId, Status, FailureReason = NULL, Outputs = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "NotifyUpdateProvisionedProductEngineWorkflowResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$notify_update_provisioned_product_engine_workflow_result_input(WorkflowToken = WorkflowToken, RecordId = RecordId, Status = Status, FailureReason = FailureReason, Outputs = Outputs, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$notify_update_provisioned_product_engine_workflow_result_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$notify_update_provisioned_product_engine_workflow_result <- servicecatalog_notify_update_provisioned_product_engine_workflow_result

#' Provisions the specified product
#'
#' @description
#' Provisions the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_provision_product/](https://www.paws-r-sdk.com/docs/servicecatalog_provision_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId The product identifier. You must provide the name or ID, but not both.
#' @param ProductName The name of the product. You must provide the name or ID, but not both.
#' @param ProvisioningArtifactId The identifier of the provisioning artifact. You must provide the name
#' or ID, but not both.
#' @param ProvisioningArtifactName The name of the provisioning artifact. You must provide the name or ID,
#' but not both.
#' @param PathId The path identifier of the product. This value is optional if the
#' product has a default path, and required if the product has more than
#' one path. To list the paths for a product, use
#' [`list_launch_paths`][servicecatalog_list_launch_paths]. You must
#' provide the name or ID, but not both.
#' @param PathName The name of the path. You must provide the name or ID, but not both.
#' @param ProvisionedProductName &#91;required&#93; A user-friendly name for the provisioned product. This value must be
#' unique for the Amazon Web Services account and cannot be updated after
#' the product is provisioned.
#' @param ProvisioningParameters Parameters specified by the administrator that are required for
#' provisioning the product.
#' @param ProvisioningPreferences An object that contains information about the provisioning preferences
#' for a stack set.
#' @param Tags One or more tags.
#' @param NotificationArns Passed to CloudFormation. The SNS topic ARNs to which to publish
#' stack-related events.
#' @param ProvisionToken &#91;required&#93; An idempotency token that uniquely identifies the provisioning request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_provision_product
servicecatalog_provision_product <- function(AcceptLanguage = NULL, ProductId = NULL, ProductName = NULL, ProvisioningArtifactId = NULL, ProvisioningArtifactName = NULL, PathId = NULL, PathName = NULL, ProvisionedProductName, ProvisioningParameters = NULL, ProvisioningPreferences = NULL, Tags = NULL, NotificationArns = NULL, ProvisionToken) {
  op <- new_operation(
    name = "ProvisionProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$provision_product_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProductName = ProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningArtifactName = ProvisioningArtifactName, PathId = PathId, PathName = PathName, ProvisionedProductName = ProvisionedProductName, ProvisioningParameters = ProvisioningParameters, ProvisioningPreferences = ProvisioningPreferences, Tags = Tags, NotificationArns = NotificationArns, ProvisionToken = ProvisionToken)
  output <- .servicecatalog$provision_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$provision_product <- servicecatalog_provision_product

#' Rejects an offer to share the specified portfolio
#'
#' @description
#' Rejects an offer to share the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_reject_portfolio_share/](https://www.paws-r-sdk.com/docs/servicecatalog_reject_portfolio_share/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The portfolio identifier.
#' @param PortfolioShareType The type of shared portfolios to reject. The default is to reject
#' imported portfolios.
#' 
#' -   `AWS_ORGANIZATIONS` - Reject portfolios shared by the management
#'     account of your organization.
#' 
#' -   `IMPORTED` - Reject imported portfolios.
#' 
#' -   `AWS_SERVICECATALOG` - Not supported. (Throws
#'     ResourceNotFoundException.)
#' 
#' For example,
#' `aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS`
#'
#' @keywords internal
#'
#' @rdname servicecatalog_reject_portfolio_share
servicecatalog_reject_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, PortfolioShareType = NULL) {
  op <- new_operation(
    name = "RejectPortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$reject_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, PortfolioShareType = PortfolioShareType)
  output <- .servicecatalog$reject_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$reject_portfolio_share <- servicecatalog_reject_portfolio_share

#' Lists the provisioned products that are available (not terminated)
#'
#' @description
#' Lists the provisioned products that are available (not terminated).
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_scan_provisioned_products/](https://www.paws-r-sdk.com/docs/servicecatalog_scan_provisioned_products/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_scan_provisioned_products
servicecatalog_scan_provisioned_products <- function(AcceptLanguage = NULL, AccessLevelFilter = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "ScanProvisionedProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$scan_provisioned_products_input(AcceptLanguage = AcceptLanguage, AccessLevelFilter = AccessLevelFilter, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$scan_provisioned_products_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$scan_provisioned_products <- servicecatalog_scan_provisioned_products

#' Gets information about the products to which the caller has access
#'
#' @description
#' Gets information about the products to which the caller has access.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_search_products/](https://www.paws-r-sdk.com/docs/servicecatalog_search_products/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Filters The search filters. If no search filters are specified, the output
#' includes all products to which the caller has access.
#' @param PageSize The maximum number of items to return with this call.
#' @param SortBy The sort field. If no value is specified, the results are not sorted.
#' @param SortOrder The sort order. If no value is specified, the results are not sorted.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_search_products
servicecatalog_search_products <- function(AcceptLanguage = NULL, Filters = NULL, PageSize = NULL, SortBy = NULL, SortOrder = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "SearchProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$search_products_input(AcceptLanguage = AcceptLanguage, Filters = Filters, PageSize = PageSize, SortBy = SortBy, SortOrder = SortOrder, PageToken = PageToken)
  output <- .servicecatalog$search_products_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$search_products <- servicecatalog_search_products

#' Gets information about the products for the specified portfolio or all
#' products
#'
#' @description
#' Gets information about the products for the specified portfolio or all products.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_search_products_as_admin/](https://www.paws-r-sdk.com/docs/servicecatalog_search_products_as_admin/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId The portfolio identifier.
#' @param Filters The search filters. If no search filters are specified, the output
#' includes all products to which the administrator has access.
#' @param SortBy The sort field. If no value is specified, the results are not sorted.
#' @param SortOrder The sort order. If no value is specified, the results are not sorted.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#' @param PageSize The maximum number of items to return with this call.
#' @param ProductSource Access level of the source of the product.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_search_products_as_admin
servicecatalog_search_products_as_admin <- function(AcceptLanguage = NULL, PortfolioId = NULL, Filters = NULL, SortBy = NULL, SortOrder = NULL, PageToken = NULL, PageSize = NULL, ProductSource = NULL) {
  op <- new_operation(
    name = "SearchProductsAsAdmin",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$search_products_as_admin_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, Filters = Filters, SortBy = SortBy, SortOrder = SortOrder, PageToken = PageToken, PageSize = PageSize, ProductSource = ProductSource)
  output <- .servicecatalog$search_products_as_admin_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$search_products_as_admin <- servicecatalog_search_products_as_admin

#' Gets information about the provisioned products that meet the specified
#' criteria
#'
#' @description
#' Gets information about the provisioned products that meet the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_search_provisioned_products/](https://www.paws-r-sdk.com/docs/servicecatalog_search_provisioned_products/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param AccessLevelFilter The access level to use to obtain results. The default is `User`.
#' @param Filters The search filters.
#' 
#' When the key is `SearchQuery`, the searchable fields are `arn`,
#' `createdTime`, `id`, `lastRecordId`, `idempotencyToken`, `name`,
#' `physicalId`, `productId`, `provisioningArtifactId`, `type`, `status`,
#' `tags`, `userArn`, `userArnSession`, `lastProvisioningRecordId`,
#' `lastSuccessfulProvisioningRecordId`, `productName`, and
#' `provisioningArtifactName`.
#' 
#' Example: `"SearchQuery":["status:AVAILABLE"]`
#' @param SortBy The sort field. If no value is specified, the results are not sorted.
#' The valid values are `arn`, `id`, `name`, and `lastRecordId`.
#' @param SortOrder The sort order. If no value is specified, the results are not sorted.
#' @param PageSize The maximum number of items to return with this call.
#' @param PageToken The page token for the next set of results. To retrieve the first set of
#' results, use null.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_search_provisioned_products
servicecatalog_search_provisioned_products <- function(AcceptLanguage = NULL, AccessLevelFilter = NULL, Filters = NULL, SortBy = NULL, SortOrder = NULL, PageSize = NULL, PageToken = NULL) {
  op <- new_operation(
    name = "SearchProvisionedProducts",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "PageToken", output_token = "NextPageToken", limit_key = "PageSize")
  )
  input <- .servicecatalog$search_provisioned_products_input(AcceptLanguage = AcceptLanguage, AccessLevelFilter = AccessLevelFilter, Filters = Filters, SortBy = SortBy, SortOrder = SortOrder, PageSize = PageSize, PageToken = PageToken)
  output <- .servicecatalog$search_provisioned_products_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$search_provisioned_products <- servicecatalog_search_provisioned_products

#' Terminates the specified provisioned product
#'
#' @description
#' Terminates the specified provisioned product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_terminate_provisioned_product/](https://www.paws-r-sdk.com/docs/servicecatalog_terminate_provisioned_product/) for full documentation.
#'
#' @param ProvisionedProductName The name of the provisioned product. You cannot specify both
#' `ProvisionedProductName` and `ProvisionedProductId`.
#' @param ProvisionedProductId The identifier of the provisioned product. You cannot specify both
#' `ProvisionedProductName` and `ProvisionedProductId`.
#' @param TerminateToken &#91;required&#93; An idempotency token that uniquely identifies the termination request.
#' This token is only valid during the termination process. After the
#' provisioned product is terminated, subsequent requests to terminate the
#' same provisioned product always return **ResourceNotFound**.
#' @param IgnoreErrors If set to true, Service Catalog stops managing the specified provisioned
#' product even if it cannot delete the underlying resources.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param RetainPhysicalResources When this boolean parameter is set to true, the
#' [`terminate_provisioned_product`][servicecatalog_terminate_provisioned_product]
#' API deletes the Service Catalog provisioned product. However, it does
#' not remove the CloudFormation stack, stack set, or the underlying
#' resources of the deleted provisioned product. The default value is
#' false.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_terminate_provisioned_product
servicecatalog_terminate_provisioned_product <- function(ProvisionedProductName = NULL, ProvisionedProductId = NULL, TerminateToken, IgnoreErrors = NULL, AcceptLanguage = NULL, RetainPhysicalResources = NULL) {
  op <- new_operation(
    name = "TerminateProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$terminate_provisioned_product_input(ProvisionedProductName = ProvisionedProductName, ProvisionedProductId = ProvisionedProductId, TerminateToken = TerminateToken, IgnoreErrors = IgnoreErrors, AcceptLanguage = AcceptLanguage, RetainPhysicalResources = RetainPhysicalResources)
  output <- .servicecatalog$terminate_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$terminate_provisioned_product <- servicecatalog_terminate_provisioned_product

#' Updates the specified constraint
#'
#' @description
#' Updates the specified constraint.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_constraint/](https://www.paws-r-sdk.com/docs/servicecatalog_update_constraint/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The identifier of the constraint.
#' @param Description The updated description of the constraint.
#' @param Parameters The constraint parameters, in JSON format. The syntax depends on the
#' constraint type as follows:
#' 
#' **LAUNCH**
#' 
#' You are required to specify either the `RoleArn` or the `LocalRoleName`
#' but can't use both.
#' 
#' Specify the `RoleArn` property as follows:
#' 
#' `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
#' 
#' Specify the `LocalRoleName` property as follows:
#' 
#' `{"LocalRoleName": "SCBasicLaunchRole"}`
#' 
#' If you specify the `LocalRoleName` property, when an account uses the
#' launch constraint, the IAM role with that name in the account will be
#' used. This allows launch-role constraints to be account-agnostic so the
#' administrator can create fewer resources per shared account.
#' 
#' The given role name must exist in the account used to create the launch
#' constraint and the account of the user who launches a product with this
#' launch constraint.
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `LAUNCH` constraint on a product and
#' portfolio.
#' 
#' **NOTIFICATION**
#' 
#' Specify the `NotificationArns` property as follows:
#' 
#' `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
#' 
#' **RESOURCE_UPDATE**
#' 
#' Specify the `TagUpdatesOnProvisionedProduct` property as follows:
#' 
#' `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
#' 
#' The `TagUpdatesOnProvisionedProduct` property accepts a string value of
#' `ALLOWED` or `NOT_ALLOWED`.
#' 
#' **STACKSET**
#' 
#' Specify the `Parameters` property as follows:
#' 
#' `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
#' 
#' You cannot have both a `LAUNCH` and a `STACKSET` constraint.
#' 
#' You also cannot have more than one `STACKSET` constraint on a product
#' and portfolio.
#' 
#' Products with a `STACKSET` constraint will launch an CloudFormation
#' stack set.
#' 
#' **TEMPLATE**
#' 
#' Specify the `Rules` property. For more information, see [Template
#' Constraint
#' Rules](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_constraint
servicecatalog_update_constraint <- function(AcceptLanguage = NULL, Id, Description = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "UpdateConstraint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_constraint_input(AcceptLanguage = AcceptLanguage, Id = Id, Description = Description, Parameters = Parameters)
  output <- .servicecatalog$update_constraint_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_constraint <- servicecatalog_update_constraint

#' Updates the specified portfolio
#'
#' @description
#' Updates the specified portfolio.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_portfolio/](https://www.paws-r-sdk.com/docs/servicecatalog_update_portfolio/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The portfolio identifier.
#' @param DisplayName The name to use for display purposes.
#' @param Description The updated description of the portfolio.
#' @param ProviderName The updated name of the portfolio provider.
#' @param AddTags The tags to add.
#' @param RemoveTags The tags to remove.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_portfolio
servicecatalog_update_portfolio <- function(AcceptLanguage = NULL, Id, DisplayName = NULL, Description = NULL, ProviderName = NULL, AddTags = NULL, RemoveTags = NULL) {
  op <- new_operation(
    name = "UpdatePortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_portfolio_input(AcceptLanguage = AcceptLanguage, Id = Id, DisplayName = DisplayName, Description = Description, ProviderName = ProviderName, AddTags = AddTags, RemoveTags = RemoveTags)
  output <- .servicecatalog$update_portfolio_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_portfolio <- servicecatalog_update_portfolio

#' Updates the specified portfolio share
#'
#' @description
#' Updates the specified portfolio share. You can use this API to enable or disable `TagOptions` sharing or Principal sharing for an existing portfolio share.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_portfolio_share/](https://www.paws-r-sdk.com/docs/servicecatalog_update_portfolio_share/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param PortfolioId &#91;required&#93; The unique identifier of the portfolio for which the share will be
#' updated.
#' @param AccountId The Amazon Web Services account Id of the recipient account. This field
#' is required when updating an external account to account type share.
#' @param OrganizationNode 
#' @param ShareTagOptions Enables or disables `TagOptions` sharing for the portfolio share. If
#' this field is not provided, the current state of TagOptions sharing on
#' the portfolio share will not be modified.
#' @param SharePrincipals A flag to enables or disables `Principals` sharing in the portfolio. If
#' this field is not provided, the current state of the `Principals`
#' sharing on the portfolio share will not be modified.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_portfolio_share
servicecatalog_update_portfolio_share <- function(AcceptLanguage = NULL, PortfolioId, AccountId = NULL, OrganizationNode = NULL, ShareTagOptions = NULL, SharePrincipals = NULL) {
  op <- new_operation(
    name = "UpdatePortfolioShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_portfolio_share_input(AcceptLanguage = AcceptLanguage, PortfolioId = PortfolioId, AccountId = AccountId, OrganizationNode = OrganizationNode, ShareTagOptions = ShareTagOptions, SharePrincipals = SharePrincipals)
  output <- .servicecatalog$update_portfolio_share_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_portfolio_share <- servicecatalog_update_portfolio_share

#' Updates the specified product
#'
#' @description
#' Updates the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_product/](https://www.paws-r-sdk.com/docs/servicecatalog_update_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param Id &#91;required&#93; The product identifier.
#' @param Name The updated product name.
#' @param Owner The updated owner of the product.
#' @param Description The updated description of the product.
#' @param Distributor The updated distributor of the product.
#' @param SupportDescription The updated support description for the product.
#' @param SupportEmail The updated support email for the product.
#' @param SupportUrl The updated support URL for the product.
#' @param AddTags The tags to add to the product.
#' @param RemoveTags The tags to remove from the product.
#' @param SourceConnection Specifies connection details for the updated product and syncs the
#' product to the connection source artifact. This automatically manages
#' the product's artifacts based on changes to the source. The
#' `SourceConnection` parameter consists of the following sub-fields.
#' 
#' -   `Type`
#' 
#' -   `ConnectionParamters`
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_product
servicecatalog_update_product <- function(AcceptLanguage = NULL, Id, Name = NULL, Owner = NULL, Description = NULL, Distributor = NULL, SupportDescription = NULL, SupportEmail = NULL, SupportUrl = NULL, AddTags = NULL, RemoveTags = NULL, SourceConnection = NULL) {
  op <- new_operation(
    name = "UpdateProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_product_input(AcceptLanguage = AcceptLanguage, Id = Id, Name = Name, Owner = Owner, Description = Description, Distributor = Distributor, SupportDescription = SupportDescription, SupportEmail = SupportEmail, SupportUrl = SupportUrl, AddTags = AddTags, RemoveTags = RemoveTags, SourceConnection = SourceConnection)
  output <- .servicecatalog$update_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_product <- servicecatalog_update_product

#' Requests updates to the configuration of the specified provisioned
#' product
#'
#' @description
#' Requests updates to the configuration of the specified provisioned product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioned_product/](https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioned_product/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductName The name of the provisioned product. You cannot specify both
#' `ProvisionedProductName` and `ProvisionedProductId`.
#' @param ProvisionedProductId The identifier of the provisioned product. You must provide the name or
#' ID, but not both.
#' @param ProductId The identifier of the product. You must provide the name or ID, but not
#' both.
#' @param ProductName The name of the product. You must provide the name or ID, but not both.
#' @param ProvisioningArtifactId The identifier of the provisioning artifact.
#' @param ProvisioningArtifactName The name of the provisioning artifact. You must provide the name or ID,
#' but not both.
#' @param PathId The path identifier. This value is optional if the product has a default
#' path, and required if the product has more than one path. You must
#' provide the name or ID, but not both.
#' @param PathName The name of the path. You must provide the name or ID, but not both.
#' @param ProvisioningParameters The new parameters.
#' @param ProvisioningPreferences An object that contains information about the provisioning preferences
#' for a stack set.
#' @param Tags One or more tags. Requires the product to have `RESOURCE_UPDATE`
#' constraint with `TagUpdatesOnProvisionedProduct` set to `ALLOWED` to
#' allow tag updates.
#' @param UpdateToken &#91;required&#93; The idempotency token that uniquely identifies the provisioning update
#' request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_provisioned_product
servicecatalog_update_provisioned_product <- function(AcceptLanguage = NULL, ProvisionedProductName = NULL, ProvisionedProductId = NULL, ProductId = NULL, ProductName = NULL, ProvisioningArtifactId = NULL, ProvisioningArtifactName = NULL, PathId = NULL, PathName = NULL, ProvisioningParameters = NULL, ProvisioningPreferences = NULL, Tags = NULL, UpdateToken) {
  op <- new_operation(
    name = "UpdateProvisionedProduct",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_provisioned_product_input(AcceptLanguage = AcceptLanguage, ProvisionedProductName = ProvisionedProductName, ProvisionedProductId = ProvisionedProductId, ProductId = ProductId, ProductName = ProductName, ProvisioningArtifactId = ProvisioningArtifactId, ProvisioningArtifactName = ProvisioningArtifactName, PathId = PathId, PathName = PathName, ProvisioningParameters = ProvisioningParameters, ProvisioningPreferences = ProvisioningPreferences, Tags = Tags, UpdateToken = UpdateToken)
  output <- .servicecatalog$update_provisioned_product_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_provisioned_product <- servicecatalog_update_provisioned_product

#' Requests updates to the properties of the specified provisioned product
#'
#' @description
#' Requests updates to the properties of the specified provisioned product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioned_product_properties/](https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioned_product_properties/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProvisionedProductId &#91;required&#93; The identifier of the provisioned product.
#' @param ProvisionedProductProperties &#91;required&#93; A map that contains the provisioned product properties to be updated.
#' 
#' The `LAUNCH_ROLE` key accepts role ARNs. This key allows an
#' administrator to call
#' [`update_provisioned_product_properties`][servicecatalog_update_provisioned_product_properties]
#' to update the launch role that is associated with a provisioned product.
#' This role is used when an end user calls a provisioning operation such
#' as
#' [`update_provisioned_product`][servicecatalog_update_provisioned_product],
#' [`terminate_provisioned_product`][servicecatalog_terminate_provisioned_product],
#' or
#' [`execute_provisioned_product_service_action`][servicecatalog_execute_provisioned_product_service_action].
#' Only a role ARN is valid. A user ARN is invalid.
#' 
#' The `OWNER` key accepts user ARNs, IAM role ARNs, and STS assumed-role
#' ARNs. The owner is the user that has permission to see, update,
#' terminate, and execute service actions in the provisioned product.
#' 
#' The administrator can change the owner of a provisioned product to
#' another IAM or STS entity within the same account. Both end user owners
#' and administrators can see ownership history of the provisioned product
#' using the [`list_record_history`][servicecatalog_list_record_history]
#' API. The new owner can describe all past records for the provisioned
#' product using the [`describe_record`][servicecatalog_describe_record]
#' API. The previous owner can no longer use
#' [`describe_record`][servicecatalog_describe_record], but can still see
#' the product's history from when he was an owner using
#' [`list_record_history`][servicecatalog_list_record_history].
#' 
#' If a provisioned product ownership is assigned to an end user, they can
#' see and perform any action through the API or Service Catalog console
#' such as update, terminate, and execute service actions. If an end user
#' provisions a product and the owner is updated to someone else, they will
#' no longer be able to see or perform any actions through API or the
#' Service Catalog console on that provisioned product.
#' @param IdempotencyToken &#91;required&#93; The idempotency token that uniquely identifies the provisioning product
#' update request.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_provisioned_product_properties
servicecatalog_update_provisioned_product_properties <- function(AcceptLanguage = NULL, ProvisionedProductId, ProvisionedProductProperties, IdempotencyToken) {
  op <- new_operation(
    name = "UpdateProvisionedProductProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_provisioned_product_properties_input(AcceptLanguage = AcceptLanguage, ProvisionedProductId = ProvisionedProductId, ProvisionedProductProperties = ProvisionedProductProperties, IdempotencyToken = IdempotencyToken)
  output <- .servicecatalog$update_provisioned_product_properties_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_provisioned_product_properties <- servicecatalog_update_provisioned_product_properties

#' Updates the specified provisioning artifact (also known as a version)
#' for the specified product
#'
#' @description
#' Updates the specified provisioning artifact (also known as a version) for the specified product.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioning_artifact/](https://www.paws-r-sdk.com/docs/servicecatalog_update_provisioning_artifact/) for full documentation.
#'
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#' @param ProductId &#91;required&#93; The product identifier.
#' @param ProvisioningArtifactId &#91;required&#93; The identifier of the provisioning artifact.
#' @param Name The updated name of the provisioning artifact.
#' @param Description The updated description of the provisioning artifact.
#' @param Active Indicates whether the product version is active.
#' 
#' Inactive provisioning artifacts are invisible to end users. End users
#' cannot launch or update a provisioned product from an inactive
#' provisioning artifact.
#' @param Guidance Information set by the administrator to provide guidance to end users
#' about which provisioning artifacts to use.
#' 
#' The `DEFAULT` value indicates that the product version is active.
#' 
#' The administrator can set the guidance to `DEPRECATED` to inform users
#' that the product version is deprecated. Users are able to make updates
#' to a provisioned product of a deprecated version but cannot launch new
#' provisioned products using a deprecated version.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_provisioning_artifact
servicecatalog_update_provisioning_artifact <- function(AcceptLanguage = NULL, ProductId, ProvisioningArtifactId, Name = NULL, Description = NULL, Active = NULL, Guidance = NULL) {
  op <- new_operation(
    name = "UpdateProvisioningArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_provisioning_artifact_input(AcceptLanguage = AcceptLanguage, ProductId = ProductId, ProvisioningArtifactId = ProvisioningArtifactId, Name = Name, Description = Description, Active = Active, Guidance = Guidance)
  output <- .servicecatalog$update_provisioning_artifact_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_provisioning_artifact <- servicecatalog_update_provisioning_artifact

#' Updates a self-service action
#'
#' @description
#' Updates a self-service action.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_service_action/](https://www.paws-r-sdk.com/docs/servicecatalog_update_service_action/) for full documentation.
#'
#' @param Id &#91;required&#93; The self-service action identifier.
#' @param Name The self-service action name.
#' @param Definition A map that defines the self-service action.
#' @param Description The self-service action description.
#' @param AcceptLanguage The language code.
#' 
#' -   `jp` - Japanese
#' 
#' -   `zh` - Chinese
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_service_action
servicecatalog_update_service_action <- function(Id, Name = NULL, Definition = NULL, Description = NULL, AcceptLanguage = NULL) {
  op <- new_operation(
    name = "UpdateServiceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_service_action_input(Id = Id, Name = Name, Definition = Definition, Description = Description, AcceptLanguage = AcceptLanguage)
  output <- .servicecatalog$update_service_action_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_service_action <- servicecatalog_update_service_action

#' Updates the specified TagOption
#'
#' @description
#' Updates the specified TagOption.
#'
#' See [https://www.paws-r-sdk.com/docs/servicecatalog_update_tag_option/](https://www.paws-r-sdk.com/docs/servicecatalog_update_tag_option/) for full documentation.
#'
#' @param Id &#91;required&#93; The TagOption identifier.
#' @param Value The updated value.
#' @param Active The updated active state.
#'
#' @keywords internal
#'
#' @rdname servicecatalog_update_tag_option
servicecatalog_update_tag_option <- function(Id, Value = NULL, Active = NULL) {
  op <- new_operation(
    name = "UpdateTagOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicecatalog$update_tag_option_input(Id = Id, Value = Value, Active = Active)
  output <- .servicecatalog$update_tag_option_output()
  config <- get_config()
  svc <- .servicecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicecatalog$operations$update_tag_option <- servicecatalog_update_tag_option
