# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include supportapp_service.R
NULL

#' Creates a Slack channel configuration for your Amazon Web Services
#' account
#'
#' @description
#' Creates a Slack channel configuration for your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_create_slack_channel_configuration/](https://www.paws-r-sdk.com/docs/supportapp_create_slack_channel_configuration/) for full documentation.
#'
#' @param channelId &#91;required&#93; The channel ID in Slack. This ID identifies a channel within a Slack
#' workspace.
#' @param channelName The name of the Slack channel that you configure for the Amazon Web
#' Services Support App.
#' @param channelRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that you want to use to
#' perform operations on Amazon Web Services. For more information, see
#' [Managing access to the Amazon Web Services Support
#' App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
#' in the *Amazon Web Services Support User Guide*.
#' @param notifyOnAddCorrespondenceToCase Whether you want to get notified when a support case has a new
#' correspondence.
#' @param notifyOnCaseSeverity &#91;required&#93; The case severity for a support case that you want to receive
#' notifications.
#' 
#' If you specify `high` or `all`, you must specify `true` for at least one
#' of the following parameters:
#' 
#' -   `notifyOnAddCorrespondenceToCase`
#' 
#' -   `notifyOnCreateOrReopenCase`
#' 
#' -   `notifyOnResolveCase`
#' 
#' If you specify `none`, the following parameters must be null or `false`:
#' 
#' -   `notifyOnAddCorrespondenceToCase`
#' 
#' -   `notifyOnCreateOrReopenCase`
#' 
#' -   `notifyOnResolveCase`
#' 
#' If you don't specify these parameters in your request, they default to
#' `false`.
#' @param notifyOnCreateOrReopenCase Whether you want to get notified when a support case is created or
#' reopened.
#' @param notifyOnResolveCase Whether you want to get notified when a support case is resolved.
#' @param teamId &#91;required&#93; The team ID in Slack. This ID uniquely identifies a Slack workspace,
#' such as `T012ABCDEFG`.
#'
#' @keywords internal
#'
#' @rdname supportapp_create_slack_channel_configuration
supportapp_create_slack_channel_configuration <- function(channelId, channelName = NULL, channelRoleArn, notifyOnAddCorrespondenceToCase = NULL, notifyOnCaseSeverity, notifyOnCreateOrReopenCase = NULL, notifyOnResolveCase = NULL, teamId) {
  op <- new_operation(
    name = "CreateSlackChannelConfiguration",
    http_method = "POST",
    http_path = "/control/create-slack-channel-configuration",
    paginator = list()
  )
  input <- .supportapp$create_slack_channel_configuration_input(channelId = channelId, channelName = channelName, channelRoleArn = channelRoleArn, notifyOnAddCorrespondenceToCase = notifyOnAddCorrespondenceToCase, notifyOnCaseSeverity = notifyOnCaseSeverity, notifyOnCreateOrReopenCase = notifyOnCreateOrReopenCase, notifyOnResolveCase = notifyOnResolveCase, teamId = teamId)
  output <- .supportapp$create_slack_channel_configuration_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$create_slack_channel_configuration <- supportapp_create_slack_channel_configuration

#' Deletes an alias for an Amazon Web Services account ID
#'
#' @description
#' Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_delete_account_alias/](https://www.paws-r-sdk.com/docs/supportapp_delete_account_alias/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname supportapp_delete_account_alias
supportapp_delete_account_alias <- function() {
  op <- new_operation(
    name = "DeleteAccountAlias",
    http_method = "POST",
    http_path = "/control/delete-account-alias",
    paginator = list()
  )
  input <- .supportapp$delete_account_alias_input()
  output <- .supportapp$delete_account_alias_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$delete_account_alias <- supportapp_delete_account_alias

#' Deletes a Slack channel configuration from your Amazon Web Services
#' account
#'
#' @description
#' Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your Slack channel.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_delete_slack_channel_configuration/](https://www.paws-r-sdk.com/docs/supportapp_delete_slack_channel_configuration/) for full documentation.
#'
#' @param channelId &#91;required&#93; The channel ID in Slack. This ID identifies a channel within a Slack
#' workspace.
#' @param teamId &#91;required&#93; The team ID in Slack. This ID uniquely identifies a Slack workspace,
#' such as `T012ABCDEFG`.
#'
#' @keywords internal
#'
#' @rdname supportapp_delete_slack_channel_configuration
supportapp_delete_slack_channel_configuration <- function(channelId, teamId) {
  op <- new_operation(
    name = "DeleteSlackChannelConfiguration",
    http_method = "POST",
    http_path = "/control/delete-slack-channel-configuration",
    paginator = list()
  )
  input <- .supportapp$delete_slack_channel_configuration_input(channelId = channelId, teamId = teamId)
  output <- .supportapp$delete_slack_channel_configuration_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$delete_slack_channel_configuration <- supportapp_delete_slack_channel_configuration

#' Deletes a Slack workspace configuration from your Amazon Web Services
#' account
#'
#' @description
#' Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your Slack workspace.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_delete_slack_workspace_configuration/](https://www.paws-r-sdk.com/docs/supportapp_delete_slack_workspace_configuration/) for full documentation.
#'
#' @param teamId &#91;required&#93; The team ID in Slack. This ID uniquely identifies a Slack workspace,
#' such as `T012ABCDEFG`.
#'
#' @keywords internal
#'
#' @rdname supportapp_delete_slack_workspace_configuration
supportapp_delete_slack_workspace_configuration <- function(teamId) {
  op <- new_operation(
    name = "DeleteSlackWorkspaceConfiguration",
    http_method = "POST",
    http_path = "/control/delete-slack-workspace-configuration",
    paginator = list()
  )
  input <- .supportapp$delete_slack_workspace_configuration_input(teamId = teamId)
  output <- .supportapp$delete_slack_workspace_configuration_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$delete_slack_workspace_configuration <- supportapp_delete_slack_workspace_configuration

#' Retrieves the alias from an Amazon Web Services account ID
#'
#' @description
#' Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_get_account_alias/](https://www.paws-r-sdk.com/docs/supportapp_get_account_alias/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname supportapp_get_account_alias
supportapp_get_account_alias <- function() {
  op <- new_operation(
    name = "GetAccountAlias",
    http_method = "POST",
    http_path = "/control/get-account-alias",
    paginator = list()
  )
  input <- .supportapp$get_account_alias_input()
  output <- .supportapp$get_account_alias_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$get_account_alias <- supportapp_get_account_alias

#' Lists the Slack channel configurations for an Amazon Web Services
#' account
#'
#' @description
#' Lists the Slack channel configurations for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_list_slack_channel_configurations/](https://www.paws-r-sdk.com/docs/supportapp_list_slack_channel_configurations/) for full documentation.
#'
#' @param nextToken If the results of a search are large, the API only returns a portion of
#' the results and includes a `nextToken` pagination token in the response.
#' To retrieve the next batch of results, reissue the search request and
#' include the returned token. When the API returns the last set of
#' results, the response doesn't include a pagination token value.
#'
#' @keywords internal
#'
#' @rdname supportapp_list_slack_channel_configurations
supportapp_list_slack_channel_configurations <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListSlackChannelConfigurations",
    http_method = "POST",
    http_path = "/control/list-slack-channel-configurations",
    paginator = list(input_token = "nextToken", output_token = "nextToken")
  )
  input <- .supportapp$list_slack_channel_configurations_input(nextToken = nextToken)
  output <- .supportapp$list_slack_channel_configurations_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$list_slack_channel_configurations <- supportapp_list_slack_channel_configurations

#' Lists the Slack workspace configurations for an Amazon Web Services
#' account
#'
#' @description
#' Lists the Slack workspace configurations for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_list_slack_workspace_configurations/](https://www.paws-r-sdk.com/docs/supportapp_list_slack_workspace_configurations/) for full documentation.
#'
#' @param nextToken If the results of a search are large, the API only returns a portion of
#' the results and includes a `nextToken` pagination token in the response.
#' To retrieve the next batch of results, reissue the search request and
#' include the returned token. When the API returns the last set of
#' results, the response doesn't include a pagination token value.
#'
#' @keywords internal
#'
#' @rdname supportapp_list_slack_workspace_configurations
supportapp_list_slack_workspace_configurations <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListSlackWorkspaceConfigurations",
    http_method = "POST",
    http_path = "/control/list-slack-workspace-configurations",
    paginator = list(input_token = "nextToken", output_token = "nextToken")
  )
  input <- .supportapp$list_slack_workspace_configurations_input(nextToken = nextToken)
  output <- .supportapp$list_slack_workspace_configurations_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$list_slack_workspace_configurations <- supportapp_list_slack_workspace_configurations

#' Creates or updates an individual alias for each Amazon Web Services
#' account ID
#'
#' @description
#' Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_put_account_alias/](https://www.paws-r-sdk.com/docs/supportapp_put_account_alias/) for full documentation.
#'
#' @param accountAlias &#91;required&#93; An alias or short name for an Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname supportapp_put_account_alias
supportapp_put_account_alias <- function(accountAlias) {
  op <- new_operation(
    name = "PutAccountAlias",
    http_method = "POST",
    http_path = "/control/put-account-alias",
    paginator = list()
  )
  input <- .supportapp$put_account_alias_input(accountAlias = accountAlias)
  output <- .supportapp$put_account_alias_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$put_account_alias <- supportapp_put_account_alias

#' Registers a Slack workspace for your Amazon Web Services account
#'
#' @description
#' Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of an organization in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_register_slack_workspace_for_organization/](https://www.paws-r-sdk.com/docs/supportapp_register_slack_workspace_for_organization/) for full documentation.
#'
#' @param teamId &#91;required&#93; The team ID in Slack. This ID uniquely identifies a Slack workspace,
#' such as `T012ABCDEFG`. Specify the Slack workspace that you want to use
#' for your organization.
#'
#' @keywords internal
#'
#' @rdname supportapp_register_slack_workspace_for_organization
supportapp_register_slack_workspace_for_organization <- function(teamId) {
  op <- new_operation(
    name = "RegisterSlackWorkspaceForOrganization",
    http_method = "POST",
    http_path = "/control/register-slack-workspace-for-organization",
    paginator = list()
  )
  input <- .supportapp$register_slack_workspace_for_organization_input(teamId = teamId)
  output <- .supportapp$register_slack_workspace_for_organization_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$register_slack_workspace_for_organization <- supportapp_register_slack_workspace_for_organization

#' Updates the configuration for a Slack channel, such as case update
#' notifications
#'
#' @description
#' Updates the configuration for a Slack channel, such as case update notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/supportapp_update_slack_channel_configuration/](https://www.paws-r-sdk.com/docs/supportapp_update_slack_channel_configuration/) for full documentation.
#'
#' @param channelId &#91;required&#93; The channel ID in Slack. This ID identifies a channel within a Slack
#' workspace.
#' @param channelName The Slack channel name that you want to update.
#' @param channelRoleArn The Amazon Resource Name (ARN) of an IAM role that you want to use to
#' perform operations on Amazon Web Services. For more information, see
#' [Managing access to the Amazon Web Services Support
#' App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
#' in the *Amazon Web Services Support User Guide*.
#' @param notifyOnAddCorrespondenceToCase Whether you want to get notified when a support case has a new
#' correspondence.
#' @param notifyOnCaseSeverity The case severity for a support case that you want to receive
#' notifications.
#' 
#' If you specify `high` or `all`, at least one of the following parameters
#' must be `true`:
#' 
#' -   `notifyOnAddCorrespondenceToCase`
#' 
#' -   `notifyOnCreateOrReopenCase`
#' 
#' -   `notifyOnResolveCase`
#' 
#' If you specify `none`, any of the following parameters that you specify
#' in your request must be `false`:
#' 
#' -   `notifyOnAddCorrespondenceToCase`
#' 
#' -   `notifyOnCreateOrReopenCase`
#' 
#' -   `notifyOnResolveCase`
#' 
#' If you don't specify these parameters in your request, the Amazon Web
#' Services Support App uses the current values by default.
#' @param notifyOnCreateOrReopenCase Whether you want to get notified when a support case is created or
#' reopened.
#' @param notifyOnResolveCase Whether you want to get notified when a support case is resolved.
#' @param teamId &#91;required&#93; The team ID in Slack. This ID uniquely identifies a Slack workspace,
#' such as `T012ABCDEFG`.
#'
#' @keywords internal
#'
#' @rdname supportapp_update_slack_channel_configuration
supportapp_update_slack_channel_configuration <- function(channelId, channelName = NULL, channelRoleArn = NULL, notifyOnAddCorrespondenceToCase = NULL, notifyOnCaseSeverity = NULL, notifyOnCreateOrReopenCase = NULL, notifyOnResolveCase = NULL, teamId) {
  op <- new_operation(
    name = "UpdateSlackChannelConfiguration",
    http_method = "POST",
    http_path = "/control/update-slack-channel-configuration",
    paginator = list()
  )
  input <- .supportapp$update_slack_channel_configuration_input(channelId = channelId, channelName = channelName, channelRoleArn = channelRoleArn, notifyOnAddCorrespondenceToCase = notifyOnAddCorrespondenceToCase, notifyOnCaseSeverity = notifyOnCaseSeverity, notifyOnCreateOrReopenCase = notifyOnCreateOrReopenCase, notifyOnResolveCase = notifyOnResolveCase, teamId = teamId)
  output <- .supportapp$update_slack_channel_configuration_output()
  config <- get_config()
  svc <- .supportapp$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.supportapp$operations$update_slack_channel_configuration <- supportapp_update_slack_channel_configuration
