% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_test_invoke_method}
\alias{apigateway_test_invoke_method}
\title{Simulate the execution of a Method in your RestApi with headers,
parameters, and an incoming request body}
\usage{
apigateway_test_invoke_method(restApiId, resourceId, httpMethod,
  pathWithQueryString, body, headers, multiValueHeaders,
  clientCertificateId, stageVariables)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] [Required] Specifies a test invoke method request's resource ID.}

\item{httpMethod}{[required] [Required] Specifies a test invoke method request's HTTP method.}

\item{pathWithQueryString}{The URI path, including query string, of the simulated invocation
request. Use this to specify path parameters and query string
parameters.}

\item{body}{The simulated request body of an incoming invocation request.}

\item{headers}{A key-value map of headers to simulate an incoming invocation request.}

\item{multiValueHeaders}{The headers as a map from string to list of values to simulate an
incoming invocation request.}

\item{clientCertificateId}{A ClientCertificate identifier to use in the test invocation. API
Gateway will use the certificate when making the HTTPS request to the
defined back-end endpoint.}

\item{stageVariables}{A key-value map of stage variables to simulate an invocation on a
deployed Stage.}
}
\description{
Simulate the execution of a Method in your RestApi with headers,
parameters, and an incoming request body.
}
\section{Request syntax}{
\preformatted{svc$test_invoke_method(
  restApiId = "string",
  resourceId = "string",
  httpMethod = "string",
  pathWithQueryString = "string",
  body = "string",
  headers = list(
    "string"
  ),
  multiValueHeaders = list(
    list(
      "string"
    )
  ),
  clientCertificateId = "string",
  stageVariables = list(
    "string"
  )
)
}
}

\keyword{internal}
