% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_create_resolver_query_log_config}
\alias{route53resolver_create_resolver_query_log_config}
\title{Creates a Resolver query logging configuration, which defines where you
want Resolver to save DNS query logs that originate in your VPCs}
\usage{
route53resolver_create_resolver_query_log_config(Name, DestinationArn,
  CreatorRequestId, Tags)
}
\arguments{
\item{Name}{[required] The name that you want to give the query logging configuration}

\item{DestinationArn}{[required] The ARN of the resource that you want Resolver to send query logs. You
can send query logs to an S3 bucket, a CloudWatch Logs log group, or a
Kinesis Data Firehose delivery stream. Examples of valid values include
the following:
\itemize{
\item \strong{S3 bucket}:

\code{arn:aws:s3:::examplebucket}

You can optionally append a file prefix to the end of the ARN.

\verb{arn:aws:s3:::examplebucket/development/}
\item \strong{CloudWatch Logs log group}:

\verb{arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*}
\item \strong{Kinesis Data Firehose delivery stream}:

\code{arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name}
}}

\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows failed
requests to be retried without the risk of executing the operation
twice. \code{CreatorRequestId} can be any unique string, for example, a
date/time stamp.}

\item{Tags}{A list of the tag keys and values that you want to associate with the
query logging configuration.}
}
\description{
Creates a Resolver query logging configuration, which defines where you
want Resolver to save DNS query logs that originate in your VPCs.
Resolver can log queries only for VPCs that are in the same Region as
the query logging configuration.

To specify which VPCs you want to log queries for, you use
\code{AssociateResolverQueryLogConfig}. For more information, see
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html}{AssociateResolverQueryLogConfig}.

You can optionally use AWS Resource Access Manager (AWS RAM) to share a
query logging configuration with other AWS accounts. The other accounts
can then associate VPCs with the configuration. The query logs that
Resolver creates for a configuration include all DNS queries that
originate in all VPCs that are associated with the configuration.
}
\section{Request syntax}{
\preformatted{svc$create_resolver_query_log_config(
  Name = "string",
  DestinationArn = "string",
  CreatorRequestId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
