% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_get_field_level_encryption}
\alias{cloudfront_get_field_level_encryption}
\title{Get the field-level encryption configuration information}
\usage{
cloudfront_get_field_level_encryption(Id)
}
\arguments{
\item{Id}{[required] Request the ID for the field-level encryption configuration information.}
}
\value{
A list with the following syntax:\preformatted{list(
  FieldLevelEncryption = list(
    Id = "string",
    LastModifiedTime = as.POSIXct(
      "2015-01-01"
    ),
    FieldLevelEncryptionConfig = list(
      CallerReference = "string",
      Comment = "string",
      QueryArgProfileConfig = list(
        ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
        QueryArgProfiles = list(
          Quantity = 123,
          Items = list(
            list(
              QueryArg = "string",
              ProfileId = "string"
            )
          )
        )
      ),
      ContentTypeProfileConfig = list(
        ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
        ContentTypeProfiles = list(
          Quantity = 123,
          Items = list(
            list(
              Format = "URLEncoded",
              ProfileId = "string",
              ContentType = "string"
            )
          )
        )
      )
    )
  ),
  ETag = "string"
)
}
}
\description{
Get the field-level encryption configuration information.
}
\section{Request syntax}{
\preformatted{svc$get_field_level_encryption(
  Id = "string"
)
}
}

\keyword{internal}
