% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_delete_bgp_peer}
\alias{directconnect_delete_bgp_peer}
\title{Deletes the specified BGP peer on the specified virtual interface with
the specified customer address and ASN}
\usage{
directconnect_delete_bgp_peer(virtualInterfaceId, asn, customerAddress,
  bgpPeerId)
}
\arguments{
\item{virtualInterfaceId}{The ID of the virtual interface.}

\item{asn}{The autonomous system (AS) number for Border Gateway Protocol (BGP)
configuration.}

\item{customerAddress}{The IP address assigned to the customer interface.}

\item{bgpPeerId}{The ID of the BGP peer.}
}
\value{
A list with the following syntax:\preformatted{list(
  virtualInterface = list(
    ownerAccount = "string",
    virtualInterfaceId = "string",
    location = "string",
    connectionId = "string",
    virtualInterfaceType = "string",
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    amazonSideAsn = 123,
    authKey = "string",
    amazonAddress = "string",
    customerAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    virtualInterfaceState = "confirming"|"verifying"|"pending"|"available"|"down"|"deleting"|"deleted"|"rejected"|"unknown",
    customerRouterConfig = "string",
    mtu = 123,
    jumboFrameCapable = TRUE|FALSE,
    virtualGatewayId = "string",
    directConnectGatewayId = "string",
    routeFilterPrefixes = list(
      list(
        cidr = "string"
      )
    ),
    bgpPeers = list(
      list(
        bgpPeerId = "string",
        asn = 123,
        authKey = "string",
        addressFamily = "ipv4"|"ipv6",
        amazonAddress = "string",
        customerAddress = "string",
        bgpPeerState = "verifying"|"pending"|"available"|"deleting"|"deleted",
        bgpStatus = "up"|"down"|"unknown",
        awsDeviceV2 = "string"
      )
    ),
    region = "string",
    awsDeviceV2 = "string",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}
\description{
Deletes the specified BGP peer on the specified virtual interface with
the specified customer address and ASN.

You cannot delete the last BGP peer from a virtual interface.
}
\section{Request syntax}{
\preformatted{svc$delete_bgp_peer(
  virtualInterfaceId = "string",
  asn = 123,
  customerAddress = "string",
  bgpPeerId = "string"
)
}
}

\keyword{internal}
