% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_get_hosted_zone_limit}
\alias{route53_get_hosted_zone_limit}
\title{Gets the specified limit for a specified hosted zone, for example, the
maximum number of records that you can create in the hosted zone}
\usage{
route53_get_hosted_zone_limit(Type, HostedZoneId)
}
\arguments{
\item{Type}{[required] The limit that you want to get. Valid values include the following:
\itemize{
\item \strong{MAX_RRSETS_BY_ZONE}: The maximum number of records that you
can create in the specified hosted zone.
\item \strong{MAX_VPCS_ASSOCIATED_BY_ZONE}: The maximum number of Amazon
VPCs that you can associate with the specified private hosted zone.
}}

\item{HostedZoneId}{[required] The ID of the hosted zone that you want to get a limit for.}
}
\value{
A list with the following syntax:\preformatted{list(
  Limit = list(
    Type = "MAX_RRSETS_BY_ZONE"|"MAX_VPCS_ASSOCIATED_BY_ZONE",
    Value = 123
  ),
  Count = 123
)
}
}
\description{
Gets the specified limit for a specified hosted zone, for example, the
maximum number of records that you can create in the hosted zone.

For the default limit, see
\href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html}{Limits}
in the \emph{Amazon Route 53 Developer Guide}. To request a higher limit,
open a case.
}
\section{Request syntax}{
\preformatted{svc$get_hosted_zone_limit(
  Type = "MAX_RRSETS_BY_ZONE"|"MAX_VPCS_ASSOCIATED_BY_ZONE",
  HostedZoneId = "string"
)
}
}

\keyword{internal}
