% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_list_operations}
\alias{route53domains_list_operations}
\title{This operation returns the operation IDs of operations that are not yet
complete}
\usage{
route53domains_list_operations(SubmittedSince, Marker, MaxItems)
}
\arguments{
\item{SubmittedSince}{An optional parameter that lets you get information about all the
operations that you submitted after a specified date and time. Specify
the date and time in Coordinated Universal time (UTC).}

\item{Marker}{For an initial request for a list of operations, omit this element. If
the number of operations that are not yet complete is greater than the
value that you specified for \code{MaxItems}, you can use \code{Marker} to return
additional operations. Get the value of \code{NextPageMarker} from the
previous response, and submit another request that includes the value of
\code{NextPageMarker} in the \code{Marker} element.}

\item{MaxItems}{Number of domains to be returned.

Default: 20}
}
\description{
This operation returns the operation IDs of operations that are not yet
complete.
}
\section{Request syntax}{
\preformatted{svc$list_operations(
  SubmittedSince = as.POSIXct(
    "2015-01-01"
  ),
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
