# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53domains_service.R
NULL

#' This operation checks the availability of one domain name
#'
#' This operation checks the availability of one domain name. Note that if
#' the availability status of a domain is pending, you must submit another
#' request to determine the availability of the domain name.
#'
#' @usage
#' route53domains_check_domain_availability(DomainName, IdnLangCode)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to get availability for.
#' 
#' Constraints: The domain name can contain only the letters a through z,
#' the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
#' are not supported.
#' @param IdnLangCode Reserved for future use.
#'
#' @section Request syntax:
#' ```
#' svc$check_domain_availability(
#'   DomainName = "string",
#'   IdnLangCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_check_domain_availability
route53domains_check_domain_availability <- function(DomainName, IdnLangCode = NULL) {
  op <- new_operation(
    name = "CheckDomainAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$check_domain_availability_input(DomainName = DomainName, IdnLangCode = IdnLangCode)
  output <- .route53domains$check_domain_availability_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$check_domain_availability <- route53domains_check_domain_availability

#' Checks whether a domain name can be transferred to Amazon Route 53
#'
#' Checks whether a domain name can be transferred to Amazon Route 53.
#'
#' @usage
#' route53domains_check_domain_transferability(DomainName, AuthCode)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to transfer to Amazon Route 53.
#' 
#' Constraints: The domain name can contain only the letters a through z,
#' the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
#' are not supported.
#' @param AuthCode If the registrar for the top-level domain (TLD) requires an
#' authorization code to transfer the domain, the code that you got from
#' the current registrar for the domain.
#'
#' @section Request syntax:
#' ```
#' svc$check_domain_transferability(
#'   DomainName = "string",
#'   AuthCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_check_domain_transferability
route53domains_check_domain_transferability <- function(DomainName, AuthCode = NULL) {
  op <- new_operation(
    name = "CheckDomainTransferability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$check_domain_transferability_input(DomainName = DomainName, AuthCode = AuthCode)
  output <- .route53domains$check_domain_transferability_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$check_domain_transferability <- route53domains_check_domain_transferability

#' This operation deletes the specified tags for a domain
#'
#' This operation deletes the specified tags for a domain.
#' 
#' All tag operations are eventually consistent; subsequent operations
#' might not immediately represent all issued operations.
#'
#' @usage
#' route53domains_delete_tags_for_domain(DomainName, TagsToDelete)
#'
#' @param DomainName &#91;required&#93; The domain for which you want to delete one or more tags.
#' @param TagsToDelete &#91;required&#93; A list of tag keys to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags_for_domain(
#'   DomainName = "string",
#'   TagsToDelete = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_delete_tags_for_domain
route53domains_delete_tags_for_domain <- function(DomainName, TagsToDelete) {
  op <- new_operation(
    name = "DeleteTagsForDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$delete_tags_for_domain_input(DomainName = DomainName, TagsToDelete = TagsToDelete)
  output <- .route53domains$delete_tags_for_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$delete_tags_for_domain <- route53domains_delete_tags_for_domain

#' This operation disables automatic renewal of domain registration for the
#' specified domain
#'
#' This operation disables automatic renewal of domain registration for the
#' specified domain.
#'
#' @usage
#' route53domains_disable_domain_auto_renew(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to disable automatic renewal for.
#'
#' @section Request syntax:
#' ```
#' svc$disable_domain_auto_renew(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_disable_domain_auto_renew
route53domains_disable_domain_auto_renew <- function(DomainName) {
  op <- new_operation(
    name = "DisableDomainAutoRenew",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$disable_domain_auto_renew_input(DomainName = DomainName)
  output <- .route53domains$disable_domain_auto_renew_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$disable_domain_auto_renew <- route53domains_disable_domain_auto_renew

#' This operation removes the transfer lock on the domain (specifically the
#' clientTransferProhibited status) to allow domain transfers
#'
#' This operation removes the transfer lock on the domain (specifically the
#' `clientTransferProhibited` status) to allow domain transfers. We
#' recommend you refrain from performing this action unless you intend to
#' transfer the domain to a different registrar. Successful submission
#' returns an operation ID that you can use to track the progress and
#' completion of the action. If the request is not completed successfully,
#' the domain registrant will be notified by email.
#'
#' @usage
#' route53domains_disable_domain_transfer_lock(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to remove the transfer lock for.
#'
#' @section Request syntax:
#' ```
#' svc$disable_domain_transfer_lock(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_disable_domain_transfer_lock
route53domains_disable_domain_transfer_lock <- function(DomainName) {
  op <- new_operation(
    name = "DisableDomainTransferLock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$disable_domain_transfer_lock_input(DomainName = DomainName)
  output <- .route53domains$disable_domain_transfer_lock_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$disable_domain_transfer_lock <- route53domains_disable_domain_transfer_lock

#' This operation configures Amazon Route 53 to automatically renew the
#' specified domain before the domain registration expires
#'
#' This operation configures Amazon Route 53 to automatically renew the
#' specified domain before the domain registration expires. The cost of
#' renewing your domain registration is billed to your AWS account.
#' 
#' The period during which you can renew a domain name varies by TLD. For a
#' list of TLDs and their renewal policies, see [\"Renewal, restoration,
#' and deletion
#' times\"](http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times)
#' on the website for our registrar associate, Gandi. Amazon Route 53
#' requires that you renew before the end of the renewal period that is
#' listed on the Gandi website so we can complete processing before the
#' deadline.
#'
#' @usage
#' route53domains_enable_domain_auto_renew(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to enable automatic renewal for.
#'
#' @section Request syntax:
#' ```
#' svc$enable_domain_auto_renew(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_enable_domain_auto_renew
route53domains_enable_domain_auto_renew <- function(DomainName) {
  op <- new_operation(
    name = "EnableDomainAutoRenew",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$enable_domain_auto_renew_input(DomainName = DomainName)
  output <- .route53domains$enable_domain_auto_renew_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$enable_domain_auto_renew <- route53domains_enable_domain_auto_renew

#' This operation sets the transfer lock on the domain (specifically the
#' clientTransferProhibited status) to prevent domain transfers
#'
#' This operation sets the transfer lock on the domain (specifically the
#' `clientTransferProhibited` status) to prevent domain transfers.
#' Successful submission returns an operation ID that you can use to track
#' the progress and completion of the action. If the request is not
#' completed successfully, the domain registrant will be notified by email.
#'
#' @usage
#' route53domains_enable_domain_transfer_lock(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to set the transfer lock for.
#'
#' @section Request syntax:
#' ```
#' svc$enable_domain_transfer_lock(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_enable_domain_transfer_lock
route53domains_enable_domain_transfer_lock <- function(DomainName) {
  op <- new_operation(
    name = "EnableDomainTransferLock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$enable_domain_transfer_lock_input(DomainName = DomainName)
  output <- .route53domains$enable_domain_transfer_lock_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$enable_domain_transfer_lock <- route53domains_enable_domain_transfer_lock

#' For operations that require confirmation that the email address for the
#' registrant contact is valid, such as registering a new domain, this
#' operation returns information about whether the registrant contact has
#' responded
#'
#' For operations that require confirmation that the email address for the
#' registrant contact is valid, such as registering a new domain, this
#' operation returns information about whether the registrant contact has
#' responded.
#' 
#' If you want us to resend the email, use the
#' `ResendContactReachabilityEmail` operation.
#'
#' @usage
#' route53domains_get_contact_reachability_status(domainName)
#'
#' @param domainName The name of the domain for which you want to know whether the registrant
#' contact has confirmed that the email address is valid.
#'
#' @section Request syntax:
#' ```
#' svc$get_contact_reachability_status(
#'   domainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_get_contact_reachability_status
route53domains_get_contact_reachability_status <- function(domainName = NULL) {
  op <- new_operation(
    name = "GetContactReachabilityStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$get_contact_reachability_status_input(domainName = domainName)
  output <- .route53domains$get_contact_reachability_status_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_contact_reachability_status <- route53domains_get_contact_reachability_status

#' This operation returns detailed information about a specified domain
#' that is associated with the current AWS account
#'
#' This operation returns detailed information about a specified domain
#' that is associated with the current AWS account. Contact information for
#' the domain is also returned as part of the output.
#'
#' @usage
#' route53domains_get_domain_detail(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to get detailed information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_domain_detail(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_get_domain_detail
route53domains_get_domain_detail <- function(DomainName) {
  op <- new_operation(
    name = "GetDomainDetail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$get_domain_detail_input(DomainName = DomainName)
  output <- .route53domains$get_domain_detail_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_domain_detail <- route53domains_get_domain_detail

#' The GetDomainSuggestions operation returns a list of suggested domain
#' names given a string, which can either be a domain name or simply a word
#' or phrase (without spaces)
#'
#' The GetDomainSuggestions operation returns a list of suggested domain
#' names given a string, which can either be a domain name or simply a word
#' or phrase (without spaces).
#'
#' @usage
#' route53domains_get_domain_suggestions(DomainName, SuggestionCount,
#'   OnlyAvailable)
#'
#' @param DomainName &#91;required&#93; A domain name that you want to use as the basis for a list of possible
#' domain names. The domain name must contain a top-level domain (TLD),
#' such as .com, that Amazon Route 53 supports. For a list of TLDs, see
#' [Domains that You Can Register with Amazon Route
#' 53](http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' @param SuggestionCount &#91;required&#93; The number of suggested domain names that you want Amazon Route 53 to
#' return.
#' @param OnlyAvailable &#91;required&#93; If `OnlyAvailable` is `true`, Amazon Route 53 returns only domain names
#' that are available. If `OnlyAvailable` is `false`, Amazon Route 53
#' returns domain names without checking whether they\'re available to be
#' registered. To determine whether the domain is available, you can call
#' `checkDomainAvailability` for each suggestion.
#'
#' @section Request syntax:
#' ```
#' svc$get_domain_suggestions(
#'   DomainName = "string",
#'   SuggestionCount = 123,
#'   OnlyAvailable = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_get_domain_suggestions
route53domains_get_domain_suggestions <- function(DomainName, SuggestionCount, OnlyAvailable) {
  op <- new_operation(
    name = "GetDomainSuggestions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$get_domain_suggestions_input(DomainName = DomainName, SuggestionCount = SuggestionCount, OnlyAvailable = OnlyAvailable)
  output <- .route53domains$get_domain_suggestions_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_domain_suggestions <- route53domains_get_domain_suggestions

#' This operation returns the current status of an operation that is not
#' completed
#'
#' This operation returns the current status of an operation that is not
#' completed.
#'
#' @usage
#' route53domains_get_operation_detail(OperationId)
#'
#' @param OperationId &#91;required&#93; The identifier for the operation for which you want to get the status.
#' Amazon Route 53 returned the identifier in the response to the original
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$get_operation_detail(
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_get_operation_detail
route53domains_get_operation_detail <- function(OperationId) {
  op <- new_operation(
    name = "GetOperationDetail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$get_operation_detail_input(OperationId = OperationId)
  output <- .route53domains$get_operation_detail_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$get_operation_detail <- route53domains_get_operation_detail

#' This operation returns all the domain names registered with Amazon Route
#' 53 for the current AWS account
#'
#' This operation returns all the domain names registered with Amazon Route
#' 53 for the current AWS account.
#'
#' @usage
#' route53domains_list_domains(Marker, MaxItems)
#'
#' @param Marker For an initial request for a list of domains, omit this element. If the
#' number of domains that are associated with the current AWS account is
#' greater than the value that you specified for `MaxItems`, you can use
#' `Marker` to return additional domains. Get the value of `NextPageMarker`
#' from the previous response, and submit another request that includes the
#' value of `NextPageMarker` in the `Marker` element.
#' 
#' Constraints: The marker must match the value specified in the previous
#' request.
#' @param MaxItems Number of domains to be returned.
#' 
#' Default: 20
#'
#' @section Request syntax:
#' ```
#' svc$list_domains(
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_list_domains
route53domains_list_domains <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$list_domains_input(Marker = Marker, MaxItems = MaxItems)
  output <- .route53domains$list_domains_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_domains <- route53domains_list_domains

#' This operation returns the operation IDs of operations that are not yet
#' complete
#'
#' This operation returns the operation IDs of operations that are not yet
#' complete.
#'
#' @usage
#' route53domains_list_operations(SubmittedSince, Marker, MaxItems)
#'
#' @param SubmittedSince An optional parameter that lets you get information about all the
#' operations that you submitted after a specified date and time. Specify
#' the date and time in Coordinated Universal time (UTC).
#' @param Marker For an initial request for a list of operations, omit this element. If
#' the number of operations that are not yet complete is greater than the
#' value that you specified for `MaxItems`, you can use `Marker` to return
#' additional operations. Get the value of `NextPageMarker` from the
#' previous response, and submit another request that includes the value of
#' `NextPageMarker` in the `Marker` element.
#' @param MaxItems Number of domains to be returned.
#' 
#' Default: 20
#'
#' @section Request syntax:
#' ```
#' svc$list_operations(
#'   SubmittedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_list_operations
route53domains_list_operations <- function(SubmittedSince = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$list_operations_input(SubmittedSince = SubmittedSince, Marker = Marker, MaxItems = MaxItems)
  output <- .route53domains$list_operations_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_operations <- route53domains_list_operations

#' This operation returns all of the tags that are associated with the
#' specified domain
#'
#' This operation returns all of the tags that are associated with the
#' specified domain.
#' 
#' All tag operations are eventually consistent; subsequent operations
#' might not immediately represent all issued operations.
#'
#' @usage
#' route53domains_list_tags_for_domain(DomainName)
#'
#' @param DomainName &#91;required&#93; The domain for which you want to get a list of tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_domain(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_list_tags_for_domain
route53domains_list_tags_for_domain <- function(DomainName) {
  op <- new_operation(
    name = "ListTagsForDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$list_tags_for_domain_input(DomainName = DomainName)
  output <- .route53domains$list_tags_for_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$list_tags_for_domain <- route53domains_list_tags_for_domain

#' This operation registers a domain
#'
#' This operation registers a domain. Domains are registered either by
#' Amazon Registrar (for .com, .net, and .org domains) or by our registrar
#' associate, Gandi (for all other domains). For some top-level domains
#' (TLDs), this operation requires extra parameters.
#' 
#' When you register a domain, Amazon Route 53 does the following:
#' 
#' -   Creates a Amazon Route 53 hosted zone that has the same name as the
#'     domain. Amazon Route 53 assigns four name servers to your hosted
#'     zone and automatically updates your domain registration with the
#'     names of these name servers.
#' 
#' -   Enables autorenew, so your domain registration will renew
#'     automatically each year. We\'ll notify you in advance of the renewal
#'     date so you can choose whether to renew the registration.
#' 
#' -   Optionally enables privacy protection, so WHOIS queries return
#'     contact information either for Amazon Registrar (for .com, .net, and
#'     .org domains) or for our registrar associate, Gandi (for all other
#'     TLDs). If you don\'t enable privacy protection, WHOIS queries return
#'     the information that you entered for the registrant, admin, and tech
#'     contacts.
#' 
#' -   If registration is successful, returns an operation ID that you can
#'     use to track the progress and completion of the action. If the
#'     request is not completed successfully, the domain registrant is
#'     notified by email.
#' 
#' -   Charges your AWS account an amount based on the top-level domain.
#'     For more information, see [Amazon Route 53
#'     Pricing](http://aws.amazon.com/route53/pricing/).
#'
#' @usage
#' route53domains_register_domain(DomainName, IdnLangCode, DurationInYears,
#'   AutoRenew, AdminContact, RegistrantContact, TechContact,
#'   PrivacyProtectAdminContact, PrivacyProtectRegistrantContact,
#'   PrivacyProtectTechContact)
#'
#' @param DomainName &#91;required&#93; The domain name that you want to register.
#' 
#' Constraints: The domain name can contain only the letters a through z,
#' the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
#' are not supported.
#' @param IdnLangCode Reserved for future use.
#' @param DurationInYears &#91;required&#93; The number of years that you want to register the domain for. Domains
#' are registered for a minimum of one year. The maximum period depends on
#' the top-level domain. For the range of valid values for your domain, see
#' [Domains that You Can Register with Amazon Route
#' 53](http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' Default: 1
#' @param AutoRenew Indicates whether the domain will be automatically renewed (`true`) or
#' not (`false`). Autorenewal only takes effect after the account is
#' charged.
#' 
#' Default: `true`
#' @param AdminContact &#91;required&#93; Provides detailed contact information.
#' @param RegistrantContact &#91;required&#93; Provides detailed contact information.
#' @param TechContact &#91;required&#93; Provides detailed contact information.
#' @param PrivacyProtectAdminContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the admin contact.
#' 
#' Default: `true`
#' @param PrivacyProtectRegistrantContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the registrant contact (the domain owner).
#' 
#' Default: `true`
#' @param PrivacyProtectTechContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the technical contact.
#' 
#' Default: `true`
#'
#' @section Request syntax:
#' ```
#' svc$register_domain(
#'   DomainName = "string",
#'   IdnLangCode = "string",
#'   DurationInYears = 123,
#'   AutoRenew = TRUE|FALSE,
#'   AdminContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   RegistrantContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   TechContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   PrivacyProtectAdminContact = TRUE|FALSE,
#'   PrivacyProtectRegistrantContact = TRUE|FALSE,
#'   PrivacyProtectTechContact = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_register_domain
route53domains_register_domain <- function(DomainName, IdnLangCode = NULL, DurationInYears, AutoRenew = NULL, AdminContact, RegistrantContact, TechContact, PrivacyProtectAdminContact = NULL, PrivacyProtectRegistrantContact = NULL, PrivacyProtectTechContact = NULL) {
  op <- new_operation(
    name = "RegisterDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$register_domain_input(DomainName = DomainName, IdnLangCode = IdnLangCode, DurationInYears = DurationInYears, AutoRenew = AutoRenew, AdminContact = AdminContact, RegistrantContact = RegistrantContact, TechContact = TechContact, PrivacyProtectAdminContact = PrivacyProtectAdminContact, PrivacyProtectRegistrantContact = PrivacyProtectRegistrantContact, PrivacyProtectTechContact = PrivacyProtectTechContact)
  output <- .route53domains$register_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$register_domain <- route53domains_register_domain

#' This operation renews a domain for the specified number of years
#'
#' This operation renews a domain for the specified number of years. The
#' cost of renewing your domain is billed to your AWS account.
#' 
#' We recommend that you renew your domain several weeks before the
#' expiration date. Some TLD registries delete domains before the
#' expiration date if you haven\'t renewed far enough in advance. For more
#' information about renewing domain registration, see [Renewing
#' Registration for a
#' Domain](http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html)
#' in the Amazon Route 53 Developer Guide.
#'
#' @usage
#' route53domains_renew_domain(DomainName, DurationInYears,
#'   CurrentExpiryYear)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to renew.
#' @param DurationInYears The number of years that you want to renew the domain for. The maximum
#' number of years depends on the top-level domain. For the range of valid
#' values for your domain, see [Domains that You Can Register with Amazon
#' Route
#' 53](http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' Default: 1
#' @param CurrentExpiryYear &#91;required&#93; The year when the registration for the domain is set to expire. This
#' value must match the current expiration date for the domain.
#'
#' @section Request syntax:
#' ```
#' svc$renew_domain(
#'   DomainName = "string",
#'   DurationInYears = 123,
#'   CurrentExpiryYear = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_renew_domain
route53domains_renew_domain <- function(DomainName, DurationInYears = NULL, CurrentExpiryYear) {
  op <- new_operation(
    name = "RenewDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$renew_domain_input(DomainName = DomainName, DurationInYears = DurationInYears, CurrentExpiryYear = CurrentExpiryYear)
  output <- .route53domains$renew_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$renew_domain <- route53domains_renew_domain

#' For operations that require confirmation that the email address for the
#' registrant contact is valid, such as registering a new domain, this
#' operation resends the confirmation email to the current email address
#' for the registrant contact
#'
#' For operations that require confirmation that the email address for the
#' registrant contact is valid, such as registering a new domain, this
#' operation resends the confirmation email to the current email address
#' for the registrant contact.
#'
#' @usage
#' route53domains_resend_contact_reachability_email(domainName)
#'
#' @param domainName The name of the domain for which you want Amazon Route 53 to resend a
#' confirmation email to the registrant contact.
#'
#' @section Request syntax:
#' ```
#' svc$resend_contact_reachability_email(
#'   domainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_resend_contact_reachability_email
route53domains_resend_contact_reachability_email <- function(domainName = NULL) {
  op <- new_operation(
    name = "ResendContactReachabilityEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$resend_contact_reachability_email_input(domainName = domainName)
  output <- .route53domains$resend_contact_reachability_email_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$resend_contact_reachability_email <- route53domains_resend_contact_reachability_email

#' This operation returns the AuthCode for the domain
#'
#' This operation returns the AuthCode for the domain. To transfer a domain
#' to another registrar, you provide this value to the new registrar.
#'
#' @usage
#' route53domains_retrieve_domain_auth_code(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to get an authorization code for.
#'
#' @section Request syntax:
#' ```
#' svc$retrieve_domain_auth_code(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_retrieve_domain_auth_code
route53domains_retrieve_domain_auth_code <- function(DomainName) {
  op <- new_operation(
    name = "RetrieveDomainAuthCode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$retrieve_domain_auth_code_input(DomainName = DomainName)
  output <- .route53domains$retrieve_domain_auth_code_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$retrieve_domain_auth_code <- route53domains_retrieve_domain_auth_code

#' This operation transfers a domain from another registrar to Amazon Route
#' 53
#'
#' This operation transfers a domain from another registrar to Amazon Route
#' 53. When the transfer is complete, the domain is registered either with
#' Amazon Registrar (for .com, .net, and .org domains) or with our
#' registrar associate, Gandi (for all other TLDs).
#' 
#' For transfer requirements, a detailed procedure, and information about
#' viewing the status of a domain transfer, see [Transferring Registration
#' for a Domain to Amazon Route
#' 53](http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' If the registrar for your domain is also the DNS service provider for
#' the domain, we highly recommend that you consider transferring your DNS
#' service to Amazon Route 53 or to another DNS service provider before you
#' transfer your registration. Some registrars provide free DNS service
#' when you purchase a domain registration. When you transfer the
#' registration, the previous registrar will not renew your domain
#' registration and could end your DNS service at any time.
#' 
#' If the registrar for your domain is also the DNS service provider for
#' the domain and you don\'t transfer DNS service to another provider, your
#' website, email, and the web applications associated with the domain
#' might become unavailable.
#' 
#' If the transfer is successful, this method returns an operation ID that
#' you can use to track the progress and completion of the action. If the
#' transfer doesn\'t complete successfully, the domain registrant will be
#' notified by email.
#'
#' @usage
#' route53domains_transfer_domain(DomainName, IdnLangCode, DurationInYears,
#'   Nameservers, AuthCode, AutoRenew, AdminContact, RegistrantContact,
#'   TechContact, PrivacyProtectAdminContact,
#'   PrivacyProtectRegistrantContact, PrivacyProtectTechContact)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to transfer to Amazon Route 53.
#' 
#' Constraints: The domain name can contain only the letters a through z,
#' the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
#' are not supported.
#' @param IdnLangCode Reserved for future use.
#' @param DurationInYears &#91;required&#93; The number of years that you want to register the domain for. Domains
#' are registered for a minimum of one year. The maximum period depends on
#' the top-level domain.
#' 
#' Default: 1
#' @param Nameservers Contains details for the host and glue IP addresses.
#' @param AuthCode The authorization code for the domain. You get this value from the
#' current registrar.
#' @param AutoRenew Indicates whether the domain will be automatically renewed (true) or not
#' (false). Autorenewal only takes effect after the account is charged.
#' 
#' Default: true
#' @param AdminContact &#91;required&#93; Provides detailed contact information.
#' @param RegistrantContact &#91;required&#93; Provides detailed contact information.
#' @param TechContact &#91;required&#93; Provides detailed contact information.
#' @param PrivacyProtectAdminContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the admin contact.
#' 
#' Default: `true`
#' @param PrivacyProtectRegistrantContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the registrant contact (domain owner).
#' 
#' Default: `true`
#' @param PrivacyProtectTechContact Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the technical contact.
#' 
#' Default: `true`
#'
#' @section Request syntax:
#' ```
#' svc$transfer_domain(
#'   DomainName = "string",
#'   IdnLangCode = "string",
#'   DurationInYears = 123,
#'   Nameservers = list(
#'     list(
#'       Name = "string",
#'       GlueIps = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   AuthCode = "string",
#'   AutoRenew = TRUE|FALSE,
#'   AdminContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   RegistrantContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   TechContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   PrivacyProtectAdminContact = TRUE|FALSE,
#'   PrivacyProtectRegistrantContact = TRUE|FALSE,
#'   PrivacyProtectTechContact = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_transfer_domain
route53domains_transfer_domain <- function(DomainName, IdnLangCode = NULL, DurationInYears, Nameservers = NULL, AuthCode = NULL, AutoRenew = NULL, AdminContact, RegistrantContact, TechContact, PrivacyProtectAdminContact = NULL, PrivacyProtectRegistrantContact = NULL, PrivacyProtectTechContact = NULL) {
  op <- new_operation(
    name = "TransferDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$transfer_domain_input(DomainName = DomainName, IdnLangCode = IdnLangCode, DurationInYears = DurationInYears, Nameservers = Nameservers, AuthCode = AuthCode, AutoRenew = AutoRenew, AdminContact = AdminContact, RegistrantContact = RegistrantContact, TechContact = TechContact, PrivacyProtectAdminContact = PrivacyProtectAdminContact, PrivacyProtectRegistrantContact = PrivacyProtectRegistrantContact, PrivacyProtectTechContact = PrivacyProtectTechContact)
  output <- .route53domains$transfer_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$transfer_domain <- route53domains_transfer_domain

#' This operation updates the contact information for a particular domain
#'
#' This operation updates the contact information for a particular domain.
#' You must specify information for at least one contact: registrant,
#' administrator, or technical.
#' 
#' If the update is successful, this method returns an operation ID that
#' you can use to track the progress and completion of the action. If the
#' request is not completed successfully, the domain registrant will be
#' notified by email.
#'
#' @usage
#' route53domains_update_domain_contact(DomainName, AdminContact,
#'   RegistrantContact, TechContact)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update contact information for.
#' @param AdminContact Provides detailed contact information.
#' @param RegistrantContact Provides detailed contact information.
#' @param TechContact Provides detailed contact information.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_contact(
#'   DomainName = "string",
#'   AdminContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   RegistrantContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   TechContact = list(
#'     FirstName = "string",
#'     LastName = "string",
#'     ContactType = "PERSON"|"COMPANY"|"ASSOCIATION"|"PUBLIC_BODY"|"RESELLER",
#'     OrganizationName = "string",
#'     AddressLine1 = "string",
#'     AddressLine2 = "string",
#'     City = "string",
#'     State = "string",
#'     CountryCode = "AD"|"AE"|"AF"|"AG"|"AI"|"AL"|"AM"|"AN"|"AO"|"AQ"|"AR"|"AS"|"AT"|"AU"|"AW"|"AZ"|"BA"|"BB"|"BD"|"BE"|"BF"|"BG"|"BH"|"BI"|"BJ"|"BL"|"BM"|"BN"|"BO"|"BR"|"BS"|"BT"|"BW"|"BY"|"BZ"|"CA"|"CC"|"CD"|"CF"|"CG"|"CH"|"CI"|"CK"|"CL"|"CM"|"CN"|"CO"|"CR"|"CU"|"CV"|"CX"|"CY"|"CZ"|"DE"|"DJ"|"DK"|"DM"|"DO"|"DZ"|"EC"|"EE"|"EG"|"ER"|"ES"|"ET"|"FI"|"FJ"|"FK"|"FM"|"FO"|"FR"|"GA"|"GB"|"GD"|"GE"|"GH"|"GI"|"GL"|"GM"|"GN"|"GQ"|"GR"|"GT"|"GU"|"GW"|"GY"|"HK"|"HN"|"HR"|"HT"|"HU"|"ID"|"IE"|"IL"|"IM"|"IN"|"IQ"|"IR"|"IS"|"IT"|"JM"|"JO"|"JP"|"KE"|"KG"|"KH"|"KI"|"KM"|"KN"|"KP"|"KR"|"KW"|"KY"|"KZ"|"LA"|"LB"|"LC"|"LI"|"LK"|"LR"|"LS"|"LT"|"LU"|"LV"|"LY"|"MA"|"MC"|"MD"|"ME"|"MF"|"MG"|"MH"|"MK"|"ML"|"MM"|"MN"|"MO"|"MP"|"MR"|"MS"|"MT"|"MU"|"MV"|"MW"|"MX"|"MY"|"MZ"|"NA"|"NC"|"NE"|"NG"|"NI"|"NL"|"NO"|"NP"|"NR"|"NU"|"NZ"|"OM"|"PA"|"PE"|"PF"|"PG"|"PH"|"PK"|"PL"|"PM"|"PN"|"PR"|"PT"|"PW"|"PY"|"QA"|"RO"|"RS"|"RU"|"RW"|"SA"|"SB"|"SC"|"SD"|"SE"|"SG"|"SH"|"SI"|"SK"|"SL"|"SM"|"SN"|"SO"|"SR"|"ST"|"SV"|"SY"|"SZ"|"TC"|"TD"|"TG"|"TH"|"TJ"|"TK"|"TL"|"TM"|"TN"|"TO"|"TR"|"TT"|"TV"|"TW"|"TZ"|"UA"|"UG"|"US"|"UY"|"UZ"|"VA"|"VC"|"VE"|"VG"|"VI"|"VN"|"VU"|"WF"|"WS"|"YE"|"YT"|"ZA"|"ZM"|"ZW",
#'     ZipCode = "string",
#'     PhoneNumber = "string",
#'     Email = "string",
#'     Fax = "string",
#'     ExtraParams = list(
#'       list(
#'         Name = "DUNS_NUMBER"|"BRAND_NUMBER"|"BIRTH_DEPARTMENT"|"BIRTH_DATE_IN_YYYY_MM_DD"|"BIRTH_COUNTRY"|"BIRTH_CITY"|"DOCUMENT_NUMBER"|"AU_ID_NUMBER"|"AU_ID_TYPE"|"CA_LEGAL_TYPE"|"CA_BUSINESS_ENTITY_TYPE"|"ES_IDENTIFICATION"|"ES_IDENTIFICATION_TYPE"|"ES_LEGAL_FORM"|"FI_BUSINESS_NUMBER"|"FI_ID_NUMBER"|"FI_NATIONALITY"|"FI_ORGANIZATION_TYPE"|"IT_PIN"|"IT_REGISTRANT_ENTITY_TYPE"|"RU_PASSPORT_DATA"|"SE_ID_NUMBER"|"SG_ID_NUMBER"|"VAT_NUMBER"|"UK_CONTACT_TYPE"|"UK_COMPANY_NUMBER",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_update_domain_contact
route53domains_update_domain_contact <- function(DomainName, AdminContact = NULL, RegistrantContact = NULL, TechContact = NULL) {
  op <- new_operation(
    name = "UpdateDomainContact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$update_domain_contact_input(DomainName = DomainName, AdminContact = AdminContact, RegistrantContact = RegistrantContact, TechContact = TechContact)
  output <- .route53domains$update_domain_contact_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_domain_contact <- route53domains_update_domain_contact

#' This operation updates the specified domain contact's privacy setting
#'
#' This operation updates the specified domain contact\'s privacy setting.
#' When privacy protection is enabled, contact information such as email
#' address is replaced either with contact information for Amazon Registrar
#' (for .com, .net, and .org domains) or with contact information for our
#' registrar associate, Gandi.
#' 
#' This operation affects only the contact information for the specified
#' contact type (registrant, administrator, or tech). If the request
#' succeeds, Amazon Route 53 returns an operation ID that you can use with
#' GetOperationDetail to track the progress and completion of the action.
#' If the request doesn\'t complete successfully, the domain registrant
#' will be notified by email.
#'
#' @usage
#' route53domains_update_domain_contact_privacy(DomainName, AdminPrivacy,
#'   RegistrantPrivacy, TechPrivacy)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update the privacy setting for.
#' @param AdminPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the admin contact.
#' @param RegistrantPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the registrant contact (domain owner).
#' @param TechPrivacy Whether you want to conceal contact information from WHOIS queries. If
#' you specify `true`, WHOIS (\"who is\") queries return contact
#' information either for Amazon Registrar (for .com, .net, and .org
#' domains) or for our registrar associate, Gandi (for all other TLDs). If
#' you specify `false`, WHOIS queries return the information that you
#' entered for the technical contact.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_contact_privacy(
#'   DomainName = "string",
#'   AdminPrivacy = TRUE|FALSE,
#'   RegistrantPrivacy = TRUE|FALSE,
#'   TechPrivacy = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_update_domain_contact_privacy
route53domains_update_domain_contact_privacy <- function(DomainName, AdminPrivacy = NULL, RegistrantPrivacy = NULL, TechPrivacy = NULL) {
  op <- new_operation(
    name = "UpdateDomainContactPrivacy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$update_domain_contact_privacy_input(DomainName = DomainName, AdminPrivacy = AdminPrivacy, RegistrantPrivacy = RegistrantPrivacy, TechPrivacy = TechPrivacy)
  output <- .route53domains$update_domain_contact_privacy_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_domain_contact_privacy <- route53domains_update_domain_contact_privacy

#' This operation replaces the current set of name servers for the domain
#' with the specified set of name servers
#'
#' This operation replaces the current set of name servers for the domain
#' with the specified set of name servers. If you use Amazon Route 53 as
#' your DNS service, specify the four name servers in the delegation set
#' for the hosted zone for the domain.
#' 
#' If successful, this operation returns an operation ID that you can use
#' to track the progress and completion of the action. If the request is
#' not completed successfully, the domain registrant will be notified by
#' email.
#'
#' @usage
#' route53domains_update_domain_nameservers(DomainName, FIAuthKey,
#'   Nameservers)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to change name servers for.
#' @param FIAuthKey The authorization key for .fi domains
#' @param Nameservers &#91;required&#93; A list of new name servers for the domain.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_nameservers(
#'   DomainName = "string",
#'   FIAuthKey = "string",
#'   Nameservers = list(
#'     list(
#'       Name = "string",
#'       GlueIps = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_update_domain_nameservers
route53domains_update_domain_nameservers <- function(DomainName, FIAuthKey = NULL, Nameservers) {
  op <- new_operation(
    name = "UpdateDomainNameservers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$update_domain_nameservers_input(DomainName = DomainName, FIAuthKey = FIAuthKey, Nameservers = Nameservers)
  output <- .route53domains$update_domain_nameservers_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_domain_nameservers <- route53domains_update_domain_nameservers

#' This operation adds or updates tags for a specified domain
#'
#' This operation adds or updates tags for a specified domain.
#' 
#' All tag operations are eventually consistent; subsequent operations
#' might not immediately represent all issued operations.
#'
#' @usage
#' route53domains_update_tags_for_domain(DomainName, TagsToUpdate)
#'
#' @param DomainName &#91;required&#93; The domain for which you want to add or update tags.
#' @param TagsToUpdate A list of the tag keys and values that you want to add or update. If you
#' specify a key that already exists, the corresponding value will be
#' replaced.
#'
#' @section Request syntax:
#' ```
#' svc$update_tags_for_domain(
#'   DomainName = "string",
#'   TagsToUpdate = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_update_tags_for_domain
route53domains_update_tags_for_domain <- function(DomainName, TagsToUpdate = NULL) {
  op <- new_operation(
    name = "UpdateTagsForDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$update_tags_for_domain_input(DomainName = DomainName, TagsToUpdate = TagsToUpdate)
  output <- .route53domains$update_tags_for_domain_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$update_tags_for_domain <- route53domains_update_tags_for_domain

#' Returns all the domain-related billing records for the current AWS
#' account for a specified period
#'
#' Returns all the domain-related billing records for the current AWS
#' account for a specified period
#'
#' @usage
#' route53domains_view_billing(Start, End, Marker, MaxItems)
#'
#' @param Start The beginning date and time for the time period for which you want a
#' list of billing records. Specify the date and time in Coordinated
#' Universal time (UTC).
#' @param End The end date and time for the time period for which you want a list of
#' billing records. Specify the date and time in Coordinated Universal time
#' (UTC).
#' @param Marker For an initial request for a list of billing records, omit this element.
#' If the number of billing records that are associated with the current
#' AWS account during the specified period is greater than the value that
#' you specified for `MaxItems`, you can use `Marker` to return additional
#' billing records. Get the value of `NextPageMarker` from the previous
#' response, and submit another request that includes the value of
#' `NextPageMarker` in the `Marker` element.
#' 
#' Constraints: The marker must match the value of `NextPageMarker` that
#' was returned in the previous response.
#' @param MaxItems The number of billing records to be returned.
#' 
#' Default: 20
#'
#' @section Request syntax:
#' ```
#' svc$view_billing(
#'   Start = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   End = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Marker = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53domains_view_billing
route53domains_view_billing <- function(Start = NULL, End = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ViewBilling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53domains$view_billing_input(Start = Start, End = End, Marker = Marker, MaxItems = MaxItems)
  output <- .route53domains$view_billing_output()
  config <- get_config()
  svc <- .route53domains$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53domains$operations$view_billing <- route53domains_view_billing
