% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_create_virtual_service}
\alias{appmesh_create_virtual_service}
\title{Creates a virtual service within a service mesh}
\usage{
appmesh_create_virtual_service(clientToken, meshName, spec, tags,
  virtualServiceName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh to create the virtual service in.}

\item{spec}{[required] The virtual service specification to apply.}

\item{tags}{Optional metadata that you can apply to the virtual service to assist
with categorization and organization. Each tag consists of a key and an
optional value, both of which you define. Tag keys can have a maximum
character length of 128 characters, and tag values can have a maximum
length of 256 characters.}

\item{virtualServiceName}{[required] The name to use for the virtual service.}
}
\description{
Creates a virtual service within a service mesh.
}
\details{
A virtual service is an abstraction of a real service that is provided
by a virtual node directly or indirectly by means of a virtual router.
Dependent services call your virtual service by its
\code{virtualServiceName}, and those requests are routed to the virtual node
or virtual router that is specified as the provider for the virtual
service.
}
\section{Request syntax}{
\preformatted{svc$create_virtual_service(
  clientToken = "string",
  meshName = "string",
  spec = list(
    provider = list(
      virtualNode = list(
        virtualNodeName = "string"
      ),
      virtualRouter = list(
        virtualRouterName = "string"
      )
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  virtualServiceName = "string"
)
}
}

\keyword{internal}
