% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_virtual_node}
\alias{appmesh_update_virtual_node}
\title{Updates an existing virtual node in a specified service mesh}
\usage{
appmesh_update_virtual_node(clientToken, meshName, spec,
  virtualNodeName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the virtual node resides in.}

\item{spec}{[required] The new virtual node specification to apply. This overwrites the
existing data.}

\item{virtualNodeName}{[required] The name of the virtual node to update.}
}
\description{
Updates an existing virtual node in a specified service mesh.
}
\section{Request syntax}{
\preformatted{svc$update_virtual_node(
  clientToken = "string",
  meshName = "string",
  spec = list(
    backends = list(
      list(
        virtualService = list(
          virtualServiceName = "string"
        )
      )
    ),
    listeners = list(
      list(
        healthCheck = list(
          healthyThreshold = 123,
          intervalMillis = 123,
          path = "string",
          port = 123,
          protocol = "grpc"|"http"|"http2"|"tcp",
          timeoutMillis = 123,
          unhealthyThreshold = 123
        ),
        portMapping = list(
          port = 123,
          protocol = "grpc"|"http"|"http2"|"tcp"
        )
      )
    ),
    logging = list(
      accessLog = list(
        file = list(
          path = "string"
        )
      )
    ),
    serviceDiscovery = list(
      awsCloudMap = list(
        attributes = list(
          list(
            key = "string",
            value = "string"
          )
        ),
        namespaceName = "string",
        serviceName = "string"
      ),
      dns = list(
        hostname = "string"
      )
    )
  ),
  virtualNodeName = "string"
)
}
}

\keyword{internal}
