% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_update_field_level_encryption_config}
\alias{cloudfront_update_field_level_encryption_config}
\title{Update a field-level encryption configuration}
\usage{
cloudfront_update_field_level_encryption_config(
  FieldLevelEncryptionConfig, Id, IfMatch)
}
\arguments{
\item{FieldLevelEncryptionConfig}{[required] Request to update a field-level encryption configuration.}

\item{Id}{[required] The ID of the configuration you want to update.}

\item{IfMatch}{The value of the \code{ETag} header that you received when retrieving the
configuration identity to update. For example: \code{E2QWRUHAPOMQZL}.}
}
\description{
Update a field-level encryption configuration.
}
\section{Request syntax}{
\preformatted{svc$update_field_level_encryption_config(
  FieldLevelEncryptionConfig = list(
    CallerReference = "string",
    Comment = "string",
    QueryArgProfileConfig = list(
      ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
      QueryArgProfiles = list(
        Quantity = 123,
        Items = list(
          list(
            QueryArg = "string",
            ProfileId = "string"
          )
        )
      )
    ),
    ContentTypeProfileConfig = list(
      ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
      ContentTypeProfiles = list(
        Quantity = 123,
        Items = list(
          list(
            Format = "URLEncoded",
            ProfileId = "string",
            ContentType = "string"
          )
        )
      )
    )
  ),
  Id = "string",
  IfMatch = "string"
)
}
}

\keyword{internal}
