% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_delete_load_balancer}
\alias{elbv2_delete_load_balancer}
\title{Deletes the specified Application Load Balancer or Network Load Balancer
and its attached listeners}
\usage{
elbv2_delete_load_balancer(LoadBalancerArn)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}
}
\description{
Deletes the specified Application Load Balancer or Network Load Balancer
and its attached listeners.
}
\details{
You can\'t delete a load balancer if deletion protection is enabled. If
the load balancer does not exist or has already been deleted, the call
succeeds.

Deleting a load balancer does not affect its registered targets. For
example, your EC2 instances continue to run and are still registered to
their target groups. If you no longer need these EC2 instances, you can
stop or terminate them.
}
\section{Request syntax}{
\preformatted{svc$delete_load_balancer(
  LoadBalancerArn = "string"
)
}
}

\examples{
# This example deletes the specified load balancer.
\donttest{svc$delete_load_balancer(
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my..."
)}

}
\keyword{internal}
