% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_route}
\alias{appmesh_update_route}
\title{Updates an existing route for a specified service mesh and virtual
router}
\usage{
appmesh_update_route(
  clientToken = NULL,
  meshName,
  meshOwner = NULL,
  routeName,
  spec,
  virtualRouterName
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the route resides in.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then it's the ID of the account that shared
the mesh with your account. For more information about mesh sharing, see
\href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{routeName}{[required] The name of the route to update.}

\item{spec}{[required] The new route specification to apply. This overwrites the existing data.}

\item{virtualRouterName}{[required] The name of the virtual router that the route is associated with.}
}
\description{
Updates an existing route for a specified service mesh and virtual router.

See \url{https://paws-r.github.io/docs/appmesh/update_route.html} for full documentation.
}
\keyword{internal}
