% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_create_connection}
\alias{networkmanager_create_connection}
\title{Creates a connection between two devices}
\usage{
networkmanager_create_connection(
  GlobalNetworkId,
  DeviceId,
  ConnectedDeviceId,
  LinkId = NULL,
  ConnectedLinkId = NULL,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{DeviceId}{[required] The ID of the first device in the connection.}

\item{ConnectedDeviceId}{[required] The ID of the second device in the connection.}

\item{LinkId}{The ID of the link for the first device.}

\item{ConnectedLinkId}{The ID of the link for the second device.}

\item{Description}{A description of the connection.

Length Constraints: Maximum length of 256 characters.}

\item{Tags}{The tags to apply to the resource during creation.}
}
\description{
Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.

See \url{https://paws-r.github.io/docs/networkmanager/create_connection.html} for full documentation.
}
\keyword{internal}
