% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_describe_certificate_authority}
\alias{acmpca_describe_certificate_authority}
\title{Lists information about your private certificate authority (CA)}
\usage{
acmpca_describe_certificate_authority(CertificateAuthorityArn)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must be of the form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}
}
\description{
Lists information about your private certificate authority (CA). You
specify the private CA on input by its ARN (Amazon Resource Name). The
output contains the status of your CA. This can be any of the following:
}
\details{
\itemize{
\item \code{CREATING} - ACM PCA is creating your private certificate authority.
\item \code{PENDING_CERTIFICATE} - The certificate is pending. You must use
your on-premises root or subordinate CA to sign your private CA CSR
and then import it into PCA.
\item \code{ACTIVE} - Your private CA is active.
\item \code{DISABLED} - Your private CA has been disabled.
\item \code{EXPIRED} - Your private CA certificate has expired.
\item \code{FAILED} - Your private CA has failed. Your CA can fail because of
problems such a network outage or backend AWS failure or other
errors. A failed CA can never return to the pending state. You must
create a new CA.
\item \code{DELETED} - Your private CA is within the restoration period, after
which it is permanently deleted. The length of time remaining in the
CA's restoration period is also included in this operation's
output.
}
}
\section{Request syntax}{
\preformatted{svc$describe_certificate_authority(
  CertificateAuthorityArn = "string"
)
}
}

\keyword{internal}
