% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_grant}
\alias{kms_create_grant}
\title{Adds a grant to a customer master key (CMK)}
\usage{
kms_create_grant(KeyId, GranteePrincipal, RetiringPrincipal, Operations,
  Constraints, GrantTokens, Name)
}
\arguments{
\item{KeyId}{[required] The unique identifier for the customer master key (CMK) that the grant
applies to.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
specify a CMK in a different AWS account, you must use the key ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{GranteePrincipal}{[required] The principal that is given permission to perform the operations that
the grant permits.

To specify the principal, use the \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Name (ARN)}
of an AWS principal. Valid AWS principals include AWS accounts (root),
IAM users, IAM roles, federated users, and assumed role users. For
examples of the ARN syntax to use for specifying a principal, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam}{AWS Identity and Access Management (IAM)}
in the Example ARNs section of the \emph{AWS General Reference}.}

\item{RetiringPrincipal}{The principal that is given permission to retire the grant by using
RetireGrant operation.

To specify the principal, use the \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Name (ARN)}
of an AWS principal. Valid AWS principals include AWS accounts (root),
IAM users, federated users, and assumed role users. For examples of the
ARN syntax to use for specifying a principal, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam}{AWS Identity and Access Management (IAM)}
in the Example ARNs section of the \emph{AWS General Reference}.}

\item{Operations}{[required] A list of operations that the grant permits.}

\item{Constraints}{A structure that you can use to allow certain operations in the grant
only when the desired encryption context is present. For more
information about encryption context, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{Name}{A friendly name for identifying the grant. Use this value to prevent
unintended creation of duplicate grants when retrying this request.

When this value is absent, all \code{CreateGrant} requests result in a new
grant with a unique \code{GrantId} even if all the supplied parameters are
identical. This can result in unintended duplicates when you retry the
\code{CreateGrant} request.

When this value is present, you can retry a \code{CreateGrant} request with
identical parameters; if the grant already exists, the original
\code{GrantId} is returned without creating a new grant. Note that the
returned grant token is unique with every \code{CreateGrant} request, even
when a duplicate \code{GrantId} is returned. All grant tokens obtained in
this way can be used interchangeably.}
}
\description{
Adds a grant to a customer master key (CMK). The grant specifies who can
use the CMK and under what conditions. When setting permissions, grants
are an alternative to key policies.
}
\details{
To perform this operation on a CMK in a different AWS account, specify
the key ARN in the value of the \code{KeyId} parameter. For more information
about grants, see
\href{http://docs.aws.amazon.com/kms/latest/developerguide/grants.html}{Grants}
in the \emph{AWS Key Management Service Developer Guide}.

The result of this operation varies with the key state of the CMK. For
details, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_grant(
  KeyId = "string",
  GranteePrincipal = "string",
  RetiringPrincipal = "string",
  Operations = list(
    "Decrypt"|"Encrypt"|"GenerateDataKey"|"GenerateDataKeyWithoutPlaintext"|"ReEncryptFrom"|"ReEncryptTo"|"CreateGrant"|"RetireGrant"|"DescribeKey"
  ),
  Constraints = list(
    EncryptionContextSubset = list(
      "string"
    ),
    EncryptionContextEquals = list(
      "string"
    )
  ),
  GrantTokens = list(
    "string"
  ),
  Name = "string"
)
}
}

\examples{
# The following example creates a grant that allows the specified IAM role
# to encrypt data with the specified customer master key (CMK).
\donttest{svc$create_grant(
  GranteePrincipal = "arn:aws:iam::111122223333:role/ExampleRole",
  KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  Operations = list(
    "Encrypt",
    "Decrypt"
  )
)}

}
\keyword{internal}
