% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_set_ui_customization}
\alias{cognitoidentityprovider_set_ui_customization}
\title{Sets the UI customization information for a user pool's built-in app UI}
\usage{
cognitoidentityprovider_set_ui_customization(UserPoolId, ClientId, CSS,
  ImageFile)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{ClientId}{The client ID for the client app.}

\item{CSS}{The CSS values in the UI customization.}

\item{ImageFile}{The uploaded logo image for the UI customization.}
}
\description{
Sets the UI customization information for a user pool's built-in app UI.

You can specify app UI customization settings for a single client (with
a specific \code{clientId}) or for all clients (by setting the \code{clientId} to
\code{ALL}). If you specify \code{ALL}, the default configuration will be used for
every client that has no UI customization set previously. If you specify
UI customization settings for a particular client, it will no longer
fall back to the \code{ALL} configuration.

To use this API, your user pool must have a domain associated with it.
Otherwise, there is no place to host the app's pages, and the service
will throw an error.
}
\section{Request syntax}{
\preformatted{svc$set_ui_customization(
  UserPoolId = "string",
  ClientId = "string",
  CSS = "string",
  ImageFile = raw
)
}
}

\keyword{internal}
