% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_disable_key_rotation}
\alias{kms_disable_key_rotation}
\title{Disables automatic rotation of the key material for the specified
symmetric customer master key (CMK)}
\usage{
kms_disable_key_rotation(KeyId)
}
\arguments{
\item{KeyId}{[required] Identifies a symmetric customer master key (CMK). You cannot enable or
disable automatic rotation of \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks}{asymmetric CMKs},
CMKs with \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{imported key material},
or CMKs in a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}
}
\description{
Disables \href{https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html}{automatic rotation of the key material}
for the specified symmetric customer master key (CMK).

You cannot enable automatic rotation of asymmetric CMKs, CMKs with
imported key material, or CMKs in a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:DisableKeyRotation}
(key policy)

\strong{Related operations:}
\itemize{
\item EnableKeyRotation
\item GetKeyRotationStatus
}
}
\section{Request syntax}{
\preformatted{svc$disable_key_rotation(
  KeyId = "string"
)
}
}

\examples{
\dontrun{
# The following example disables automatic annual rotation of the key
# material for the specified CMK.
svc$disable_key_rotation(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
