% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_regex_match_set}
\alias{waf_delete_regex_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
waf_delete_regex_match_set(RegexMatchSetId, ChangeToken)
}
\arguments{
\item{RegexMatchSetId}{[required] The \code{RegexMatchSetId} of the RegexMatchSet that you want to delete.
\code{RegexMatchSetId} is returned by
\code{\link[=waf_create_regex_match_set]{create_regex_match_set}} and by
\code{\link[=waf_list_regex_match_sets]{list_regex_match_sets}}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=waf_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a RegexMatchSet. You can't delete a \code{RegexMatchSet}
if it's still used in any \code{Rules} or if it still includes any
\code{RegexMatchTuples} objects (any filters).

If you just want to remove a \code{RegexMatchSet} from a \code{Rule}, use
\code{\link[=waf_update_rule]{update_rule}}.

To permanently delete a \code{RegexMatchSet}, perform the following steps:
\enumerate{
\item Update the \code{RegexMatchSet} to remove filters, if any. For more
information, see
\code{\link[=waf_update_regex_match_set]{update_regex_match_set}}.
\item Use \code{\link[=waf_get_change_token]{get_change_token}} to get the change
token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=waf_delete_regex_match_set]{delete_regex_match_set}} request.
\item Submit a \code{\link[=waf_delete_regex_match_set]{delete_regex_match_set}}
request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_regex_match_set(
  RegexMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
