% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_get_certificate}
\alias{acm_get_certificate}
\title{Retrieves an Amazon-issued certificate and its certificate chain}
\usage{
acm_get_certificate(CertificateArn)
}
\arguments{
\item{CertificateArn}{[required] String that contains a certificate ARN in the following format:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Certificate = "string",
  CertificateChain = "string"
)
}
}
\description{
Retrieves an Amazon-issued certificate and its certificate chain. The
chain consists of the certificate of the issuing CA and the intermediate
certificates of any other subordinate CAs. All of the certificates are
base64 encoded. You can use
\href{https://wiki.openssl.org/index.php/Command_Line_Utilities}{OpenSSL} to
decode the certificates and inspect individual fields.
}
\section{Request syntax}{
\preformatted{svc$get_certificate(
  CertificateArn = "string"
)
}
}

\keyword{internal}
