% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_create_resource_group}
\alias{inspector_create_resource_group}
\title{Creates a resource group using the specified set of tags (key and value
pairs) that are used to select the EC2 instances to be included in an
Amazon Inspector assessment target}
\usage{
inspector_create_resource_group(resourceGroupTags)
}
\arguments{
\item{resourceGroupTags}{[required] A collection of keys and an array of possible values,
'[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.

For
example,'[{"key":"Name","values":["TestEC2Instance"]}]'.}
}
\description{
Creates a resource group using the specified set of tags (key and value
pairs) that are used to select the EC2 instances to be included in an
Amazon Inspector assessment target. The created resource group is then
used to create an Amazon Inspector assessment target. For more
information, see CreateAssessmentTarget.
}
\section{Request syntax}{
\preformatted{svc$create_resource_group(
  resourceGroupTags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
# Creates a resource group using the specified set of tags (key and value
# pairs) that are used to select the EC2 instances to be included in an
# Amazon Inspector assessment target. The created resource group is then
# used to create an Amazon Inspector assessment target.
\donttest{svc$create_resource_group(
  resourceGroupTags = list(
    list(
      key = "Name",
      value = "example"
    )
  )
)}

}
\keyword{internal}
