# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Cognito Identity Provider
#'
#' @description
#' Using the Amazon Cognito User Pools API, you can create a user pool to
#' manage directories and users. You can authenticate a user to obtain
#' tokens related to user identity and access policies.
#' 
#' This API reference provides information about user pools in Amazon
#' Cognito User Pools.
#' 
#' For more information, see the Amazon Cognito Documentation.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cognitoidentityprovider(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- cognitoidentityprovider()
#' svc$add_custom_attributes(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cognitoidentityprovider_add_custom_attributes]{add_custom_attributes} \tab Adds additional user attributes to the user pool schema \cr
#'  \link[=cognitoidentityprovider_admin_add_user_to_group]{admin_add_user_to_group} \tab Adds the specified user to the specified group \cr
#'  \link[=cognitoidentityprovider_admin_confirm_sign_up]{admin_confirm_sign_up} \tab Confirms user registration as an admin without using a confirmation code \cr
#'  \link[=cognitoidentityprovider_admin_create_user]{admin_create_user} \tab Creates a new user in the specified user pool \cr
#'  \link[=cognitoidentityprovider_admin_delete_user]{admin_delete_user} \tab Deletes a user as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_delete_user_attributes]{admin_delete_user_attributes} \tab Deletes the user attributes in a user pool as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_disable_provider_for_user]{admin_disable_provider_for_user} \tab Disables the user from signing in with the specified external (SAML or social) identity provider \cr
#'  \link[=cognitoidentityprovider_admin_disable_user]{admin_disable_user} \tab Disables the specified user as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_enable_user]{admin_enable_user} \tab Enables the specified user as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_forget_device]{admin_forget_device} \tab Forgets the device, as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_get_device]{admin_get_device} \tab Gets the device, as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_get_user]{admin_get_user} \tab Gets the specified user by user name in a user pool as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_initiate_auth]{admin_initiate_auth} \tab Initiates the authentication flow, as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_link_provider_for_user]{admin_link_provider_for_user} \tab Links an existing user account in a user pool (DestinationUser) to an identity from an external identity provider (SourceUser) based on a specified attribute name and value from the external identity provider\cr
#'  \link[=cognitoidentityprovider_admin_list_devices]{admin_list_devices} \tab Lists devices, as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_list_groups_for_user]{admin_list_groups_for_user} \tab Lists the groups that the user belongs to \cr
#'  \link[=cognitoidentityprovider_admin_list_user_auth_events]{admin_list_user_auth_events} \tab Lists a history of user activity and any risks detected as part of Amazon Cognito advanced security \cr
#'  \link[=cognitoidentityprovider_admin_remove_user_from_group]{admin_remove_user_from_group} \tab Removes the specified user from the specified group \cr
#'  \link[=cognitoidentityprovider_admin_reset_user_password]{admin_reset_user_password} \tab Resets the specified user's password in a user pool as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_respond_to_auth_challenge]{admin_respond_to_auth_challenge} \tab Responds to an authentication challenge, as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_set_user_mfa_preference]{admin_set_user_mfa_preference} \tab Sets the user's multi-factor authentication (MFA) preference \cr
#'  \link[=cognitoidentityprovider_admin_set_user_password]{admin_set_user_password} \tab Admin set user password \cr
#'  \link[=cognitoidentityprovider_admin_set_user_settings]{admin_set_user_settings} \tab Sets all the user settings for a specified user name \cr
#'  \link[=cognitoidentityprovider_admin_update_auth_event_feedback]{admin_update_auth_event_feedback} \tab Provides feedback for an authentication event as to whether it was from a valid user \cr
#'  \link[=cognitoidentityprovider_admin_update_device_status]{admin_update_device_status} \tab Updates the device status as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_update_user_attributes]{admin_update_user_attributes} \tab Updates the specified user's attributes, including developer attributes, as an administrator \cr
#'  \link[=cognitoidentityprovider_admin_user_global_sign_out]{admin_user_global_sign_out} \tab Signs out users from all devices, as an administrator \cr
#'  \link[=cognitoidentityprovider_associate_software_token]{associate_software_token} \tab Returns a unique generated shared secret key code for the user account \cr
#'  \link[=cognitoidentityprovider_change_password]{change_password} \tab Changes the password for a specified user in a user pool \cr
#'  \link[=cognitoidentityprovider_confirm_device]{confirm_device} \tab Confirms tracking of the device \cr
#'  \link[=cognitoidentityprovider_confirm_forgot_password]{confirm_forgot_password} \tab Allows a user to enter a confirmation code to reset a forgotten password \cr
#'  \link[=cognitoidentityprovider_confirm_sign_up]{confirm_sign_up} \tab Confirms registration of a user and handles the existing alias from a previous user \cr
#'  \link[=cognitoidentityprovider_create_group]{create_group} \tab Creates a new group in the specified user pool \cr
#'  \link[=cognitoidentityprovider_create_identity_provider]{create_identity_provider} \tab Creates an identity provider for a user pool \cr
#'  \link[=cognitoidentityprovider_create_resource_server]{create_resource_server} \tab Creates a new OAuth2 \cr
#'  \link[=cognitoidentityprovider_create_user_import_job]{create_user_import_job} \tab Creates the user import job \cr
#'  \link[=cognitoidentityprovider_create_user_pool]{create_user_pool} \tab Creates a new Amazon Cognito user pool and sets the password policy for the pool \cr
#'  \link[=cognitoidentityprovider_create_user_pool_client]{create_user_pool_client} \tab Creates the user pool client \cr
#'  \link[=cognitoidentityprovider_create_user_pool_domain]{create_user_pool_domain} \tab Creates a new domain for a user pool \cr
#'  \link[=cognitoidentityprovider_delete_group]{delete_group} \tab Deletes a group \cr
#'  \link[=cognitoidentityprovider_delete_identity_provider]{delete_identity_provider} \tab Deletes an identity provider for a user pool \cr
#'  \link[=cognitoidentityprovider_delete_resource_server]{delete_resource_server} \tab Deletes a resource server \cr
#'  \link[=cognitoidentityprovider_delete_user]{delete_user} \tab Allows a user to delete himself or herself \cr
#'  \link[=cognitoidentityprovider_delete_user_attributes]{delete_user_attributes} \tab Deletes the attributes for a user \cr
#'  \link[=cognitoidentityprovider_delete_user_pool]{delete_user_pool} \tab Deletes the specified Amazon Cognito user pool \cr
#'  \link[=cognitoidentityprovider_delete_user_pool_client]{delete_user_pool_client} \tab Allows the developer to delete the user pool client \cr
#'  \link[=cognitoidentityprovider_delete_user_pool_domain]{delete_user_pool_domain} \tab Deletes a domain for a user pool \cr
#'  \link[=cognitoidentityprovider_describe_identity_provider]{describe_identity_provider} \tab Gets information about a specific identity provider \cr
#'  \link[=cognitoidentityprovider_describe_resource_server]{describe_resource_server} \tab Describes a resource server \cr
#'  \link[=cognitoidentityprovider_describe_risk_configuration]{describe_risk_configuration} \tab Describes the risk configuration \cr
#'  \link[=cognitoidentityprovider_describe_user_import_job]{describe_user_import_job} \tab Describes the user import job \cr
#'  \link[=cognitoidentityprovider_describe_user_pool]{describe_user_pool} \tab Returns the configuration information and metadata of the specified user pool \cr
#'  \link[=cognitoidentityprovider_describe_user_pool_client]{describe_user_pool_client} \tab Client method for returning the configuration information and metadata of the specified user pool app client \cr
#'  \link[=cognitoidentityprovider_describe_user_pool_domain]{describe_user_pool_domain} \tab Gets information about a domain \cr
#'  \link[=cognitoidentityprovider_forget_device]{forget_device} \tab Forgets the specified device \cr
#'  \link[=cognitoidentityprovider_forgot_password]{forgot_password} \tab Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password \cr
#'  \link[=cognitoidentityprovider_get_csv_header]{get_csv_header} \tab Gets the header information for the \cr
#'  \link[=cognitoidentityprovider_get_device]{get_device} \tab Gets the device \cr
#'  \link[=cognitoidentityprovider_get_group]{get_group} \tab Gets a group \cr
#'  \link[=cognitoidentityprovider_get_identity_provider_by_identifier]{get_identity_provider_by_identifier} \tab Gets the specified identity provider \cr
#'  \link[=cognitoidentityprovider_get_signing_certificate]{get_signing_certificate} \tab This method takes a user pool ID, and returns the signing certificate \cr
#'  \link[=cognitoidentityprovider_get_ui_customization]{get_ui_customization} \tab Gets the UI Customization information for a particular app client's app UI, if there is something set \cr
#'  \link[=cognitoidentityprovider_get_user]{get_user} \tab Gets the user attributes and metadata for a user \cr
#'  \link[=cognitoidentityprovider_get_user_attribute_verification_code]{get_user_attribute_verification_code} \tab Gets the user attribute verification code for the specified attribute name \cr
#'  \link[=cognitoidentityprovider_get_user_pool_mfa_config]{get_user_pool_mfa_config} \tab Gets the user pool multi-factor authentication (MFA) configuration \cr
#'  \link[=cognitoidentityprovider_global_sign_out]{global_sign_out} \tab Signs out users from all devices \cr
#'  \link[=cognitoidentityprovider_initiate_auth]{initiate_auth} \tab Initiates the authentication flow \cr
#'  \link[=cognitoidentityprovider_list_devices]{list_devices} \tab Lists the devices \cr
#'  \link[=cognitoidentityprovider_list_groups]{list_groups} \tab Lists the groups associated with a user pool \cr
#'  \link[=cognitoidentityprovider_list_identity_providers]{list_identity_providers} \tab Lists information about all identity providers for a user pool \cr
#'  \link[=cognitoidentityprovider_list_resource_servers]{list_resource_servers} \tab Lists the resource servers for a user pool \cr
#'  \link[=cognitoidentityprovider_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that are assigned to an Amazon Cognito user pool \cr
#'  \link[=cognitoidentityprovider_list_user_import_jobs]{list_user_import_jobs} \tab Lists the user import jobs \cr
#'  \link[=cognitoidentityprovider_list_user_pool_clients]{list_user_pool_clients} \tab Lists the clients that have been created for the specified user pool \cr
#'  \link[=cognitoidentityprovider_list_user_pools]{list_user_pools} \tab Lists the user pools associated with an AWS account \cr
#'  \link[=cognitoidentityprovider_list_users]{list_users} \tab Lists the users in the Amazon Cognito user pool \cr
#'  \link[=cognitoidentityprovider_list_users_in_group]{list_users_in_group} \tab Lists the users in the specified group \cr
#'  \link[=cognitoidentityprovider_resend_confirmation_code]{resend_confirmation_code} \tab Resends the confirmation (for confirmation of registration) to a specific user in the user pool \cr
#'  \link[=cognitoidentityprovider_respond_to_auth_challenge]{respond_to_auth_challenge} \tab Responds to the authentication challenge \cr
#'  \link[=cognitoidentityprovider_set_risk_configuration]{set_risk_configuration} \tab Configures actions on detected risks \cr
#'  \link[=cognitoidentityprovider_set_ui_customization]{set_ui_customization} \tab Sets the UI customization information for a user pool's built-in app UI \cr
#'  \link[=cognitoidentityprovider_set_user_mfa_preference]{set_user_mfa_preference} \tab Set the user's multi-factor authentication (MFA) method preference \cr
#'  \link[=cognitoidentityprovider_set_user_pool_mfa_config]{set_user_pool_mfa_config} \tab Set the user pool MFA configuration \cr
#'  \link[=cognitoidentityprovider_set_user_settings]{set_user_settings} \tab Sets the user settings like multi-factor authentication (MFA) \cr
#'  \link[=cognitoidentityprovider_sign_up]{sign_up} \tab Registers the user in the specified user pool and creates a user name, password, and user attributes \cr
#'  \link[=cognitoidentityprovider_start_user_import_job]{start_user_import_job} \tab Starts the user import \cr
#'  \link[=cognitoidentityprovider_stop_user_import_job]{stop_user_import_job} \tab Stops the user import job \cr
#'  \link[=cognitoidentityprovider_tag_resource]{tag_resource} \tab Assigns a set of tags to an Amazon Cognito user pool \cr
#'  \link[=cognitoidentityprovider_untag_resource]{untag_resource} \tab Removes the specified tags from an Amazon Cognito user pool \cr
#'  \link[=cognitoidentityprovider_update_auth_event_feedback]{update_auth_event_feedback} \tab Provides the feedback for an authentication event whether it was from a valid user or not \cr
#'  \link[=cognitoidentityprovider_update_device_status]{update_device_status} \tab Updates the device status \cr
#'  \link[=cognitoidentityprovider_update_group]{update_group} \tab Updates the specified group with the specified attributes \cr
#'  \link[=cognitoidentityprovider_update_identity_provider]{update_identity_provider} \tab Updates identity provider information for a user pool \cr
#'  \link[=cognitoidentityprovider_update_resource_server]{update_resource_server} \tab Updates the name and scopes of resource server \cr
#'  \link[=cognitoidentityprovider_update_user_attributes]{update_user_attributes} \tab Allows a user to update a specific attribute (one at a time) \cr
#'  \link[=cognitoidentityprovider_update_user_pool]{update_user_pool} \tab Updates the specified user pool with the specified attributes \cr
#'  \link[=cognitoidentityprovider_update_user_pool_client]{update_user_pool_client} \tab Updates the specified user pool app client with the specified attributes \cr
#'  \link[=cognitoidentityprovider_update_user_pool_domain]{update_user_pool_domain} \tab Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool \cr
#'  \link[=cognitoidentityprovider_verify_software_token]{verify_software_token} \tab Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified" if successful \cr
#'  \link[=cognitoidentityprovider_verify_user_attribute]{verify_user_attribute} \tab Verifies the specified user attributes in the user pool 
#' }
#'
#' @rdname cognitoidentityprovider
#' @export
cognitoidentityprovider <- function(config = list()) {
  svc <- .cognitoidentityprovider$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cognitoidentityprovider <- list()

.cognitoidentityprovider$operations <- list()

.cognitoidentityprovider$metadata <- list(
  service_name = "cognito-idp",
  endpoints = list("*" = list(endpoint = "cognito-idp.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cognito-idp.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Cognito Identity Provider",
  api_version = "2016-04-18",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSCognitoIdentityProviderService"
)

.cognitoidentityprovider$handlers <- new_handlers("jsonrpc", "v4")

.cognitoidentityprovider$service <- function(config = list()) {
  new_service(.cognitoidentityprovider$metadata, .cognitoidentityprovider$handlers, config)
}
