% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_restore_secret}
\alias{secretsmanager_restore_secret}
\title{Cancels the scheduled deletion of a secret by removing the DeletedDate
time stamp}
\usage{
secretsmanager_restore_secret(SecretId)
}
\arguments{
\item{SecretId}{[required] Specifies the secret that you want to restore from a previously
scheduled deletion. You can specify either the Amazon Resource Name
(ARN) or the friendly name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}
}
\description{
Cancels the scheduled deletion of a secret by removing the \code{DeletedDate}
time stamp. This makes the secret accessible to query once again.
}
\details{
\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:RestoreSecret
}

\strong{Related operations}
\itemize{
\item To delete a secret, use DeleteSecret.
}
}
\section{Request syntax}{
\preformatted{svc$restore_secret(
  SecretId = "string"
)
}
}

\examples{
# The following example shows how to restore a secret that you previously
# scheduled for deletion.
\dontrun{svc$restore_secret(
  SecretId = "MyTestDatabaseSecret"
)}

}
\keyword{internal}
