% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_ip_set}
\alias{wafregional_create_ip_set}
\title{Creates an IPSet, which you use to specify which web requests that you
want to allow or block based on the IP addresses that the requests
originate from}
\usage{
wafregional_create_ip_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the IPSet. You can\'t change \code{Name}
after you create the \code{IPSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Creates an IPSet, which you use to specify which web requests that you
want to allow or block based on the IP addresses that the requests
originate from. For example, if you\'re receiving a lot of requests from
one or more individual IP addresses or one or more ranges of IP
addresses and you want to block the requests, you can create an \code{IPSet}
that contains those IP addresses and then configure AWS WAF to block the
requests.
}
\details{
To create and configure an \code{IPSet}, perform the following steps:
\enumerate{
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateIPSet} request.
\item Submit a \code{CreateIPSet} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateIPSet request.
\item Submit an \code{UpdateIPSet} request to specify the IP addresses that you
want AWS WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_ip_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\examples{
# The following example creates an IP match set named MyIPSetFriendlyName.
\dontrun{svc$create_ip_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MyIPSetFriendlyName"
)}

}
\keyword{internal}
