% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_batch_import_findings}
\alias{securityhub_batch_import_findings}
\title{Imports security findings generated from an integrated third-party
product into Security Hub}
\usage{
securityhub_batch_import_findings(Findings)
}
\arguments{
\item{Findings}{[required] A list of findings to import. To successfully import a finding, it must
follow the \href{https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html}{AWS Security Finding Format}.
Maximum of 100 findings per request.}
}
\description{
Imports security findings generated from an integrated third-party
product into Security Hub. This action is requested by the integrated
product to import its findings into Security Hub.
}
\details{
The maximum allowed size for a finding is 240 Kb. An error is returned
for any finding larger than 240 Kb.

After a finding is created, \code{BatchImportFindings} cannot be used to
update the following finding fields and objects, which Security Hub
customers use to manage their investigation workflow.
\itemize{
\item \code{Confidence}
\item \code{Criticality}
\item \code{Note}
\item \code{RelatedFindings}
\item \code{Severity}
\item \code{Types}
\item \code{UserDefinedFields}
\item \code{VerificationState}
\item \code{Workflow}
}
}
\section{Request syntax}{
\preformatted{svc$batch_import_findings(
  Findings = list(
    list(
      SchemaVersion = "string",
      Id = "string",
      ProductArn = "string",
      GeneratorId = "string",
      AwsAccountId = "string",
      Types = list(
        "string"
      ),
      FirstObservedAt = "string",
      LastObservedAt = "string",
      CreatedAt = "string",
      UpdatedAt = "string",
      Severity = list(
        Product = 123.0,
        Label = "INFORMATIONAL"|"LOW"|"MEDIUM"|"HIGH"|"CRITICAL",
        Normalized = 123,
        Original = "string"
      ),
      Confidence = 123,
      Criticality = 123,
      Title = "string",
      Description = "string",
      Remediation = list(
        Recommendation = list(
          Text = "string",
          Url = "string"
        )
      ),
      SourceUrl = "string",
      ProductFields = list(
        "string"
      ),
      UserDefinedFields = list(
        "string"
      ),
      Malware = list(
        list(
          Name = "string",
          Type = "ADWARE"|"BLENDED_THREAT"|"BOTNET_AGENT"|"COIN_MINER"|"EXPLOIT_KIT"|"KEYLOGGER"|"MACRO"|"POTENTIALLY_UNWANTED"|"SPYWARE"|"RANSOMWARE"|"REMOTE_ACCESS"|"ROOTKIT"|"TROJAN"|"VIRUS"|"WORM",
          Path = "string",
          State = "OBSERVED"|"REMOVAL_FAILED"|"REMOVED"
        )
      ),
      Network = list(
        Direction = "IN"|"OUT",
        Protocol = "string",
        OpenPortRange = list(
          Begin = 123,
          End = 123
        ),
        SourceIpV4 = "string",
        SourceIpV6 = "string",
        SourcePort = 123,
        SourceDomain = "string",
        SourceMac = "string",
        DestinationIpV4 = "string",
        DestinationIpV6 = "string",
        DestinationPort = 123,
        DestinationDomain = "string"
      ),
      NetworkPath = list(
        list(
          ComponentId = "string",
          ComponentType = "string",
          Egress = list(
            Protocol = "string",
            Destination = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            ),
            Source = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            )
          ),
          Ingress = list(
            Protocol = "string",
            Destination = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            ),
            Source = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            )
          )
        )
      ),
      Process = list(
        Name = "string",
        Path = "string",
        Pid = 123,
        ParentPid = 123,
        LaunchedAt = "string",
        TerminatedAt = "string"
      ),
      ThreatIntelIndicators = list(
        list(
          Type = "DOMAIN"|"EMAIL_ADDRESS"|"HASH_MD5"|"HASH_SHA1"|"HASH_SHA256"|"HASH_SHA512"|"IPV4_ADDRESS"|"IPV6_ADDRESS"|"MUTEX"|"PROCESS"|"URL",
          Value = "string",
          Category = "BACKDOOR"|"CARD_STEALER"|"COMMAND_AND_CONTROL"|"DROP_SITE"|"EXPLOIT_SITE"|"KEYLOGGER",
          LastObservedAt = "string",
          Source = "string",
          SourceUrl = "string"
        )
      ),
      Resources = list(
        list(
          Type = "string",
          Id = "string",
          Partition = "aws"|"aws-cn"|"aws-us-gov",
          Region = "string",
          Tags = list(
            "string"
          ),
          Details = list(
            AwsAutoScalingAutoScalingGroup = list(
              LaunchConfigurationName = "string",
              LoadBalancerNames = list(
                "string"
              ),
              HealthCheckType = "string",
              HealthCheckGracePeriod = 123,
              CreatedTime = "string"
            ),
            AwsCodeBuildProject = list(
              EncryptionKey = "string",
              Environment = list(
                Certificate = "string",
                ImagePullCredentialsType = "string",
                RegistryCredential = list(
                  Credential = "string",
                  CredentialProvider = "string"
                ),
                Type = "string"
              ),
              Name = "string",
              Source = list(
                Type = "string",
                Location = "string",
                GitCloneDepth = 123,
                InsecureSsl = TRUE|FALSE
              ),
              ServiceRole = "string",
              VpcConfig = list(
                VpcId = "string",
                Subnets = list(
                  "string"
                ),
                SecurityGroupIds = list(
                  "string"
                )
              )
            ),
            AwsCloudFrontDistribution = list(
              DomainName = "string",
              ETag = "string",
              LastModifiedTime = "string",
              Logging = list(
                Bucket = "string",
                Enabled = TRUE|FALSE,
                IncludeCookies = TRUE|FALSE,
                Prefix = "string"
              ),
              Origins = list(
                Items = list(
                  list(
                    DomainName = "string",
                    Id = "string",
                    OriginPath = "string"
                  )
                )
              ),
              Status = "string",
              WebAclId = "string"
            ),
            AwsEc2Instance = list(
              Type = "string",
              ImageId = "string",
              IpV4Addresses = list(
                "string"
              ),
              IpV6Addresses = list(
                "string"
              ),
              KeyName = "string",
              IamInstanceProfileArn = "string",
              VpcId = "string",
              SubnetId = "string",
              LaunchedAt = "string"
            ),
            AwsEc2NetworkInterface = list(
              Attachment = list(
                AttachTime = "string",
                AttachmentId = "string",
                DeleteOnTermination = TRUE|FALSE,
                DeviceIndex = 123,
                InstanceId = "string",
                InstanceOwnerId = "string",
                Status = "string"
              ),
              NetworkInterfaceId = "string",
              SecurityGroups = list(
                list(
                  GroupName = "string",
                  GroupId = "string"
                )
              ),
              SourceDestCheck = TRUE|FALSE
            ),
            AwsEc2SecurityGroup = list(
              GroupName = "string",
              GroupId = "string",
              OwnerId = "string",
              VpcId = "string",
              IpPermissions = list(
                list(
                  IpProtocol = "string",
                  FromPort = 123,
                  ToPort = 123,
                  UserIdGroupPairs = list(
                    list(
                      GroupId = "string",
                      GroupName = "string",
                      PeeringStatus = "string",
                      UserId = "string",
                      VpcId = "string",
                      VpcPeeringConnectionId = "string"
                    )
                  ),
                  IpRanges = list(
                    list(
                      CidrIp = "string"
                    )
                  ),
                  Ipv6Ranges = list(
                    list(
                      CidrIpv6 = "string"
                    )
                  ),
                  PrefixListIds = list(
                    list(
                      PrefixListId = "string"
                    )
                  )
                )
              ),
              IpPermissionsEgress = list(
                list(
                  IpProtocol = "string",
                  FromPort = 123,
                  ToPort = 123,
                  UserIdGroupPairs = list(
                    list(
                      GroupId = "string",
                      GroupName = "string",
                      PeeringStatus = "string",
                      UserId = "string",
                      VpcId = "string",
                      VpcPeeringConnectionId = "string"
                    )
                  ),
                  IpRanges = list(
                    list(
                      CidrIp = "string"
                    )
                  ),
                  Ipv6Ranges = list(
                    list(
                      CidrIpv6 = "string"
                    )
                  ),
                  PrefixListIds = list(
                    list(
                      PrefixListId = "string"
                    )
                  )
                )
              )
            ),
            AwsEc2Volume = list(
              CreateTime = "string",
              Encrypted = TRUE|FALSE,
              Size = 123,
              SnapshotId = "string",
              Status = "string",
              KmsKeyId = "string",
              Attachments = list(
                list(
                  AttachTime = "string",
                  DeleteOnTermination = TRUE|FALSE,
                  InstanceId = "string",
                  Status = "string"
                )
              )
            ),
            AwsEc2Vpc = list(
              CidrBlockAssociationSet = list(
                list(
                  AssociationId = "string",
                  CidrBlock = "string",
                  CidrBlockState = "string"
                )
              ),
              Ipv6CidrBlockAssociationSet = list(
                list(
                  AssociationId = "string",
                  Ipv6CidrBlock = "string",
                  CidrBlockState = "string"
                )
              ),
              DhcpOptionsId = "string",
              State = "string"
            ),
            AwsElbv2LoadBalancer = list(
              AvailabilityZones = list(
                list(
                  ZoneName = "string",
                  SubnetId = "string"
                )
              ),
              CanonicalHostedZoneId = "string",
              CreatedTime = "string",
              DNSName = "string",
              IpAddressType = "string",
              Scheme = "string",
              SecurityGroups = list(
                "string"
              ),
              State = list(
                Code = "string",
                Reason = "string"
              ),
              Type = "string",
              VpcId = "string"
            ),
            AwsElasticsearchDomain = list(
              AccessPolicies = "string",
              DomainEndpointOptions = list(
                EnforceHTTPS = TRUE|FALSE,
                TLSSecurityPolicy = "string"
              ),
              DomainId = "string",
              DomainName = "string",
              Endpoint = "string",
              Endpoints = list(
                "string"
              ),
              ElasticsearchVersion = "string",
              EncryptionAtRestOptions = list(
                Enabled = TRUE|FALSE,
                KmsKeyId = "string"
              ),
              NodeToNodeEncryptionOptions = list(
                Enabled = TRUE|FALSE
              ),
              VPCOptions = list(
                AvailabilityZones = list(
                  "string"
                ),
                SecurityGroupIds = list(
                  "string"
                ),
                SubnetIds = list(
                  "string"
                ),
                VPCId = "string"
              )
            ),
            AwsS3Bucket = list(
              OwnerId = "string",
              OwnerName = "string",
              CreatedAt = "string",
              ServerSideEncryptionConfiguration = list(
                Rules = list(
                  list(
                    ApplyServerSideEncryptionByDefault = list(
                      SSEAlgorithm = "string",
                      KMSMasterKeyID = "string"
                    )
                  )
                )
              )
            ),
            AwsS3Object = list(
              LastModified = "string",
              ETag = "string",
              VersionId = "string",
              ContentType = "string",
              ServerSideEncryption = "string",
              SSEKMSKeyId = "string"
            ),
            AwsIamAccessKey = list(
              UserName = "string",
              Status = "Active"|"Inactive",
              CreatedAt = "string",
              PrincipalId = "string",
              PrincipalType = "string",
              PrincipalName = "string"
            ),
            AwsIamRole = list(
              AssumeRolePolicyDocument = "string",
              CreateDate = "string",
              RoleId = "string",
              RoleName = "string",
              MaxSessionDuration = 123,
              Path = "string"
            ),
            AwsKmsKey = list(
              AWSAccountId = "string",
              CreationDate = 123.0,
              KeyId = "string",
              KeyManager = "string",
              KeyState = "string",
              Origin = "string"
            ),
            AwsLambdaFunction = list(
              Code = list(
                S3Bucket = "string",
                S3Key = "string",
                S3ObjectVersion = "string",
                ZipFile = "string"
              ),
              CodeSha256 = "string",
              DeadLetterConfig = list(
                TargetArn = "string"
              ),
              Environment = list(
                Variables = list(
                  "string"
                ),
                Error = list(
                  ErrorCode = "string",
                  Message = "string"
                )
              ),
              FunctionName = "string",
              Handler = "string",
              KmsKeyArn = "string",
              LastModified = "string",
              Layers = list(
                list(
                  Arn = "string",
                  CodeSize = 123
                )
              ),
              MasterArn = "string",
              MemorySize = 123,
              RevisionId = "string",
              Role = "string",
              Runtime = "string",
              Timeout = 123,
              TracingConfig = list(
                Mode = "string"
              ),
              VpcConfig = list(
                SecurityGroupIds = list(
                  "string"
                ),
                SubnetIds = list(
                  "string"
                ),
                VpcId = "string"
              ),
              Version = "string"
            ),
            AwsLambdaLayerVersion = list(
              Version = 123,
              CompatibleRuntimes = list(
                "string"
              ),
              CreatedDate = "string"
            ),
            AwsRdsDbInstance = list(
              AssociatedRoles = list(
                list(
                  RoleArn = "string",
                  FeatureName = "string",
                  Status = "string"
                )
              ),
              CACertificateIdentifier = "string",
              DBClusterIdentifier = "string",
              DBInstanceIdentifier = "string",
              DBInstanceClass = "string",
              DbInstancePort = 123,
              DbiResourceId = "string",
              DBName = "string",
              DeletionProtection = TRUE|FALSE,
              Endpoint = list(
                Address = "string",
                Port = 123,
                HostedZoneId = "string"
              ),
              Engine = "string",
              EngineVersion = "string",
              IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
              InstanceCreateTime = "string",
              KmsKeyId = "string",
              PubliclyAccessible = TRUE|FALSE,
              StorageEncrypted = TRUE|FALSE,
              TdeCredentialArn = "string",
              VpcSecurityGroups = list(
                list(
                  VpcSecurityGroupId = "string",
                  Status = "string"
                )
              )
            ),
            AwsSnsTopic = list(
              KmsMasterKeyId = "string",
              Subscription = list(
                list(
                  Endpoint = "string",
                  Protocol = "string"
                )
              ),
              TopicName = "string",
              Owner = "string"
            ),
            AwsSqsQueue = list(
              KmsDataKeyReusePeriodSeconds = 123,
              KmsMasterKeyId = "string",
              QueueName = "string",
              DeadLetterTargetArn = "string"
            ),
            AwsWafWebAcl = list(
              Name = "string",
              DefaultAction = "string",
              Rules = list(
                list(
                  Action = list(
                    Type = "string"
                  ),
                  ExcludedRules = list(
                    list(
                      RuleId = "string"
                    )
                  ),
                  OverrideAction = list(
                    Type = "string"
                  ),
                  Priority = 123,
                  RuleId = "string",
                  Type = "string"
                )
              ),
              WebAclId = "string"
            ),
            Container = list(
              Name = "string",
              ImageId = "string",
              ImageName = "string",
              LaunchedAt = "string"
            ),
            Other = list(
              "string"
            )
          )
        )
      ),
      Compliance = list(
        Status = "PASSED"|"WARNING"|"FAILED"|"NOT_AVAILABLE",
        RelatedRequirements = list(
          "string"
        ),
        StatusReasons = list(
          list(
            ReasonCode = "string",
            Description = "string"
          )
        )
      ),
      VerificationState = "UNKNOWN"|"TRUE_POSITIVE"|"FALSE_POSITIVE"|"BENIGN_POSITIVE",
      WorkflowState = "NEW"|"ASSIGNED"|"IN_PROGRESS"|"DEFERRED"|"RESOLVED",
      Workflow = list(
        Status = "NEW"|"NOTIFIED"|"RESOLVED"|"SUPPRESSED"
      ),
      RecordState = "ACTIVE"|"ARCHIVED",
      RelatedFindings = list(
        list(
          ProductArn = "string",
          Id = "string"
        )
      ),
      Note = list(
        Text = "string",
        UpdatedBy = "string",
        UpdatedAt = "string"
      ),
      Vulnerabilities = list(
        list(
          Id = "string",
          VulnerablePackages = list(
            list(
              Name = "string",
              Version = "string",
              Epoch = "string",
              Release = "string",
              Architecture = "string"
            )
          ),
          Cvss = list(
            list(
              Version = "string",
              BaseScore = 123.0,
              BaseVector = "string"
            )
          ),
          RelatedVulnerabilities = list(
            "string"
          ),
          Vendor = list(
            Name = "string",
            Url = "string",
            VendorSeverity = "string",
            VendorCreatedAt = "string",
            VendorUpdatedAt = "string"
          ),
          ReferenceUrls = list(
            "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
