% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_list_tags_for_certificate}
\alias{acm_list_tags_for_certificate}
\title{Lists the tags that have been applied to the ACM certificate}
\usage{
acm_list_tags_for_certificate(CertificateArn)
}
\arguments{
\item{CertificateArn}{[required] String that contains the ARN of the ACM certificate for which you want
to list the tags. This must have the following form:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}.}
}
\description{
Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the \code{\link[=acm_add_tags_to_certificate]{add_tags_to_certificate}} action. To delete a tag, use the \code{\link[=acm_remove_tags_from_certificate]{remove_tags_from_certificate}} action.

See \url{https://paws-r.github.io/docs/acm/list_tags_for_certificate.html} for full documentation.
}
\keyword{internal}
