% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_service_last_accessed_details_with_entities}
\alias{iam_get_service_last_accessed_details_with_entities}
\title{After you generate a group or policy report using the
GenerateServiceLastAccessedDetails operation, you can use the JobId
parameter in GetServiceLastAccessedDetailsWithEntities}
\usage{
iam_get_service_last_accessed_details_with_entities(
  JobId,
  ServiceNamespace,
  MaxItems = NULL,
  Marker = NULL
)
}
\arguments{
\item{JobId}{[required] The ID of the request generated by the
\code{\link[=iam_generate_service_last_accessed_details]{generate_service_last_accessed_details}}
operation.}

\item{ServiceNamespace}{[required] The service namespace for an Amazon Web Services service. Provide the
service namespace to learn when the IAM entity last attempted to access
the specified service.

To learn the service namespace for a service, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html}{Actions, resources, and condition keys for Amazon Web Services services}
in the \emph{IAM User Guide}. Choose the name of the service to view details
for that service. In the first paragraph, find the service prefix. For
example, \verb{(service prefix: a4b)}. For more information about service
namespaces, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces}{Amazon Web Services service namespaces}
in the \emph{Amazon Web Services General Reference}.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\description{
After you generate a group or policy report using the \code{\link[=iam_generate_service_last_accessed_details]{generate_service_last_accessed_details}} operation, you can use the \code{JobId} parameter in \code{\link[=iam_get_service_last_accessed_details_with_entities]{get_service_last_accessed_details_with_entities}}. This operation retrieves the status of your report job and a list of entities that could have used group or policy permissions to access the specified service.

See \url{https://paws-r.github.io/docs/iam/get_service_last_accessed_details_with_entities.html} for full documentation.
}
\keyword{internal}
