% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_initiate_auth}
\alias{cognitoidentityprovider_initiate_auth}
\title{Initiates sign-in for a user in the Amazon Cognito user directory}
\usage{
cognitoidentityprovider_initiate_auth(
  AuthFlow,
  AuthParameters = NULL,
  ClientMetadata = NULL,
  ClientId,
  AnalyticsMetadata = NULL,
  UserContextData = NULL
)
}
\arguments{
\item{AuthFlow}{[required] The authentication flow for this call to run. The API action will depend
on this value. For example:
\itemize{
\item \code{REFRESH_TOKEN_AUTH} takes in a valid refresh token and returns new
tokens.
\item \code{USER_SRP_AUTH} takes in \code{USERNAME} and \code{SRP_A} and returns the SRP
variables to be used for next challenge execution.
\item \code{USER_PASSWORD_AUTH} takes in \code{USERNAME} and \code{PASSWORD} and returns
the next challenge or tokens.
}

Valid values include:
\itemize{
\item \code{USER_SRP_AUTH}: Authentication flow for the Secure Remote Password
(SRP) protocol.
\item \code{REFRESH_TOKEN_AUTH}/\code{REFRESH_TOKEN}: Authentication flow for
refreshing the access token and ID token by supplying a valid
refresh token.
\item \code{CUSTOM_AUTH}: Custom authentication flow.
\item \code{USER_PASSWORD_AUTH}: Non-SRP authentication flow; user name and
password are passed directly. If a user migration Lambda trigger is
set, this flow will invoke the user migration Lambda if it doesn't
find the user name in the user pool.
}

\code{ADMIN_NO_SRP_AUTH} isn't a valid value.}

\item{AuthParameters}{The authentication parameters. These are inputs corresponding to the
\code{AuthFlow} that you're invoking. The required values depend on the value
of \code{AuthFlow}:
\itemize{
\item For \code{USER_SRP_AUTH}: \code{USERNAME} (required), \code{SRP_A} (required),
\code{SECRET_HASH} (required if the app client is configured with a
client secret), \code{DEVICE_KEY}.
\item For \code{USER_PASSWORD_AUTH}: \code{USERNAME} (required), \code{PASSWORD}
(required), \code{SECRET_HASH} (required if the app client is configured
with a client secret), \code{DEVICE_KEY}.
\item For \code{REFRESH_TOKEN_AUTH/REFRESH_TOKEN}: \code{REFRESH_TOKEN} (required),
\code{SECRET_HASH} (required if the app client is configured with a
client secret), \code{DEVICE_KEY}.
\item For \code{CUSTOM_AUTH}: \code{USERNAME} (required), \code{SECRET_HASH} (if app
client is configured with client secret), \code{DEVICE_KEY}. To start the
authentication flow with password verification, include
\code{ChallengeName: SRP_A} and \verb{SRP_A: (The SRP_A Value)}.
}

For more information about \code{SECRET_HASH}, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/signing-up-users-in-your-app.html#cognito-user-pools-computing-secret-hash}{Computing secret hash values}.
For information about \code{DEVICE_KEY}, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html}{Working with user devices in your user pool}.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for
certain custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the InitiateAuth API action, Amazon Cognito
invokes the Lambda functions that are specified for various triggers.
The ClientMetadata value is passed as input to the functions for only
the following triggers:
\itemize{
\item Pre signup
\item Pre authentication
\item User migration
}

When Amazon Cognito invokes the functions for these triggers, it passes
a JSON payload, which the function receives as input. This payload
contains a \code{validationData} attribute, which provides the data that you
assigned to the ClientMetadata parameter in your InitiateAuth request.
In your function code in Lambda, you can process the \code{validationData}
value to enhance your workflow for your specific needs.

When you use the InitiateAuth API action, Amazon Cognito also invokes
the functions for the following triggers, but it doesn't provide the
ClientMetadata value as input:
\itemize{
\item Post authentication
\item Custom message
\item Pre token generation
\item Create auth challenge
\item Define auth challenge
\item Verify auth challenge
}

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}

\item{ClientId}{[required] The app client ID.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata that contributes to your metrics
for \code{\link[=cognitoidentityprovider_initiate_auth]{initiate_auth}} calls.}

\item{UserContextData}{Contextual data about your user session, such as the device fingerprint,
IP address, or location. Amazon Cognito advanced security evaluates the
risk of an authentication event based on the context that your app
generates and passes to Amazon Cognito when it makes API requests.}
}
\description{
Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with \code{\link[=cognitoidentityprovider_initiate_auth]{initiate_auth}}. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html}{Adding user pool sign-in through a third party}.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_initiate_auth/} for full documentation.
}
\keyword{internal}
