% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_data_key_without_plaintext}
\alias{kms_generate_data_key_without_plaintext}
\title{Returns a unique symmetric data key for use outside of KMS}
\usage{
kms_generate_data_key_without_plaintext(
  KeyId,
  EncryptionContext = NULL,
  KeySpec = NULL,
  NumberOfBytes = NULL,
  GrantTokens = NULL,
  DryRun = NULL
)
}
\arguments{
\item{KeyId}{[required] Specifies the symmetric encryption KMS key that encrypts the data key.
You cannot specify an asymmetric KMS key or a KMS key in a custom key
store. To get the type and origin of your KMS key, use the
\code{\link[=kms_describe_key]{describe_key}} operation.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{EncryptionContext}{Specifies the encryption context that will be used when encrypting the
data key.

Do not include confidential or sensitive information in this field. This
field may be displayed in plaintext in CloudTrail logs and other output.

An \emph{encryption context} is a collection of non-secret key-value pairs
that represent additional authenticated data. When you use an encryption
context to encrypt data, you must specify the same (an exact
case-sensitive match) encryption context to decrypt the data. An
encryption context is supported only on operations with symmetric
encryption KMS keys. On operations with symmetric encryption KMS keys,
an encryption context is optional, but it is strongly recommended.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption context}
in the \emph{Key Management Service Developer Guide}.}

\item{KeySpec}{The length of the data key. Use \code{AES_128} to generate a 128-bit
symmetric key, or \code{AES_256} to generate a 256-bit symmetric key.}

\item{NumberOfBytes}{The length of the data key in bytes. For example, use the value 64 to
generate a 512-bit data key (64 bytes is 512 bits). For common key
lengths (128-bit and 256-bit symmetric keys), we recommend that you use
the \code{KeySpec} field instead of this one.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}

\item{DryRun}{Checks if your request will succeed. \code{DryRun} is an optional parameter.

To learn more about how to use this parameter, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html}{Testing your KMS API calls}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Returns a unique symmetric data key for use outside of KMS. This operation returns a data key that is encrypted under a symmetric encryption KMS key that you specify. The bytes in the key are random; they are not related to the caller or to the KMS key.

See \url{https://www.paws-r-sdk.com/docs/kms_generate_data_key_without_plaintext/} for full documentation.
}
\keyword{internal}
