% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_create_web_acl}
\alias{wafv2_create_web_acl}
\title{Creates a WebACL per the specifications provided}
\usage{
wafv2_create_web_acl(
  Name,
  Scope,
  DefaultAction,
  Description = NULL,
  Rules = NULL,
  VisibilityConfig,
  Tags = NULL,
  CustomResponseBodies = NULL,
  CaptchaConfig = NULL,
  ChallengeConfig = NULL,
  TokenDomains = NULL,
  AssociationConfig = NULL
)
}
\arguments{
\item{Name}{[required] The name of the web ACL. You cannot change the name of a web ACL after
you create it.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{DefaultAction}{[required] The action to perform if none of the \code{Rules} contained in the \code{WebACL}
match.}

\item{Description}{A description of the web ACL that helps with identification.}

\item{Rules}{The Rule statements used to identify the web requests that you want to
manage. Each rule includes one top-level statement that WAF uses to
identify matching web requests, and parameters that govern how WAF
handles them.}

\item{VisibilityConfig}{[required] Defines and enables Amazon CloudWatch metrics and web request sample
collection.}

\item{Tags}{An array of key:value pairs to associate with the resource.}

\item{CustomResponseBodies}{A map of custom response keys and content bodies. When you create a rule
with a block action, you can send a custom response to the web request.
You define these for the web ACL, and then use them in the rules and
default actions that you define in the web ACL.

For information about customizing web requests and responses, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html}{Customizing web requests and responses in WAF}
in the \emph{WAF Developer Guide}.

For information about the limits on count and size for custom request
and response settings, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/limits.html}{WAF quotas}
in the \emph{WAF Developer Guide}.}

\item{CaptchaConfig}{Specifies how WAF should handle \code{CAPTCHA} evaluations for rules that
don't have their own \code{CaptchaConfig} settings. If you don't specify
this, WAF uses its default settings for \code{CaptchaConfig}.}

\item{ChallengeConfig}{Specifies how WAF should handle challenge evaluations for rules that
don't have their own \code{ChallengeConfig} settings. If you don't specify
this, WAF uses its default settings for \code{ChallengeConfig}.}

\item{TokenDomains}{Specifies the domains that WAF should accept in a web request token.
This enables the use of tokens across multiple protected websites. When
WAF provides a token, it uses the domain of the Amazon Web Services
resource that the web ACL is protecting. If you don't specify a list of
token domains, WAF accepts tokens only for the domain of the protected
resource. With a token domain list, WAF accepts the resource's host
domain plus all domains in the token domain list, including their
prefixed subdomains.

Example JSON:
\verb{"TokenDomains": \{ "mywebsite.com", "myotherwebsite.com" \}}

Public suffixes aren't allowed. For example, you can't use \code{usa.gov} or
\code{co.uk} as token domains.}

\item{AssociationConfig}{Specifies custom configurations for the associations between the web ACL
and protected resources.

Use this to customize the maximum size of the request body that your
protected CloudFront distributions forward to WAF for inspection. The
default is 16 KB (16,384 bytes).

You are charged additional fees when your protected resources forward
body sizes that are larger than the default. For more information, see
\href{https://aws.amazon.com/waf/pricing/}{WAF Pricing}.}
}
\description{
Creates a WebACL per the specifications provided.

See \url{https://www.paws-r-sdk.com/docs/wafv2_create_web_acl/} for full documentation.
}
\keyword{internal}
