# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include acm_service.R
NULL

#' Adds one or more tags to an ACM certificate
#'
#' @description
#' Adds one or more tags to an ACM certificate. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a `key` and an optional `value`. You specify the certificate on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_add_tags_to_certificate/](https://www.paws-r-sdk.com/docs/acm_add_tags_to_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate to which the tag is
#' to be applied. This must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param Tags &#91;required&#93; The key-value pair that defines the tag. The tag value is optional.
#'
#' @keywords internal
#'
#' @rdname acm_add_tags_to_certificate
acm_add_tags_to_certificate <- function(CertificateArn, Tags) {
  op <- new_operation(
    name = "AddTagsToCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$add_tags_to_certificate_input(CertificateArn = CertificateArn, Tags = Tags)
  output <- .acm$add_tags_to_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$add_tags_to_certificate <- acm_add_tags_to_certificate

#' Deletes a certificate and its associated private key
#'
#' @description
#' Deletes a certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list that can be displayed by calling the [`list_certificates`][acm_list_certificates] action or be retrieved by calling the [`get_certificate`][acm_get_certificate] action. The certificate will not be available for use by Amazon Web Services services integrated with ACM.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_delete_certificate/](https://www.paws-r-sdk.com/docs/acm_delete_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate to be deleted. This
#' must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#'
#' @keywords internal
#'
#' @rdname acm_delete_certificate
acm_delete_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "DeleteCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$delete_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$delete_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$delete_certificate <- acm_delete_certificate

#' Returns detailed metadata about the specified ACM certificate
#'
#' @description
#' Returns detailed metadata about the specified ACM certificate.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_describe_certificate/](https://www.paws-r-sdk.com/docs/acm_describe_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; The Amazon Resource Name (ARN) of the ACM certificate. The ARN must have
#' the following form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#'
#' @keywords internal
#'
#' @rdname acm_describe_certificate
acm_describe_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "DescribeCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$describe_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$describe_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$describe_certificate <- acm_describe_certificate

#' Exports a private certificate issued by a private certificate authority
#' (CA) for use anywhere
#'
#' @description
#' Exports a private certificate issued by a private certificate authority (CA) for use anywhere. The exported file contains the certificate, the certificate chain, and the encrypted private 2048-bit RSA key associated with the public key that is embedded in the certificate. For security, you must assign a passphrase for the private key when exporting it.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_export_certificate/](https://www.paws-r-sdk.com/docs/acm_export_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; An Amazon Resource Name (ARN) of the issued certificate. This must be of
#' the form:
#' 
#' `arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012`
#' @param Passphrase &#91;required&#93; Passphrase to associate with the encrypted exported private key.
#' 
#' When creating your passphrase, you can use any ASCII character except
#' #, $, or %.
#' 
#' If you want to later decrypt the private key, you must have the
#' passphrase. You can use the following OpenSSL command to decrypt a
#' private key. After entering the command, you are prompted for the
#' passphrase.
#' 
#' `openssl rsa -in encrypted_key.pem -out decrypted_key.pem`
#'
#' @keywords internal
#'
#' @rdname acm_export_certificate
acm_export_certificate <- function(CertificateArn, Passphrase) {
  op <- new_operation(
    name = "ExportCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$export_certificate_input(CertificateArn = CertificateArn, Passphrase = Passphrase)
  output <- .acm$export_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$export_certificate <- acm_export_certificate

#' Returns the account configuration options associated with an Amazon Web
#' Services account
#'
#' @description
#' Returns the account configuration options associated with an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_get_account_configuration/](https://www.paws-r-sdk.com/docs/acm_get_account_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname acm_get_account_configuration
acm_get_account_configuration <- function() {
  op <- new_operation(
    name = "GetAccountConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$get_account_configuration_input()
  output <- .acm$get_account_configuration_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$get_account_configuration <- acm_get_account_configuration

#' Retrieves a certificate and its certificate chain
#'
#' @description
#' Retrieves a certificate and its certificate chain. The certificate may be either a public or private certificate issued using the ACM [`request_certificate`][acm_request_certificate] action, or a certificate imported into ACM using the [`import_certificate`][acm_import_certificate] action. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. All of the certificates are base64 encoded. You can use [OpenSSL](https://wiki.openssl.org/index.php/Command_Line_Utilities) to decode the certificates and inspect individual fields.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_get_certificate/](https://www.paws-r-sdk.com/docs/acm_get_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains a certificate ARN in the following format:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#'
#' @keywords internal
#'
#' @rdname acm_get_certificate
acm_get_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "GetCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$get_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$get_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$get_certificate <- acm_get_certificate

#' Imports a certificate into Certificate Manager (ACM) to use with
#' services that are integrated with ACM
#'
#' @description
#' Imports a certificate into Certificate Manager (ACM) to use with services that are integrated with ACM. Note that [integrated services](https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html) allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see [Importing Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_import_certificate/](https://www.paws-r-sdk.com/docs/acm_import_certificate/) for full documentation.
#'
#' @param CertificateArn The [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of an imported certificate to replace. To import a new certificate, omit
#' this field.
#' @param Certificate &#91;required&#93; The certificate to import.
#' @param PrivateKey &#91;required&#93; The private key that matches the public key in the certificate.
#' @param CertificateChain The PEM encoded certificate chain.
#' @param Tags One or more resource tags to associate with the imported certificate.
#' 
#' Note: You cannot apply tags when reimporting a certificate.
#'
#' @keywords internal
#'
#' @rdname acm_import_certificate
acm_import_certificate <- function(CertificateArn = NULL, Certificate, PrivateKey, CertificateChain = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ImportCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$import_certificate_input(CertificateArn = CertificateArn, Certificate = Certificate, PrivateKey = PrivateKey, CertificateChain = CertificateChain, Tags = Tags)
  output <- .acm$import_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$import_certificate <- acm_import_certificate

#' Retrieves a list of certificate ARNs and domain names
#'
#' @description
#' Retrieves a list of certificate ARNs and domain names. By default, the API returns RSA_2048 certificates. To return all certificates in the account, include the `keyType` filter with the values `[RSA_1024, RSA_2048, RSA_3072, RSA_4096, EC_prime256v1, EC_secp384r1, EC_secp521r1]`.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_list_certificates/](https://www.paws-r-sdk.com/docs/acm_list_certificates/) for full documentation.
#'
#' @param CertificateStatuses Filter the certificate list by status value.
#' @param Includes Filter the certificate list. For more information, see the Filters
#' structure.
#' @param NextToken Use this parameter only when paginating results and only in a subsequent
#' request after you receive a response with truncated results. Set it to
#' the value of `NextToken` from the response you just received.
#' @param MaxItems Use this parameter when paginating results to specify the maximum number
#' of items to return in the response. If additional items exist beyond the
#' number you specify, the `NextToken` element is sent in the response. Use
#' this `NextToken` value in a subsequent request to retrieve additional
#' items.
#' @param SortBy Specifies the field to sort results by. If you specify `SortBy`, you
#' must also specify `SortOrder`.
#' @param SortOrder Specifies the order of sorted results. If you specify `SortOrder`, you
#' must also specify `SortBy`.
#'
#' @keywords internal
#'
#' @rdname acm_list_certificates
acm_list_certificates <- function(CertificateStatuses = NULL, Includes = NULL, NextToken = NULL, MaxItems = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCertificates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxItems", output_token = "NextToken", result_key = "CertificateSummaryList")
  )
  input <- .acm$list_certificates_input(CertificateStatuses = CertificateStatuses, Includes = Includes, NextToken = NextToken, MaxItems = MaxItems, SortBy = SortBy, SortOrder = SortOrder)
  output <- .acm$list_certificates_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$list_certificates <- acm_list_certificates

#' Lists the tags that have been applied to the ACM certificate
#'
#' @description
#' Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the [`add_tags_to_certificate`][acm_add_tags_to_certificate] action. To delete a tag, use the [`remove_tags_from_certificate`][acm_remove_tags_from_certificate] action.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_list_tags_for_certificate/](https://www.paws-r-sdk.com/docs/acm_list_tags_for_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate for which you want
#' to list the tags. This must have the following form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#'
#' @keywords internal
#'
#' @rdname acm_list_tags_for_certificate
acm_list_tags_for_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "ListTagsForCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$list_tags_for_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$list_tags_for_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$list_tags_for_certificate <- acm_list_tags_for_certificate

#' Adds or modifies account-level configurations in ACM
#'
#' @description
#' Adds or modifies account-level configurations in ACM.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_put_account_configuration/](https://www.paws-r-sdk.com/docs/acm_put_account_configuration/) for full documentation.
#'
#' @param ExpiryEvents Specifies expiration events associated with an account.
#' @param IdempotencyToken &#91;required&#93; Customer-chosen string used to distinguish between calls to
#' [`put_account_configuration`][acm_put_account_configuration].
#' Idempotency tokens time out after one hour. If you call
#' [`put_account_configuration`][acm_put_account_configuration] multiple
#' times with the same unexpired idempotency token, ACM treats it as the
#' same request and returns the original result. If you change the
#' idempotency token for each call, ACM treats each call as a new request.
#'
#' @keywords internal
#'
#' @rdname acm_put_account_configuration
acm_put_account_configuration <- function(ExpiryEvents = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "PutAccountConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$put_account_configuration_input(ExpiryEvents = ExpiryEvents, IdempotencyToken = IdempotencyToken)
  output <- .acm$put_account_configuration_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$put_account_configuration <- acm_put_account_configuration

#' Remove one or more tags from an ACM certificate
#'
#' @description
#' Remove one or more tags from an ACM certificate. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this function, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_remove_tags_from_certificate/](https://www.paws-r-sdk.com/docs/acm_remove_tags_from_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM Certificate with one or more
#' tags that you want to remove. This must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param Tags &#91;required&#93; The key-value pair that defines the tag to remove.
#'
#' @keywords internal
#'
#' @rdname acm_remove_tags_from_certificate
acm_remove_tags_from_certificate <- function(CertificateArn, Tags) {
  op <- new_operation(
    name = "RemoveTagsFromCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$remove_tags_from_certificate_input(CertificateArn = CertificateArn, Tags = Tags)
  output <- .acm$remove_tags_from_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$remove_tags_from_certificate <- acm_remove_tags_from_certificate

#' Renews an eligible ACM certificate
#'
#' @description
#' Renews an eligible ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your Amazon Web Services Private CA certificates with ACM, you must first [grant the ACM service principal permission to do so](https://docs.aws.amazon.com/privateca/latest/userguide/). For more information, see [Testing Managed Renewal](https://docs.aws.amazon.com/acm/latest/userguide/) in the ACM User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_renew_certificate/](https://www.paws-r-sdk.com/docs/acm_renew_certificate/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate to be renewed. This
#' must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#'
#' @keywords internal
#'
#' @rdname acm_renew_certificate
acm_renew_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "RenewCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$renew_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$renew_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$renew_certificate <- acm_renew_certificate

#' Requests an ACM certificate for use with other Amazon Web Services
#' services
#'
#' @description
#' Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM certificate, you must specify a fully qualified domain name (FQDN) in the `DomainName` parameter. You can also specify additional FQDNs in the `SubjectAlternativeNames` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/acm_request_certificate/](https://www.paws-r-sdk.com/docs/acm_request_certificate/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Fully qualified domain name (FQDN), such as www.example.com, that you
#' want to secure with an ACM certificate. Use an asterisk (*) to create a
#' wildcard certificate that protects several sites in the same domain. For
#' example, *.example.com protects www.example.com, site.example.com, and
#' images.example.com.
#' 
#' In compliance with [RFC
#' 5280](https://datatracker.ietf.org/doc/html/rfc5280), the length of the
#' domain name (technically, the Common Name) that you provide cannot
#' exceed 64 octets (characters), including periods. To add a longer domain
#' name, specify it in the Subject Alternative Name field, which supports
#' names up to 253 octets in length.
#' @param ValidationMethod The method you want to use if you are requesting a public certificate to
#' validate that you own or control domain. You can [validate with
#' DNS](https://docs.aws.amazon.com/acm/latest/userguide/dns-validation.html)
#' or [validate with
#' email](https://docs.aws.amazon.com/acm/latest/userguide/email-validation.html).
#' We recommend that you use DNS validation.
#' @param SubjectAlternativeNames Additional FQDNs to be included in the Subject Alternative Name
#' extension of the ACM certificate. For example, add the name
#' www.example.net to a certificate for which the `DomainName` field is
#' www.example.com if users can reach your site by using either name. The
#' maximum number of domain names that you can add to an ACM certificate is
#' 100. However, the initial quota is 10 domain names. If you need more
#' than 10 names, you must request a quota increase. For more information,
#' see
#' [Quotas](https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
#' 
#' The maximum length of a SAN DNS name is 253 octets. The name is made up
#' of multiple labels separated by periods. No label can be longer than 63
#' octets. Consider the following examples:
#' 
#' -   `(63 octets).(63 octets).(63 octets).(61 octets)` is legal because
#'     the total length is 253 octets (63+1+63+1+63+1+61) and no label
#'     exceeds 63 octets.
#' 
#' -   `(64 octets).(63 octets).(63 octets).(61 octets)` is not legal
#'     because the total length exceeds 253 octets (64+1+63+1+63+1+61) and
#'     the first label exceeds 63 octets.
#' 
#' -   `(63 octets).(63 octets).(63 octets).(62 octets)` is not legal
#'     because the total length of the DNS name (63+1+63+1+63+1+62) exceeds
#'     253 octets.
#' @param IdempotencyToken Customer chosen string that can be used to distinguish between calls to
#' [`request_certificate`][acm_request_certificate]. Idempotency tokens
#' time out after one hour. Therefore, if you call
#' [`request_certificate`][acm_request_certificate] multiple times with the
#' same idempotency token within one hour, ACM recognizes that you are
#' requesting only one certificate and will issue only one. If you change
#' the idempotency token for each call, ACM recognizes that you are
#' requesting multiple certificates.
#' @param DomainValidationOptions The domain name that you want ACM to use to send you emails so that you
#' can validate domain ownership.
#' @param Options Currently, you can use this parameter to specify whether to add the
#' certificate to a certificate transparency log. Certificate transparency
#' makes it possible to detect SSL/TLS certificates that have been
#' mistakenly or maliciously issued. Certificates that have not been logged
#' typically produce an error message in a browser. For more information,
#' see [Opting Out of Certificate Transparency
#' Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
#' @param CertificateAuthorityArn The Amazon Resource Name (ARN) of the private certificate authority (CA)
#' that will be used to issue the certificate. If you do not provide an ARN
#' and you are trying to request a private certificate, ACM will attempt to
#' issue a public certificate. For more information about private CAs, see
#' the [Amazon Web Services Private Certificate
#' Authority](https://docs.aws.amazon.com/privateca/latest/userguide/PcaWelcome.html)
#' user guide. The ARN must have the following form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
#' @param Tags One or more resource tags to associate with the certificate.
#' @param KeyAlgorithm Specifies the algorithm of the public and private key pair that your
#' certificate uses to encrypt data. RSA is the default key algorithm for
#' ACM certificates. Elliptic Curve Digital Signature Algorithm (ECDSA)
#' keys are smaller, offering security comparable to RSA keys but with
#' greater computing efficiency. However, ECDSA is not supported by all
#' network clients. Some Amazon Web Services services may require RSA keys,
#' or only support ECDSA keys of a particular size, while others allow the
#' use of either RSA and ECDSA keys to ensure that compatibility is not
#' broken. Check the requirements for the Amazon Web Services service where
#' you plan to deploy your certificate. For more information about
#' selecting an algorithm, see [Key
#' algorithms](https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms).
#' 
#' Algorithms supported for an ACM certificate request include:
#' 
#' -   `RSA_2048`
#' 
#' -   `EC_prime256v1`
#' 
#' -   `EC_secp384r1`
#' 
#' Other listed algorithms are for imported certificates only.
#' 
#' When you request a private PKI certificate signed by a CA from Amazon
#' Web Services Private CA, the specified signing algorithm family (RSA or
#' ECDSA) must match the algorithm family of the CA's secret key.
#' 
#' Default: RSA_2048
#'
#' @keywords internal
#'
#' @rdname acm_request_certificate
acm_request_certificate <- function(DomainName, ValidationMethod = NULL, SubjectAlternativeNames = NULL, IdempotencyToken = NULL, DomainValidationOptions = NULL, Options = NULL, CertificateAuthorityArn = NULL, Tags = NULL, KeyAlgorithm = NULL) {
  op <- new_operation(
    name = "RequestCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$request_certificate_input(DomainName = DomainName, ValidationMethod = ValidationMethod, SubjectAlternativeNames = SubjectAlternativeNames, IdempotencyToken = IdempotencyToken, DomainValidationOptions = DomainValidationOptions, Options = Options, CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags, KeyAlgorithm = KeyAlgorithm)
  output <- .acm$request_certificate_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$request_certificate <- acm_request_certificate

#' Resends the email that requests domain ownership validation
#'
#' @description
#' Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking **I Approve**. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see [Configure Email for your Domain](https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html).
#'
#' See [https://www.paws-r-sdk.com/docs/acm_resend_validation_email/](https://www.paws-r-sdk.com/docs/acm_resend_validation_email/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the requested certificate. The
#' certificate ARN is generated and returned by the
#' [`request_certificate`][acm_request_certificate] action as soon as the
#' request is made. By default, using this parameter causes email to be
#' sent to all top-level domains you specified in the certificate request.
#' The ARN must be of the form:
#' 
#' `arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' @param Domain &#91;required&#93; The fully qualified domain name (FQDN) of the certificate that needs to
#' be validated.
#' @param ValidationDomain &#91;required&#93; The base validation domain that will act as the suffix of the email
#' addresses that are used to send the emails. This must be the same as the
#' `Domain` value or a superdomain of the `Domain` value. For example, if
#' you requested a certificate for `site.subdomain.example.com` and specify
#' a **ValidationDomain** of `subdomain.example.com`, ACM sends email to
#' the domain registrant, technical contact, and administrative contact in
#' WHOIS and the following five addresses:
#' 
#' -   admin@@subdomain.example.com
#' 
#' -   administrator@@subdomain.example.com
#' 
#' -   hostmaster@@subdomain.example.com
#' 
#' -   postmaster@@subdomain.example.com
#' 
#' -   webmaster@@subdomain.example.com
#'
#' @keywords internal
#'
#' @rdname acm_resend_validation_email
acm_resend_validation_email <- function(CertificateArn, Domain, ValidationDomain) {
  op <- new_operation(
    name = "ResendValidationEmail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$resend_validation_email_input(CertificateArn = CertificateArn, Domain = Domain, ValidationDomain = ValidationDomain)
  output <- .acm$resend_validation_email_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$resend_validation_email <- acm_resend_validation_email

#' Updates a certificate
#'
#' @description
#' Updates a certificate. Currently, you can use this function to specify whether to opt in to or out of recording your certificate in a certificate transparency log. For more information, see [Opting Out of Certificate Transparency Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
#'
#' See [https://www.paws-r-sdk.com/docs/acm_update_certificate_options/](https://www.paws-r-sdk.com/docs/acm_update_certificate_options/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; ARN of the requested certificate to update. This must be of the form:
#' 
#' `arn:aws:acm:us-east-1:account:certificate/12345678-1234-1234-1234-123456789012 `
#' @param Options &#91;required&#93; Use to update the options for your certificate. Currently, you can
#' specify whether to add your certificate to a transparency log.
#' Certificate transparency makes it possible to detect SSL/TLS
#' certificates that have been mistakenly or maliciously issued.
#' Certificates that have not been logged typically produce an error
#' message in a browser.
#'
#' @keywords internal
#'
#' @rdname acm_update_certificate_options
acm_update_certificate_options <- function(CertificateArn, Options) {
  op <- new_operation(
    name = "UpdateCertificateOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .acm$update_certificate_options_input(CertificateArn = CertificateArn, Options = Options)
  output <- .acm$update_certificate_options_output()
  config <- get_config()
  svc <- .acm$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$update_certificate_options <- acm_update_certificate_options
