% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_role_with_web_identity}
\alias{sts_assume_role_with_web_identity}
\title{Returns a set of temporary security credentials for users who have been
authenticated in a mobile or web application with a web identity
provider}
\usage{
sts_assume_role_with_web_identity(
  RoleArn,
  RoleSessionName,
  WebIdentityToken,
  ProviderId = NULL,
  PolicyArns = NULL,
  Policy = NULL,
  DurationSeconds = NULL
)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role that the caller is assuming.

Additional considerations apply to Amazon Cognito identity pools that
assume \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies-cross-account-resource-access.html}{cross-account IAM roles}.
The trust policies of these roles must accept the
\code{cognito-identity.amazonaws.com} service principal and must contain the
\code{cognito-identity.amazonaws.com:aud} condition key to restrict role
assumption to users from your intended identity pools. A policy that
trusts Amazon Cognito identity pools without this condition creates a
risk that a user from an unintended identity pool can assume the role.
For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/iam-roles.html#trust-policies}{Trust policies for IAM roles in Basic (Classic) authentication}
in the \emph{Amazon Cognito Developer Guide}.}

\item{RoleSessionName}{[required] An identifier for the assumed role session. Typically, you pass the name
or identifier that is associated with the user who is using your
application. That way, the temporary security credentials that your
application will use are associated with that user. This session name is
included as part of the ARN and assumed role ID in the \code{AssumedRoleUser}
response element.

For security purposes, administrators can view this field in \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html#cloudtrail-integration_signin-tempcreds}{CloudTrail logs}
to help identify who performed an action in Amazon Web Services. Your
administrator might require that you specify your user name as the
session name when you assume the role. For more information, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_rolesessionname}{\code{sts:RoleSessionName}}
.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{WebIdentityToken}{[required] The OAuth 2.0 access token or OpenID Connect ID token that is provided
by the identity provider. Your application must get this token by
authenticating the user who is using your application with a web
identity provider before the application makes an
\code{\link[=sts_assume_role_with_web_identity]{assume_role_with_web_identity}}
call. Timestamps in the token must be formatted as either an integer or
a long integer. Tokens must be signed using either RSA keys (RS256,
RS384, or RS512) or ECDSA keys (ES256, ES384, or ES512).}

\item{ProviderId}{The fully qualified host component of the domain name of the OAuth 2.0
identity provider. Do not specify this value for an OpenID Connect
identity provider.

Currently \code{www.amazon.com} and \code{graph.facebook.com} are the only
supported identity providers for OAuth 2.0 access tokens. Do not include
URL schemes and port numbers.

Do not specify this value for OpenID Connect ID tokens.}

\item{PolicyArns}{The Amazon Resource Names (ARNs) of the IAM managed policies that you
want to use as managed session policies. The policies must exist in the
same account as the role.

This parameter is optional. You can provide up to 10 managed policy
ARNs. However, the plaintext that you use for both inline and managed
session policies can't exceed 2,048 characters. For more information
about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}
in the Amazon Web Services General Reference.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.

Passing policies to this operation returns new temporary credentials.
The resulting session's permissions are the intersection of the role's
identity-based policy and the session policies. You can use the role's
temporary credentials in subsequent Amazon Web Services API calls to
access resources in the account that owns the role. You cannot use
session policies to grant more permissions than those allowed by the
identity-based policy of the role that is being assumed. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.}

\item{Policy}{An IAM policy in JSON format that you want to use as an inline session
policy.

This parameter is optional. Passing policies to this operation returns
new temporary credentials. The resulting session's permissions are the
intersection of the role's identity-based policy and the session
policies. You can use the role's temporary credentials in subsequent
Amazon Web Services API calls to access resources in the account that
owns the role. You cannot use session policies to grant more permissions
than those allowed by the identity-based policy of the role that is
being assumed. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The plaintext that you use for both inline and managed session policies
can't exceed 2,048 characters. The JSON policy characters can be any
ASCII character from the space character to the end of the valid
character list (\code{U+0020} through \verb{U+00FF}). It can also include the tab
(\code{U+0009}), linefeed (\verb{U+000A}), and carriage return (\verb{U+000D}) characters.

For more information about role session permissions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session policies}.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.}

\item{DurationSeconds}{The duration, in seconds, of the role session. The value can range from
900 seconds (15 minutes) up to the maximum session duration setting for
the role. This setting can have a value from 1 hour to 12 hours. If you
specify a value higher than this setting, the operation fails. For
example, if you specify a session duration of 12 hours, but your
administrator set the maximum session duration to 6 hours, your
operation fails. To learn how to view the maximum value for your role,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}.

By default, the value is set to \code{3600} seconds.

The \code{DurationSeconds} parameter is separate from the duration of a
console session that you might request using the returned credentials.
The request to the federation endpoint for a console sign-in token takes
a \code{SessionDuration} parameter that specifies the maximum length of the
console session. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html}{Creating a URL that Enables Federated Users to Access the Amazon Web Services Management Console}
in the \emph{IAM User Guide}.}
}
\description{
Returns a set of temporary security credentials for users who have been authenticated in a mobile or web application with a web identity provider. Example providers include the OAuth 2.0 providers Login with Amazon and Facebook, or any OpenID Connect-compatible identity provider such as Google or \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html}{Amazon Cognito federated identities}.

See \url{https://www.paws-r-sdk.com/docs/sts_assume_role_with_web_identity/} for full documentation.
}
\keyword{internal}
