% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_objects}
\alias{s3_delete_objects}
\title{This operation enables you to delete multiple objects from a bucket
using a single HTTP request}
\usage{
s3_delete_objects(Bucket, Delete, MFA, RequestPayer,
  BypassGovernanceRetention)
}
\arguments{
\item{Bucket}{[required]}

\item{Delete}{[required]}

\item{MFA}{The concatenation of the authentication device's serial number, a
space, and the value that is displayed on your authentication device.}

\item{RequestPayer}{}

\item{BypassGovernanceRetention}{Specifies whether you want to delete this object even if it has a
Governance-type object lock in place. You must have sufficient
permissions to perform this operation.}
}
\description{
This operation enables you to delete multiple objects from a bucket
using a single HTTP request. You may specify up to 1000 keys.
}
\section{Request syntax}{
\preformatted{svc$delete_objects(
  Bucket = "string",
  Delete = list(
    Objects = list(
      list(
        Key = "string",
        VersionId = "string"
      )
    ),
    Quiet = TRUE|FALSE
  ),
  MFA = "string",
  RequestPayer = "requester",
  BypassGovernanceRetention = TRUE|FALSE
)
}
}

\examples{
# The following example deletes objects from a bucket. The request
# specifies object versions. S3 deletes specific object versions and
# returns the key and versions of deleted objects in the response.
\donttest{svc$delete_objects(
  Bucket = "examplebucket",
  Delete = list(
    Objects = list(
      list(
        Key = "HappyFace.jpg",
        VersionId = "2LWg7lQLnY41.maGB5Z6SWW.dcq0vx7b"
      ),
      list(
        Key = "HappyFace.jpg",
        VersionId = "yoz3HB.ZhCS_tKVEmIOr7qYyyAaZSKVd"
      )
    ),
    Quiet = FALSE
  )
)}

# The following example deletes objects from a bucket. The bucket is
# versioned, and the request does not specify the object version to
# delete. In this case, all versions remain in the bucket and S3 adds a
# delete marker.
\donttest{svc$delete_objects(
  Bucket = "examplebucket",
  Delete = list(
    Objects = list(
      list(
        Key = "objectkey1"
      ),
      list(
        Key = "objectkey2"
      )
    ),
    Quiet = FALSE
  )
)}

}
\keyword{internal}
