% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_update_data_repository_association}
\alias{fsx_update_data_repository_association}
\title{Updates the configuration of an existing data repository association on
an Amazon FSx for Lustre file system}
\usage{
fsx_update_data_repository_association(
  AssociationId,
  ClientRequestToken = NULL,
  ImportedFileChunkSize = NULL,
  S3 = NULL
)
}
\arguments{
\item{AssociationId}{[required] The ID of the data repository association that you are updating.}

\item{ClientRequestToken}{}

\item{ImportedFileChunkSize}{For files imported from a data repository, this value determines the
stripe count and maximum amount of data per file (in MiB) stored on a
single physical disk. The maximum number of disks that a single file can
be striped across is limited by the total number of disks that make up
the file system.

The default chunk size is 1,024 MiB (1 GiB) and can go as high as
512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.}

\item{S3}{The configuration for an Amazon S3 data repository linked to an Amazon
FSx Lustre file system with a data repository association. The
configuration defines which file events (new, changed, or deleted files
or directories) are automatically imported from the linked data
repository to the file system or automatically exported from the file
system to the data repository.}
}
\description{
Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding \code{scratch_1} deployment type.

See \url{https://www.paws-r-sdk.com/docs/fsx_update_data_repository_association/} for full documentation.
}
\keyword{internal}
