% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_location}
\alias{s3_get_bucket_location}
\title{Returns the Region the bucket resides in}
\usage{
s3_get_bucket_location(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the location.

To use this API operation against an access point, provide the alias of
the access point in place of the bucket name.

To use this API operation against an Object Lambda access point, provide
the alias of the Object Lambda access point in place of the bucket name.
If the Object Lambda access point alias in a request is not valid, the
error code \code{InvalidAccessPointAliasError} is returned. For more
information about \code{InvalidAccessPointAliasError}, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList}{List of Error Codes}.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns the Region the bucket resides in. You set the bucket's Region using the \code{LocationConstraint} request parameter in a \code{\link[=s3_create_bucket]{create_bucket}} request. For more information, see \code{\link[=s3_create_bucket]{create_bucket}}.

See \url{https://www.paws-r-sdk.com/docs/s3_get_bucket_location/} for full documentation.
}
\keyword{internal}
