% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_access_point}
\alias{s3control_create_access_point}
\title{Creates an access point and associates it with the specified bucket}
\usage{
s3control_create_access_point(
  AccountId,
  Name,
  Bucket,
  VpcConfiguration = NULL,
  PublicAccessBlockConfiguration = NULL,
  BucketAccountId = NULL
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID for the account that owns the
specified access point.}

\item{Name}{[required] The name you want to assign to this access point.}

\item{Bucket}{[required] The name of the bucket that you want to associate this access point
with.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the Amazon Web
Services SDK and CLI, you must specify the ARN of the bucket accessed in
the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>}.
For example, to access the bucket \code{reports} through Outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}

\item{VpcConfiguration}{If you include this field, Amazon S3 restricts access to this access
point to requests from the specified virtual private cloud (VPC).

This is required for creating an access point for Amazon S3 on Outposts
buckets.}

\item{PublicAccessBlockConfiguration}{The \code{PublicAccessBlock} configuration that you want to apply to the
access point.}

\item{BucketAccountId}{The Amazon Web Services account ID associated with the S3 bucket
associated with this access point.}
}
\description{
Creates an access point and associates it with the specified bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html}{Managing Data Access with Amazon S3 Access Points} in the \emph{Amazon S3 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3control_create_access_point/} for full documentation.
}
\keyword{internal}
