% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_logically_air_gapped_backup_vault}
\alias{backup_create_logically_air_gapped_backup_vault}
\title{Creates a logical container to where backups may be copied}
\usage{
backup_create_logically_air_gapped_backup_vault(
  BackupVaultName,
  BackupVaultTags = NULL,
  CreatorRequestId = NULL,
  MinRetentionDays,
  MaxRetentionDays
)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Logically
air-gapped backup vaults are identified by names that are unique to the
account used to create them and the Region where they are created.}

\item{BackupVaultTags}{The tags to assign to the vault.}

\item{CreatorRequestId}{The ID of the creation request.

This parameter is optional. If used, this parameter must contain 1 to 50
alphanumeric or '-_.' characters.}

\item{MinRetentionDays}{[required] This setting specifies the minimum retention period that the vault
retains its recovery points.

The minimum value accepted is 7 days.}

\item{MaxRetentionDays}{[required] The maximum retention period that the vault retains its recovery points.}
}
\description{
Creates a logical container to where backups may be copied.

See \url{https://www.paws-r-sdk.com/docs/backup_create_logically_air_gapped_backup_vault/} for full documentation.
}
\keyword{internal}
