% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{globalaccelerator}
\alias{globalaccelerator}
\title{AWS Global Accelerator}
\usage{
globalaccelerator(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
This is the \emph{AWS Global Accelerator API Reference}. This guide is for
developers who need detailed information about AWS Global Accelerator
API actions, data types, and errors. For more information about Global
Accelerator features, see the \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/}{AWS Global Accelerator Developer Guide}.

AWS Global Accelerator is a service in which you create \emph{accelerators}
to improve the performance of your applications for local and global
users. Depending on the type of accelerator you choose, you can gain
additional benefits.
\itemize{
\item By using a standard accelerator, you can improve availability of
your internet applications that are used by a global audience. With
a standard accelerator, Global Accelerator directs traffic to
optimal endpoints over the AWS global network.
\item For other scenarios, you might choose a custom routing accelerator.
With a custom routing accelerator, you can use application logic to
directly map one or more users to a specific endpoint among many
endpoints.
}

Global Accelerator is a global service that supports endpoints in
multiple AWS Regions but you must specify the US West (Oregon) Region to
create or update accelerators.

By default, Global Accelerator provides you with two static IP addresses
that you associate with your accelerator. With a standard accelerator,
instead of using the IP addresses that Global Accelerator provides, you
can configure these entry points to be IPv4 addresses from your own IP
address ranges that you bring to Global Accelerator. The static IP
addresses are anycast from the AWS edge network. For a standard
accelerator, they distribute incoming application traffic across
multiple endpoint resources in multiple AWS Regions, which increases the
availability of your applications. Endpoints for standard accelerators
can be Network Load Balancers, Application Load Balancers, Amazon EC2
instances, or Elastic IP addresses that are located in one AWS Region or
multiple Regions. For custom routing accelerators, you map traffic that
arrives to the static IP addresses to specific Amazon EC2 servers in
endpoints that are virtual private cloud (VPC) subnets.

The static IP addresses remain assigned to your accelerator for as long
as it exists, even if you disable the accelerator and it no longer
accepts or routes traffic. However, when you \emph{delete} an accelerator,
you lose the static IP addresses that are assigned to it, so you can no
longer route traffic by using them. You can use IAM policies like
tag-based permissions with Global Accelerator to limit the users who
have permissions to delete an accelerator. For more information, see
\href{https://docs.aws.amazon.com/global-accelerator/latest/dg/}{Tag-based policies}.

For standard accelerators, Global Accelerator uses the AWS global
network to route traffic to the optimal regional endpoint based on
health, client location, and policies that you configure. The service
reacts instantly to changes in health or configuration to ensure that
internet traffic from clients is always directed to healthy endpoints.

For a list of the AWS Regions where Global Accelerator and other
services are currently supported, see the AWS Region Table.

AWS Global Accelerator includes the following components:
\subsection{Static IP addresses}{

Global Accelerator provides you with a set of two static IP addresses
that are anycast from the AWS edge network. If you bring your own IP
address range to AWS (BYOIP) to use with a standard accelerator, you can
instead assign IP addresses from your own pool to use with your
accelerator. For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html}{Bring your own IP addresses (BYOIP) in AWS Global Accelerator}.

The IP addresses serve as single fixed entry points for your clients. If
you already have Elastic Load Balancing load balancers, Amazon EC2
instances, or Elastic IP address resources set up for your applications,
you can easily add those to a standard accelerator in Global
Accelerator. This allows Global Accelerator to use static IP addresses
to access the resources.

The static IP addresses remain assigned to your accelerator for as long
as it exists, even if you disable the accelerator and it no longer
accepts or routes traffic. However, when you \emph{delete} an accelerator,
you lose the static IP addresses that are assigned to it, so you can no
longer route traffic by using them. You can use IAM policies like
tag-based permissions with Global Accelerator to delete an accelerator.
For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/}{Tag-based policies}.
}

\subsection{Accelerator}{

An accelerator directs traffic to endpoints over the AWS global network
to improve the performance of your internet applications. Each
accelerator includes one or more listeners.

There are two types of accelerators:
\itemize{
\item A \emph{standard} accelerator directs traffic to the optimal AWS endpoint
based on several factors, including the user’s location, the health
of the endpoint, and the endpoint weights that you configure. This
improves the availability and performance of your applications.
Endpoints can be Network Load Balancers, Application Load Balancers,
Amazon EC2 instances, or Elastic IP addresses.
\item A \emph{custom routing} accelerator directs traffic to one of possibly
thousands of Amazon EC2 instances running in a single or multiple
virtual private clouds (VPCs). With custom routing, listener ports
are mapped to statically associate port ranges with VPC subnets,
which allows Global Accelerator to determine an EC2 instance IP
address at the time of connection. By default, all port mapping
destinations in a VPC subnet can't receive traffic. You can choose
to configure all destinations in the subnet to receive traffic, or
to specify individual port mappings that can receive traffic.
}

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-accelerator-types.html}{Types of accelerators}.
}

\subsection{DNS name}{

Global Accelerator assigns each accelerator a default Domain Name System
(DNS) name, similar to \code{a1234567890abcdef.awsglobalaccelerator.com},
that points to the static IP addresses that Global Accelerator assigns
to you or that you choose from your own IP address range. Depending on
the use case, you can use your accelerator's static IP addresses or DNS
name to route traffic to your accelerator, or set up DNS records to
route traffic using your own custom domain name.
}

\subsection{Network zone}{

A network zone services the static IP addresses for your accelerator
from a unique IP subnet. Similar to an AWS Availability Zone, a network
zone is an isolated unit with its own set of physical infrastructure.
When you configure an accelerator, by default, Global Accelerator
allocates two IPv4 addresses for it. If one IP address from a network
zone becomes unavailable due to IP address blocking by certain client
networks, or network disruptions, then client applications can retry on
the healthy static IP address from the other isolated network zone.
}

\subsection{Listener}{

A listener processes inbound connections from clients to Global
Accelerator, based on the port (or port range) and protocol (or
protocols) that you configure. A listener can be configured for TCP,
UDP, or both TCP and UDP protocols. Each listener has one or more
endpoint groups associated with it, and traffic is forwarded to
endpoints in one of the groups. You associate endpoint groups with
listeners by specifying the Regions that you want to distribute traffic
to. With a standard accelerator, traffic is distributed to optimal
endpoints within the endpoint groups associated with a listener.
}

\subsection{Endpoint group}{

Each endpoint group is associated with a specific AWS Region. Endpoint
groups include one or more endpoints in the Region. With a standard
accelerator, you can increase or reduce the percentage of traffic that
would be otherwise directed to an endpoint group by adjusting a setting
called a \emph{traffic dial}. The traffic dial lets you easily do performance
testing or blue/green deployment testing, for example, for new releases
across different AWS Regions.
}

\subsection{Endpoint}{

An endpoint is a resource that Global Accelerator directs traffic to.

Endpoints for standard accelerators can be Network Load Balancers,
Application Load Balancers, Amazon EC2 instances, or Elastic IP
addresses. An Application Load Balancer endpoint can be internet-facing
or internal. Traffic for standard accelerators is routed to endpoints
based on the health of the endpoint along with configuration options
that you choose, such as endpoint weights. For each endpoint, you can
configure weights, which are numbers that you can use to specify the
proportion of traffic to route to each one. This can be useful, for
example, to do performance testing within a Region.

Endpoints for custom routing accelerators are virtual private cloud
(VPC) subnets with one or many EC2 instances.
}
}
\section{Service syntax}{
\preformatted{svc <- globalaccelerator(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=globalaccelerator_add_custom_routing_endpoints]{add_custom_routing_endpoints} \tab Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator\cr
\link[=globalaccelerator_advertise_byoip_cidr]{advertise_byoip_cidr} \tab Advertises an IPv4 address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP)\cr
\link[=globalaccelerator_allow_custom_routing_traffic]{allow_custom_routing_traffic} \tab Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator\cr
\link[=globalaccelerator_create_accelerator]{create_accelerator} \tab Create an accelerator\cr
\link[=globalaccelerator_create_custom_routing_accelerator]{create_custom_routing_accelerator} \tab Create a custom routing accelerator\cr
\link[=globalaccelerator_create_custom_routing_endpoint_group]{create_custom_routing_endpoint_group} \tab Create an endpoint group for the specified listener for a custom routing accelerator\cr
\link[=globalaccelerator_create_custom_routing_listener]{create_custom_routing_listener} \tab Create a listener to process inbound connections from clients to a custom routing accelerator\cr
\link[=globalaccelerator_create_endpoint_group]{create_endpoint_group} \tab Create an endpoint group for the specified listener\cr
\link[=globalaccelerator_create_listener]{create_listener} \tab Create a listener to process inbound connections from clients to an accelerator\cr
\link[=globalaccelerator_delete_accelerator]{delete_accelerator} \tab Delete an accelerator\cr
\link[=globalaccelerator_delete_custom_routing_accelerator]{delete_custom_routing_accelerator} \tab Delete a custom routing accelerator\cr
\link[=globalaccelerator_delete_custom_routing_endpoint_group]{delete_custom_routing_endpoint_group} \tab Delete an endpoint group from a listener for a custom routing accelerator\cr
\link[=globalaccelerator_delete_custom_routing_listener]{delete_custom_routing_listener} \tab Delete a listener for a custom routing accelerator\cr
\link[=globalaccelerator_delete_endpoint_group]{delete_endpoint_group} \tab Delete an endpoint group from a listener\cr
\link[=globalaccelerator_delete_listener]{delete_listener} \tab Delete a listener from an accelerator\cr
\link[=globalaccelerator_deny_custom_routing_traffic]{deny_custom_routing_traffic} \tab Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator\cr
\link[=globalaccelerator_deprovision_byoip_cidr]{deprovision_byoip_cidr} \tab Releases the specified address range that you provisioned to use with your AWS resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool\cr
\link[=globalaccelerator_describe_accelerator]{describe_accelerator} \tab Describe an accelerator\cr
\link[=globalaccelerator_describe_accelerator_attributes]{describe_accelerator_attributes} \tab Describe the attributes of an accelerator\cr
\link[=globalaccelerator_describe_custom_routing_accelerator]{describe_custom_routing_accelerator} \tab Describe a custom routing accelerator\cr
\link[=globalaccelerator_describe_custom_routing_accelerator_attributes]{describe_custom_routing_accelerator_attributes} \tab Describe the attributes of a custom routing accelerator\cr
\link[=globalaccelerator_describe_custom_routing_endpoint_group]{describe_custom_routing_endpoint_group} \tab Describe an endpoint group for a custom routing accelerator\cr
\link[=globalaccelerator_describe_custom_routing_listener]{describe_custom_routing_listener} \tab The description of a listener for a custom routing accelerator\cr
\link[=globalaccelerator_describe_endpoint_group]{describe_endpoint_group} \tab Describe an endpoint group\cr
\link[=globalaccelerator_describe_listener]{describe_listener} \tab Describe a listener\cr
\link[=globalaccelerator_list_accelerators]{list_accelerators} \tab List the accelerators for an AWS account\cr
\link[=globalaccelerator_list_byoip_cidrs]{list_byoip_cidrs} \tab Lists the IP address ranges that were specified in calls to ProvisionByoipCidr, including the current state and a history of state changes\cr
\link[=globalaccelerator_list_custom_routing_accelerators]{list_custom_routing_accelerators} \tab List the custom routing accelerators for an AWS account\cr
\link[=globalaccelerator_list_custom_routing_endpoint_groups]{list_custom_routing_endpoint_groups} \tab List the endpoint groups that are associated with a listener for a custom routing accelerator\cr
\link[=globalaccelerator_list_custom_routing_listeners]{list_custom_routing_listeners} \tab List the listeners for a custom routing accelerator\cr
\link[=globalaccelerator_list_custom_routing_port_mappings]{list_custom_routing_port_mappings} \tab Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator\cr
\link[=globalaccelerator_list_custom_routing_port_mappings_by_destination]{list_custom_routing_port_mappings_by_destination} \tab List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint\cr
\link[=globalaccelerator_list_endpoint_groups]{list_endpoint_groups} \tab List the endpoint groups that are associated with a listener\cr
\link[=globalaccelerator_list_listeners]{list_listeners} \tab List the listeners for an accelerator\cr
\link[=globalaccelerator_list_tags_for_resource]{list_tags_for_resource} \tab List all tags for an accelerator\cr
\link[=globalaccelerator_provision_byoip_cidr]{provision_byoip_cidr} \tab Provisions an IP address range to use with your AWS resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool\cr
\link[=globalaccelerator_remove_custom_routing_endpoints]{remove_custom_routing_endpoints} \tab Remove endpoints from a custom routing accelerator\cr
\link[=globalaccelerator_tag_resource]{tag_resource} \tab Add tags to an accelerator resource\cr
\link[=globalaccelerator_untag_resource]{untag_resource} \tab Remove tags from a Global Accelerator resource\cr
\link[=globalaccelerator_update_accelerator]{update_accelerator} \tab Update an accelerator\cr
\link[=globalaccelerator_update_accelerator_attributes]{update_accelerator_attributes} \tab Update the attributes for an accelerator\cr
\link[=globalaccelerator_update_custom_routing_accelerator]{update_custom_routing_accelerator} \tab Update a custom routing accelerator\cr
\link[=globalaccelerator_update_custom_routing_accelerator_attributes]{update_custom_routing_accelerator_attributes} \tab Update the attributes for a custom routing accelerator\cr
\link[=globalaccelerator_update_custom_routing_listener]{update_custom_routing_listener} \tab Update a listener for a custom routing accelerator\cr
\link[=globalaccelerator_update_endpoint_group]{update_endpoint_group} \tab Update an endpoint group\cr
\link[=globalaccelerator_update_listener]{update_listener} \tab Update a listener\cr
\link[=globalaccelerator_withdraw_byoip_cidr]{withdraw_byoip_cidr} \tab Stops advertising an address range that is provisioned as an address pool
}
}

\examples{
\dontrun{
svc <- globalaccelerator()
svc$add_custom_routing_endpoints(
  Foo = 123
)
}

}
