% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{fms}
\alias{fms}
\title{Firewall Management Service}
\usage{
fms(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS Firewall Manager

This is the \emph{AWS Firewall Manager API Reference}. This guide is for
developers who need detailed information about the AWS Firewall Manager
API actions, data types, and errors. For detailed information about AWS
Firewall Manager features, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/fms-chapter.html}{AWS Firewall Manager Developer Guide}.

Some API actions require explicit resource permissions. For information,
see the developer guide topic \href{https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html}{Firewall Manager required permissions for API actions}.
}
\section{Service syntax}{
\preformatted{svc <- fms(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=fms_associate_admin_account]{associate_admin_account} \tab Sets the AWS Firewall Manager administrator account\cr
\link[=fms_delete_apps_list]{delete_apps_list} \tab Permanently deletes an AWS Firewall Manager applications list\cr
\link[=fms_delete_notification_channel]{delete_notification_channel} \tab Deletes an AWS Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record AWS Firewall Manager SNS logs\cr
\link[=fms_delete_policy]{delete_policy} \tab Permanently deletes an AWS Firewall Manager policy\cr
\link[=fms_delete_protocols_list]{delete_protocols_list} \tab Permanently deletes an AWS Firewall Manager protocols list\cr
\link[=fms_disassociate_admin_account]{disassociate_admin_account} \tab Disassociates the account that has been set as the AWS Firewall Manager administrator account\cr
\link[=fms_get_admin_account]{get_admin_account} \tab Returns the AWS Organizations master account that is associated with AWS Firewall Manager as the AWS Firewall Manager administrator\cr
\link[=fms_get_apps_list]{get_apps_list} \tab Returns information about the specified AWS Firewall Manager applications list\cr
\link[=fms_get_compliance_detail]{get_compliance_detail} \tab Returns detailed compliance information about the specified member account\cr
\link[=fms_get_notification_channel]{get_notification_channel} \tab Information about the Amazon Simple Notification Service (SNS) topic that is used to record AWS Firewall Manager SNS logs\cr
\link[=fms_get_policy]{get_policy} \tab Returns information about the specified AWS Firewall Manager policy\cr
\link[=fms_get_protection_status]{get_protection_status} \tab If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack\cr
\link[=fms_get_protocols_list]{get_protocols_list} \tab Returns information about the specified AWS Firewall Manager protocols list\cr
\link[=fms_get_violation_details]{get_violation_details} \tab Retrieves violations for a resource based on the specified AWS Firewall Manager policy and AWS account\cr
\link[=fms_list_apps_lists]{list_apps_lists} \tab Returns an array of AppsListDataSummary objects\cr
\link[=fms_list_compliance_status]{list_compliance_status} \tab Returns an array of PolicyComplianceStatus objects\cr
\link[=fms_list_member_accounts]{list_member_accounts} \tab Returns a MemberAccounts object that lists the member accounts in the administrator's AWS organization\cr
\link[=fms_list_policies]{list_policies} \tab Returns an array of PolicySummary objects\cr
\link[=fms_list_protocols_lists]{list_protocols_lists} \tab Returns an array of ProtocolsListDataSummary objects\cr
\link[=fms_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves the list of tags for the specified AWS resource\cr
\link[=fms_put_apps_list]{put_apps_list} \tab Creates an AWS Firewall Manager applications list\cr
\link[=fms_put_notification_channel]{put_notification_channel} \tab Designates the IAM role and Amazon Simple Notification Service (SNS) topic that AWS Firewall Manager uses to record SNS logs\cr
\link[=fms_put_policy]{put_policy} \tab Creates an AWS Firewall Manager policy\cr
\link[=fms_put_protocols_list]{put_protocols_list} \tab Creates an AWS Firewall Manager protocols list\cr
\link[=fms_tag_resource]{tag_resource} \tab Adds one or more tags to an AWS resource\cr
\link[=fms_untag_resource]{untag_resource} \tab Removes one or more tags from an AWS resource
}
}

\examples{
\dontrun{
svc <- fms()
svc$associate_admin_account(
  Foo = 123
)
}

}
