% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{applicationautoscaling}
\alias{applicationautoscaling}
\title{Application Auto Scaling}
\usage{
applicationautoscaling()
}
\description{
With Application Auto Scaling, you can configure automatic scaling for
your scalable resources. You can use Application Auto Scaling to
accomplish the following tasks:
\itemize{
\item Define scaling policies to automatically scale your AWS or custom
resources
\item Scale your resources in response to CloudWatch alarms
\item Schedule one-time or recurring scaling actions
\item View the history of your scaling events
}

Application Auto Scaling can scale the following resources:
\itemize{
\item Amazon ECS services. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html}{Service Auto Scaling}
in the \emph{Amazon Elastic Container Service Developer Guide}.
\item Amazon EC2 Spot fleets. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-auto-scaling.html}{Automatic Scaling for Spot Fleet}
in the \emph{Amazon EC2 User Guide}.
\item Amazon EMR clusters. For more information, see \href{https://docs.aws.amazon.com/ElasticMapReduce/latest/ManagementGuide/emr-automatic-scaling.html}{Using Automatic Scaling in Amazon EMR}
in the \emph{Amazon EMR Management Guide}.
\item AppStream 2.0 fleets. For more information, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/autoscaling.html}{Fleet Auto Scaling for Amazon AppStream 2.0}
in the \emph{Amazon AppStream 2.0 Developer Guide}.
\item Provisioned read and write capacity for Amazon DynamoDB tables and
global secondary indexes. For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/AutoScaling.html}{Managing Throughput Capacity Automatically with DynamoDB Auto Scaling}
in the \emph{Amazon DynamoDB Developer Guide}.
\item Amazon Aurora Replicas. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Integrating.AutoScaling.html}{Using Amazon Aurora Auto Scaling with Aurora Replicas}.
\item Amazon SageMaker endpoint variants. For more information, see
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-auto-scaling.html}{Automatically Scaling Amazon SageMaker Models}.
\item Custom resources provided by your own applications or services. More
information is available in our \href{https://github.com/aws/aws-auto-scaling-custom-resource}{GitHub repository}.
}

To learn more about Application Auto Scaling, including information
about granting IAM users required permissions for Application Auto
Scaling actions, see the \href{https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html}{Application Auto Scaling User Guide}.
}
\section{Operations}{

\tabular{ll}{
\link[=applicationautoscaling_delete_scaling_policy]{delete_scaling_policy} \tab Deletes the specified Application Auto Scaling scaling policy \cr
\link[=applicationautoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified Application Auto Scaling scheduled action \cr
\link[=applicationautoscaling_deregister_scalable_target]{deregister_scalable_target} \tab Deregisters a scalable target \cr
\link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets} \tab Gets information about the scalable targets in the specified namespace \cr
\link[=applicationautoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks\cr
\link[=applicationautoscaling_describe_scaling_policies]{describe_scaling_policies} \tab Describes the scaling policies for the specified service namespace \cr
\link[=applicationautoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Describes the scheduled actions for the specified service namespace \cr
\link[=applicationautoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a policy for an Application Auto Scaling scalable target \cr
\link[=applicationautoscaling_put_scheduled_action]{put_scheduled_action} \tab Creates or updates a scheduled action for an Application Auto Scaling scalable target \cr
\link[=applicationautoscaling_register_scalable_target]{register_scalable_target} \tab Registers or updates a scalable target
}
}

\examples{
# This example deletes a scaling policy for the Amazon ECS service called
# web-app, which is running in the default cluster.
\donttest{svc <- applicationautoscaling()
svc$delete_scaling_policy(
  PolicyName = "web-app-cpu-lt-25",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs"
)}

}
