% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{kafkaconnect}
\alias{kafkaconnect}
\title{Managed Streaming for Kafka Connect}
\usage{
kafkaconnect(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Managed Streaming for Kafka Connect
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- kafkaconnect(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.analytics:kafkaconnect_create_connector]{create_connector} \tab Creates a connector using the specified properties\cr
\link[paws.analytics:kafkaconnect_create_custom_plugin]{create_custom_plugin} \tab Creates a custom plugin using the specified properties\cr
\link[paws.analytics:kafkaconnect_create_worker_configuration]{create_worker_configuration} \tab Creates a worker configuration using the specified properties\cr
\link[paws.analytics:kafkaconnect_delete_connector]{delete_connector} \tab Deletes the specified connector\cr
\link[paws.analytics:kafkaconnect_delete_custom_plugin]{delete_custom_plugin} \tab Deletes a custom plugin\cr
\link[paws.analytics:kafkaconnect_describe_connector]{describe_connector} \tab Returns summary information about the connector\cr
\link[paws.analytics:kafkaconnect_describe_custom_plugin]{describe_custom_plugin} \tab A summary description of the custom plugin\cr
\link[paws.analytics:kafkaconnect_describe_worker_configuration]{describe_worker_configuration} \tab Returns information about a worker configuration\cr
\link[paws.analytics:kafkaconnect_list_connectors]{list_connectors} \tab Returns a list of all the connectors in this account and Region\cr
\link[paws.analytics:kafkaconnect_list_custom_plugins]{list_custom_plugins} \tab Returns a list of all of the custom plugins in this account and Region\cr
\link[paws.analytics:kafkaconnect_list_worker_configurations]{list_worker_configurations} \tab Returns a list of all of the worker configurations in this account and Region\cr
\link[paws.analytics:kafkaconnect_update_connector]{update_connector} \tab Updates the specified connector
}
}

\examples{
\dontrun{
svc <- kafkaconnect()
svc$create_connector(
  Foo = 123
)
}

}
