% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.r
\name{base.descinit}
\alias{base.descinit}
\title{descinit}
\usage{
base.descinit(dim, bldim, ldim, ICTXT = 0)
}
\arguments{
\item{dim}{Global dim.}

\item{bldim}{Blocking dim.}

\item{ldim}{Local dim.}

\item{ICTXT}{BLACS context.}
}
\value{
A descriptor array.
}
\description{
Creates ScaLAPACK descriptor array.
}
\details{
For advanced users only. See pbdDMAT for high-level functions.
}
\examples{
spmd.code <- "
  suppressMessages(library(pbdMPI))
  suppressMessages(library(pbdBASE))
  init.grid()

  ### Set desc.
  dim <- c(6L, 5L)
  bldim <- c(3L, 3L)
  ldim <- base.numroc(dim = dim, bldim = bldim)
  descx <- base.descinit(dim = dim, bldim = bldim, ldim = ldim)
  comm.print(descx)

  finalize()
"
pbdMPI::execmpi(spmd.code = spmd.code, nranks = 2L)

}
