% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_prcomp.R
\docType{methods}
\name{ddmatrix-prcomp}
\alias{ddmatrix-prcomp}
\alias{prcomp}
\alias{prcomp,ddmatrix-method}
\title{Principal Components Analysis}
\usage{
prcomp(x, ...)

\S4method{prcomp}{ddmatrix}(x, retx = TRUE, center = TRUE, scale. = FALSE,
  tol = NULL, ...)
}
\arguments{
\item{x}{numeric distributed matrix.}

\item{...}{Ignored.}

\item{retx}{logical, indicates whether the rotated variables should be
returned}

\item{center}{logical value, determines whether or not columns are zero
centered}

\item{scale.}{logical value, determines whether or not columns are rescaled
to unit variance}

\item{tol}{a value indicating the magnitude below which components should be
omitted. (Components are omitted if their standard deviations are less than
or equal to \code{tol} times the standard deviation of the first component.)
With the default null setting, no components are omitted.  Other settings
for tol could be \code{tol = 0} or \code{tol = sqrt(.Machine$double.eps)},
which would omit essentially constant components}
}
\value{
Returns a list.
}
\description{
Performs the principal components analysis.
}
\details{
\code{prcomp()} performs the principal components analysis on the data
matrix by taking the SVD. Sometimes core R and pbdDMAT will disagree
slightly in what the rotated variables are because of how the SVD is
caluclated.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

comm.set.seed(diff=T)

x <- ddmatrix("rnorm", 10, 10)

y <- prcomp(x)
comm.print(y)

finalize()
}

}
\keyword{Methods}

