\name{gmG}
\alias{gmG}
\docType{data}
\title{Graphical Model 8-Dimensional Gaussian Example Data}
\description{
This data set contains a matrix containing information on eight gaussian
variables and the corresonding DAG model.
}
\usage{data(gmG)}
\format{
  The format is a list of two components
  \describe{
    \item{x:}{num [1:5000, 1:8] 0.181 0.354 0.504 0.701 -0.705 ...}
    \item{g:}{Formal class 'graphNEL' [package "graph"] with 6 slots\cr
      .. ..@ nodes     : chr [1:8] "1" "2" "3" "4" ...\cr
      .. ..@ edgeL     :List of 8\cr
      ........
    }
  }
}
\details{
The data was generated as indicated below. First, a random DAG model was
generated, then 5000 samples were drawn from this model.
}
\source{
  The data set is \code{\link{identical}} to the one generated by
  % \code{
 \preformatted{
    ## Used to generate "gmG" 
    set.seed(40)
    p <- 8
    n <- 5000
    gGtrue <- randomDAG(p, prob = 0.3) ## true DAG
    gmG <- list(x = rmvDAG(n, gGtrue), g = gGtrue)
  }
  %}% code
}
\examples{
data(gmG)
str(gmG, max=3)
pairs(gmG$x, gap = 0,
      panel=function(...) smoothScatter(..., add=TRUE))
}
\keyword{datasets}
