% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceUGFunctions.R
\name{IedgeASbasic.tri}
\alias{IedgeASbasic.tri}
\title{The indicator for the presence of an edge from a point to another
for the underlying or reflexivity graph of
Arc Slice Proximity Catch Digraphs (AS-PCDs) -
standard basic triangle case}
\usage{
IedgeASbasic.tri(
  p1,
  p2,
  c1,
  c2,
  M = "CC",
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{p1}{A 2D point whose AS proximity region is constructed.}

\item{p2}{A 2D point. The function determines
whether there is an edge from \code{p1} to \code{p1} or not
in the underlying or reflexivity graph of AS-PCDs.}

\item{c1, c2}{Positive real numbers
which constitute the vertex of the standard basic triangle
adjacent to the shorter edges;
\eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{The center of the triangle. \code{"CC"} stands for
circumcenter of the triangle \eqn{T_b}
or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates
which serves as a center in the interior of \eqn{T_b};
default is \code{M="CC"}, i.e., the circumcenter of \eqn{T_b}.}

\item{ugraph}{The type of the graph based on AS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Returns 1 if there is an edge between points \code{p1} and \code{p2}
in the underlying or reflexivity graph of AS-PCDs
in the standard basic triangle, and 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p1p2} is an edge
in the underlying or reflexivity graph of AS-PCDs \eqn{)}
for points \code{p1} and \code{p2} in the standard basic triangle.

More specifically, when the argument \code{ugraph="underlying"},
it returns the edge indicator for the AS-PCD underlying graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{AS}(p1)} **or** \code{p1} is in \eqn{N_{AS}(p2)},
returns 0 otherwise.
On the other hand,
when \code{ugraph="reflexivity"}, it returns
the edge indicator for the AS-PCD reflexivity graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{AS}(p1)} **and** \code{p1} is in \eqn{N_{AS}(p2)},
returns 0 otherwise.

AS proximity region is constructed in the standard basic triangle
\eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \leq 1}.

Vertex regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the standard basic triangle \eqn{T_b}
or based on circumcenter of \eqn{T_b};
default is \code{M="CC"}, i.e., circumcenter of \eqn{T_b}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \eqn{T_b}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations (i.e., it allows loops).

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle.
Hence, standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);

M<-as.numeric(pcds::runif.basic.tri(1,c1,c2)$g)
set.seed(4)
P1<-as.numeric(pcds::runif.basic.tri(1,c1,c2)$g)
P2<-as.numeric(pcds::runif.basic.tri(1,c1,c2)$g)
IedgeASbasic.tri(P1,P2,c1,c2,M)
IedgeASbasic.tri(P1,P2,c1,c2,M,ugraph = "reflexivity")

P1<-c(.4,.2)
P2<-c(.5,.26)
IedgeASbasic.tri(P1,P2,c1,c2,M)
IedgeASbasic.tri(P1,P2,c1,c2,M,ugraph="r")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IedgeAStri}}, \code{\link{IedgeCSbasic.tri}},
\code{\link{IedgePEbasic.tri}} and \code{\link[pcds]{IarcASbasic.tri}}
}
\author{
Elvan Ceyhan
}
