% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{IedgePEstd.tri}
\alias{IedgePEstd.tri}
\title{The indicator for the presence of an edge from a point to another
for the underlying or reflexivity graph of
Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
standard equilateral triangle case}
\usage{
IedgePEstd.tri(
  p1,
  p2,
  r,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{p1}{A 2D point whose PE proximity region is constructed.}

\item{p2}{A 2D point. The function determines
whether there is an edge from \code{p1} to \code{p2} or not
in the underlying or reflexivity graph of PE-PCDs.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Returns 1 if there is an edge between points \code{p1} and \code{p2}
in the underlying or reflexivity graph of PE-PCDs
in the standard equilateral triangle, and 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p1p2} is an edge
in the underlying or reflexivity graph of PE-PCDs \eqn{)}
for points \code{p1} and \code{p2} in the standard equilateral triangle.

More specifically,
when the argument \code{ugraph="underlying"}, it returns
the edge indicator for points \code{p1} and \code{p2}
in the standard equilateral triangle,
for the PE-PCD underlying graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{PE}(p1,r)} **or** \code{p1} is in \eqn{N_{PE}(p2,r)},
returns 0 otherwise.
On the other hand,
when \code{ugraph="reflexivity"}, it returns
the edge indicator for points \code{p1} and \code{p2}
in the standard equilateral triangle,
for the PE-PCD reflexivity graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{PE}(p1,r)} **and** \code{p1} is in \eqn{N_{PE}(p2,r)},
returns 0 otherwise.

In both cases \eqn{N_{PE}(x,r)} is the PE proximity region
for point \eqn{x} with expansion parameter \eqn{r \ge 1}.
PE proximity region is defined
with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \eqn{T_e}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations (i.e., it allows loops).

See also
(\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
n<-3

set.seed(1)
Xp<-pcds::runif.std.tri(n)$gen.points

M<-as.numeric(pcds::runif.std.tri(1)$g)

IedgePEstd.tri(Xp[1,],Xp[3,],r=1.5,M)
IedgePEstd.tri(Xp[1,],Xp[3,],r=1.5,M,ugraph="reflexivity")

P1<-c(.4,.2)
P2<-c(.5,.26)
r<-2
IedgePEstd.tri(P1,P2,r,M)
IedgePEstd.tri(P1,P2,r,M,ugraph = "reflexivity")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IedgePEbasic.tri}}, \code{\link{IedgePEtri}},
and \code{\link[pcds]{IarcPEstd.tri}}
}
\author{
Elvan Ceyhan
}
