% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{funsMuVarUndCS2D}
\alias{funsMuVarUndCS2D}
\alias{muOrCS2D}
\alias{muAndCS2D}
\alias{mu.undCS2D}
\alias{asyvarOrCS2D}
\alias{asyvarAndCS2D}
\alias{asy.var.undCS2D}
\title{Returns the mean and (asymptotic) variance of edge density of
underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraph (CS-PCD)
for 2D uniform data in one triangle}
\usage{
muOrCS2D(t)

muAndCS2D(t)

mu.undCS2D(t, ugraph = c("underlying", "reflexivity"))

asyvarOrCS2D(t)

asyvarAndCS2D(t)

asy.var.undCS2D(t, ugraph = c("underlying", "reflexivity"))
}
\arguments{
\item{t}{A positive real number which serves
as the expansion parameter in CS proximity region.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
\code{mu.undCS2D} returns the mean
and \code{asyvarUndOrCS2D} returns the (asymptotic) variance of the
edge density of the underlying graph of the CS-PCD for uniform data in any triangle
if \code{ugraph="underlying"},
and those of the reflexivity graph if \code{ugraph="reflexivity"}.
The functions \code{muOrCS2D}, \code{muAndCS2D}, \code{asyvarOrCS2D},
and \code{asyvarAndCS2D} are the corresponding mean and asymptotic variance functions
for the edge density of the reflexivity graph of the CS-PCD, respectively,
for uniform data in any triangle.
}
\description{
The mean and (asymptotic) variance functions
for the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs):
\code{muOrCS2D} and \code{asyvarOrCS2D} for the underlying graph
and
\code{muAndCS2D} and \code{asyvarAndCS2D} for the reflexivity graph.

\code{muOrCS2D} and \code{muAndCS2D} return the mean of the (edge) density of
the underlying or reflexivity graphs of CS-PCDs, respectively,
for 2D uniform data in a triangle.
Similarly, \code{asyvarOrCS2D} and \code{asyvarAndCS2D} return the asymptotic variance
of the edge density of the underlying or reflexivity graphs of CS-PCDs, respectively,
for 2D uniform data in a triangle.

CS proximity regions are defined with expansion parameter \eqn{t > 0}
with respect to the triangle in which the points reside and
edge regions are based on center of mass, \eqn{CM} of the triangle.

See also (\insertCite{ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
mu.undCS2D(1.2)
mu.undCS2D(1.2,ugraph="r")

tseq<-seq(0.01,10,by=.05)
ltseq<-length(tseq)

muOR = muAND <- vector()
for (i in 1:ltseq)
{
  muOR<-c(muOR,mu.undCS2D(tseq[i]))
  muAND<-c(muAND,mu.undCS2D(tseq[i],ugraph="r"))
}

plot(tseq, muOR,type="l",xlab="t",ylab=expression(mu(t)),lty=1,
     xlim=range(tseq),ylim=c(0,1))
lines(tseq,muAND,type="l",lty=2,col=2)
legend("bottomright", inset=.02,
       legend=c(expression(mu[or](t)),expression(mu[and](t))),
       lty=1:2,col=1:2)
#}

#\donttest{
asy.var.undCS2D(1.2)
asy.var.undCS2D(1.2,ugraph="r")

asyvarOrCS2D(.2)

tseq<-seq(.05,25,by=.05)
ltseq<-length(tseq)

avarOR<-avarAND<-vector()
for (i in 1:ltseq)
{
  avarOR<-c(avarOR,asy.var.undCS2D(tseq[i]))
  avarAND<-c(avarAND,asy.var.undCS2D(tseq[i],ugraph="r"))
}

oldpar <- par(mar=c(5,5,4,2))
plot(tseq, 4*avarAND,type="l",lty=2,col=2,xlab="t",
     ylab=expression(paste(sigma^2,"(t)")),xlim=range(tseq))
lines(tseq,4*avarOR,type="l")
legend(18,.1,
       legend=c(expression(paste(sigma["underlying"]^"2","(t)")),
                 expression(paste(sigma["reflexivity"]^"2","(t)")) ),
       lty=1:2,col=1:2)

par(oldpar)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mu.undCS2D}}, \code{\link{asy.var.undCS2D}}
\code{\link[pcds]{muCS2D}}, and \code{\link[pcds]{asyvarCS2D}},
}
\author{
Elvan Ceyhan
}
