% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{funsMuVarUndPE2D}
\alias{funsMuVarUndPE2D}
\alias{muOrPE2D}
\alias{muAndPE2D}
\alias{mu.undPE2D}
\alias{asyvarOrPE2D}
\alias{asyvarAndPE2D}
\alias{asy.var.undPE2D}
\title{Returns the mean and (asymptotic) variance of edge density of
underlying or reflexivity graph of
Proportional Edge Proximity Catch Digraph (PE-PCD)
for 2D uniform data in one triangle}
\usage{
muOrPE2D(r)

muAndPE2D(r)

mu.undPE2D(r, ugraph = c("underlying", "reflexivity"))

asyvarOrPE2D(r)

asyvarAndPE2D(r)

asy.var.undPE2D(r, ugraph = c("underlying", "reflexivity"))
}
\arguments{
\item{r}{A positive real number which serves
as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
\code{mu.undPE2D} returns the mean
and \code{asyvarUndOrPE2D} returns the (asymptotic) variance of the
edge density of the underlying graph of the PE-PCD for uniform data in any triangle
if \code{ugraph="underlying"}, and those of the reflexivity graph if \code{ugraph="reflexivity"}.
The functions \code{muOrPE2D}, \code{muAndPE2D}, \code{asyvarOrPE2D},
and \code{asyvarAndPE2D} are the corresponding mean
and asymptotic variance functions
for the edge density of the reflexivity graph of the PE-PCD,
respectively, for uniform data in any triangle.
}
\description{
The mean and (asymptotic) variance functions
for the underlying or reflexivity graph of
Proportional Edge Proximity Catch Digraphs (PE-PCDs):
\code{muOrPE2D} and \code{asyvarOrPE2D} for the underlying graph
and
\code{muAndPE2D} and \code{asyvarAndPE2D} for the reflexivity graph.

\code{muOrPE2D} and \code{muAndPE2D} return the mean of the (edge) density of
the underlying or reflexivity graph of PE-PCDs, respectively,
for 2D uniform data in a triangle.
Similarly,
\code{asyvarOrPE2D} and \code{asyvarAndPE2D} return the asymptotic variance
of the edge density of the underlying or reflexivity graph of PE-PCDs,
respectively, for 2D uniform data in a triangle.

PE proximity regions are defined with expansion parameter \eqn{r \ge 1}
with respect to the triangle in which the points reside and
vertex regions are based on center of mass, \eqn{CM} of the triangle.

See also (\insertCite{ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
mu.undPE2D(1.2)
mu.undPE2D(1.2,ugraph="r")

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

muOR = muAND <- vector()
for (i in 1:lrseq)
{
  muOR<-c(muOR,mu.undPE2D(rseq[i]))
  muAND<-c(muAND,mu.undPE2D(rseq[i],ugraph="r"))
}

plot(rseq, muOR,type="l",xlab="r",ylab=expression(mu(r)),lty=1,
     xlim=range(rseq),ylim=c(0,1))
lines(rseq,muAND,type="l",lty=2,col=2)
legend("bottomright", inset=.02,
       legend=c(expression(mu[or](r)),expression(mu[and](r))),
       lty=1:2,col=1:2)
#}

#\donttest{
asy.var.undPE2D(1.2)
asy.var.undPE2D(1.2,ugraph="r")

rseq<-seq(1.01,5,by=.05)
lrseq<-length(rseq)

avarOR<-avarAND<-vector()
for (i in 1:lrseq)
{
  avarOR<-c(avarOR,asy.var.undPE2D(rseq[i]))
  avarAND<-c(avarAND,asy.var.undPE2D(rseq[i],ugraph="r"))
}

oldpar <- par(mar=c(5,5,4,2))
plot(rseq, avarAND,type="l",lty=2,col=2,xlab="r",
     ylab=expression(paste(sigma^2,"(r)")),xlim=range(rseq))
lines(rseq,avarOR,type="l")
legend(3.75,.02,
       legend=c(expression(paste(sigma["underlying"]^"2","(r)")),
                 expression(paste(sigma["reflexivity"]^"2","(r)")) ),
       lty=1:2,col=1:2)

par(oldpar)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mu.undCS2D}}, \code{\link{asy.var.undCS2D}},
\code{\link[pcds]{muPE2D}}, \code{\link[pcds]{asyvarPE2D}},
\code{\link{muAndCS2D}}, and \code{\link{asyvarAndCS2D}}
}
\author{
Elvan Ceyhan
}
